/*
 * Created on 2004/12/17
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.AlarmInformation;


/**
 * A[̎擾AA[mFs\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandAlarmControl extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /**
     * A[擾܂́AA[mFs\bhłB
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        
        AlarmInformation alarmInfo = com.getAlarmInformation();

        ArrayList alarmInfoList = null;

        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();

        try {
            if (
                alarmInfo.getSubCommand().equals(
                        AlarmInformation.ALARM_LIST_GET)) {
                /* A[擾 */
                alarmInfoList =
                    alarmDBTable.findAllAlarm(
                        alarmInfo.getLimit(), alarmInfo.getSelectIPAddress(),
                        alarmInfo.getSortColumn(), alarmInfo.getSortDirection());
            } else if (
                alarmInfo.getSubCommand().equals(
                        AlarmInformation.ALARM_ID_CONFIRM)) {
                /* wA[IDmFς݂Ƃ */
                alarmDBTable.updateAlarmIDConfirm(
                    alarmInfo.getSelectIPAddress(), alarmInfo.getAlarmID());
            } else if (
                alarmInfo.getSubCommand().equals(
                        AlarmInformation.ALARM_ADDRESS_CONFIRM)) {
                /* SA[mFς݂Ƃ */
                alarmDBTable.updateAllAlarmIDConfirm(alarmInfo.getIpaddress());
            }
        } catch (SQLException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (Exception e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            alarmDBTable = null;
        }

        sendResponse(alarmInfoList, ois, oos);
    }
}
