/*
 * Created on 2004/12/15
 *
 *
 *
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.ConnectionNodeMapLink;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;


/**
 * m[hMap̎悷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandNodeMapLinkInormationGet extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /**
     * m[hMap̎悵܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        final CommandInfo com, final ObjectInputStream ois,
        ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        DBTableMapLink nodeMapLinkDBTable = new DBTableMapLink();

        NodeMapLinkInformation nodMapLinkinfo = null;
        NodeMapLinkInformation nodeMapInfo = com.getNodeMapLinkInfo();

        try {
            if (
                nodeMapInfo.getSubCommand().equals(
                        ConnectionNodeMapLink.NODE_MAPLINK_GET)) {
                logger.info("Get Node MapLink");
                nodMapLinkinfo = nodeMapLinkDBTable.findAll();
            } else if (
                nodeMapInfo.getSubCommand().equals(
                        ConnectionNodeMapLink.NODE_MAPLINK_UPDATE)) {
                nodeMapLinkDBTable.updateNodeMapLink(
                    com.getNodeMapLinkInfo(), true);
                nodMapLinkinfo = nodeMapLinkDBTable.findAll();
            } else if (
                nodeMapInfo.getSubCommand().equals(
                        ConnectionNodeMapLink.NODE_MAPLINK_DELETE)) {
                nodeMapLinkDBTable.updateNodeMapLink(
                    com.getNodeMapLinkInfo(), true);
            } else if (
                nodeMapInfo.getSubCommand().equals(
                        ConnectionNodeMapLink.NODE_MAPLINK_SET)) {
                nodeMapLinkDBTable.updateNodeMapLink(
                    com.getNodeMapLinkInfo(), false);
            }
        } catch (SQLException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (DatabaseConnectionException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }

        sendResponse(nodMapLinkinfo, ois, oos);
    }
}
