/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.node.EditorNodeConfig;
import netjfwatcher.engine.view.editorpart.node.EditorNodeOperation;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;


/**
 * m[hɊւANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderNodeOperation extends Action {
    /*
     * OIEditorParti[(ANVɈUClose邽)
     */
    private static IEditorPart editorNodeConfigView;

    /* MO */
    private static Logger logger;

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /* m[h̍\`\ANV */
    private IAction showNodeView = new ActionShowNodeView();

    /* lbg[NoRł̃m[h̍\`\ANV */
    private IAction showNodeViewSocket = new ActionShowNodeViewSocket();

    /* m[hǉEҏWE폜ANV */
    private IAction nodeOperationAction = new ActionNodeOperation();

    /* lbg[NoRł̃m[hǉEҏWE폜ANV */
    private IAction nodeOperationActionSocket = new ActionNodeOperationSocket();

    /**
     * m[hɊւANVNXCX^X𐶐܂B
     *
     */
    public ActionBuilderNodeOperation() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[h̍\`\ANVԂ܂B
     *
     * @return showNodeView m[h̍\`\ANV
     */
    public IAction getActionShowNodeView() {
        return showNodeView;
    }

    /**
     * lbg[NoRł̃m[h̍\`\ANVԂ܂B
     *
     * @return showNodeViewSocket lbg[NoRł̃m[h̍\
     * `\ANV
     */
    public IAction getActionShowNodeViewSocket() {
        return showNodeViewSocket;
    }

    /**
     * m[hǉEҏWE폜ANVԂ܂B
     *
     * @return nodeOperationAction m[hǉEҏWE폜ANV
     */
    public IAction getActionNodeOperation() {
        return nodeOperationAction;
    }

    /**
     * lbg[NoRł̃m[hǉEҏWE폜ANVԂ܂B
     *
     * @return nodeOperationActionSocket lbg[NoRł̃m[h
     * ǉEҏWE폜ANV
     */
    public IAction getActionNodeOperationSocket() {
        return nodeOperationActionSocket;
    }

    /**
     * m[hɊւANV`钊ۃNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractNodeAction extends Action {
        /**
         * ANVs܂B
         */
        public final void run() {
            doTask();
        }

        /**
         * ANVs^XNłB
         *
         */
        protected abstract void doTask();

        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/file_obj.gif"));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Node View";
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "Node View";
        }
    }

    /**
     * m[h̍\`\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public final class ActionShowNodeView extends AbstractNodeAction {
        /* m[hĎ */
        private NodeInformation nodeInfo;

        /**
         * m[h̍\`\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            /* Tree\NodeZbg */
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                /*
                 * IꂽGg̃m[hURLEditorɃuEU
                 * I[v
                 * EditorID̓uEŨNX
                 */
                activePage.openEditor(
                    new EditorInputNodeView(
                        nodeName + EditorNodeConfig.TITLE_SUFFIX, nodeInfo,
                        false), EditorNodeConfig.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * lbg[NoRł̃m[h̍\`\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public final class ActionShowNodeViewSocket extends AbstractNodeAction {
        /* m[hĎ */
        private NodeInformation nodeInfo;

        /**
         * m[h̍\`\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            /* Tree\NodeZbg */
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                /*
                 * IꂽGg̃m[hURLEditorɃuEU
                 * I[v
                 * EditorID̓uEŨNX
                 */
                activePage.openEditor(
                    new EditorInputNodeView(
                        nodeName + EditorNodeConfig.TITLE_SUFFIX
                        + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(),
                        nodeInfo, true), EditorNodeConfig.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * m[h̒ǉAҏWyэ폜sANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionNodeOperation extends AbstractNodeAction {
        /* m[hĎ */
        protected NodeInformation nodeInfo;

        /**
         * m[hǉEҏWE폜ImageDescriptorԂ܂B
         *
         * @return m[h̑ViewANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/configs.gif"));
        }

        /**
         * m[h̑ViewANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Node Add/Edit/Delete";
        }

        /**
         * m[h̑ViewANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "Node Add/Edit/Delete";
        }

        /**
         * m[h̑View\܂B
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            if (nodeInfo == null) {
                nodeInfo = new NodeInformation();
                nodeInfo.setIpaddress(null);
            }

            try {
                /*
                 * EditorɃuEUI[v
                 */
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            EditorNodeOperation.TITLE_SUFFIX, nodeInfo, false),
                        EditorNodeOperation.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * lbg[NoRł̃m[h̒ǉAҏWyэ폜sANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionNodeOperationSocket extends ActionNodeOperation {
        /**
         * m[h̑View\܂B
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            if (nodeInfo == null) {
                nodeInfo = new NodeInformation();
                nodeInfo.setIpaddress(null);
            }

            try {
                /*
                 * EditorɃuEUI[v
                 */
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            EditorNodeOperation.TITLE_SUFFIX
                            + NetworkClientNodeTreeView
                            .getTitleSuffixEngineAddress(), nodeInfo, true),
                        EditorNodeOperation.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
