/*
 * Created on 2005/05/31
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.thread;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.command.control.CommnadReceiveServer;
import netjfwatcher.engine.mail.ThreadMailSendGuard;
import netjfwatcher.engine.model.action.EngineThreadList;
import netjfwatcher.engine.server.holdperiod.ThreadPeriodHoldCheck;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushDatabaseWatchControl;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushDefaultSnmpMib;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushHTTPControl;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushPingControl;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushPop3Control;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushSmtpControl;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushStatisticMibControl;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckDatabaseWatch;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckDefaultSnmpMibGet;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckHTTP;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckPing;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckPop3;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckSmtp;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckStatisticsMibGet;
import netjfwatcher.engine.server.xmlsocket.XMLSocketServer;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;


/**
 * GW̊eThread̐yыNsNXłB
 *
 * ESocket ClientyWebAvCommand Receive socket Thread Start
 * EXML SocketT[o
 * EĎThread E
 *    EPingsm[hXgL[ւPushThreadEX^[g
 *    EvMIB̎sm[hXgL[ւPushThreadEX^[g
 *    EftHgSNMP̎ThreadEX^[g
 * EMailMK[hThread
 * EDatabase limit check Thread
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ManageEngineThread implements Runnable {
    /** PingĎTread */
    public static final int PING_CHECK_THREAD_NO = 10;

    /** SNMPĎTread */
    public static final int DEFAULT_SNMP_THREAD_NO = 10;

    /** SNMPv̎Tread */
    public static final int STATISTICS_MIB_THREAD_NO = 10;

    /** HTTPĎTread */
    public static final int HTTP_CHECK_THREAD_NO = 10;

    /** Pop3ĎTread */
    public static final int POP3_CHECK_THREAD_NO = 10;

    /** SMTPĎTread */
    public static final int SMTP_CHECK_THREAD_NO = 10;

    /** DatabaseĎTread */
    public static final int DATABASE_CHECK_THREAD_NO = 10;
    
    /* MO */
    private static Logger logger;

    /**
     * GW̊eThread̐yыNsNXX^X
     * ܂B
     */
    public ManageEngineThread() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * eĎThreadX^[g܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾Ɏsꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void startThread() throws DatabaseConnectionException, SQLException {
        try {
            // Command Receive socket Thread Start
            CommnadReceiveServer.getInstance().startThread();

            EngineThreadList.getInstance().setThreadList(
                EngineThreadList.COMMAND_RECEIVE_THREAD,
                CommnadReceiveServer.getInstance().getCommandReceiveThread());
        } catch (IOException e) {
            logger.warning("Command receive thread error. " + e.getMessage());

            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Command receive thread error",
                "Command receive thread error, " + e.getMessage());
            shell.dispose();
            e.printStackTrace();
        }

        try {
            XMLSocketServer xmlsocketserver = XMLSocketServer.getInstance();
            xmlsocketserver.startXMLSocketServerThread();
            EngineThreadList.getInstance().setThreadList(
                EngineThreadList.XML_SOCKET_THREAD,
                xmlsocketserver.getXmlSocketServerThread());
        } catch (IOException e) {
            logger.warning("XML Socket thread error. " + e.getMessage());

            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "XML Socket receive thread error",
                "XML Socket receive thread error, " + e.getMessage());
            shell.dispose();
            e.printStackTrace();
        }

        ManageEngineThread engineThread = new ManageEngineThread();
        Thread thread = new Thread(engineThread);
        thread.start();
    }

    /**
     * ThreadEX^[g
     */
    public void run() {
        // PingsThreadEX^[g
        Thread pingThread;

        for (int i = 0; i < PING_CHECK_THREAD_NO; i++) {
            pingThread = new Thread(new ThreadQueueCheckPing());
            pingThread.start();
            EngineThreadList.getInstance().setThreadList(
                EngineThreadList.PING_EXEC_THREAD + i, pingThread);
        }

        // vMIB̎ThreadEX^[g
        Thread statisticsMibGetThread;

        for (int i = 0; i < STATISTICS_MIB_THREAD_NO; i++) {
            statisticsMibGetThread =
                new Thread(new ThreadQueueCheckStatisticsMibGet());
            statisticsMibGetThread.start();
            EngineThreadList.getInstance().setThreadList(
                EngineThreadList.SNMP_STATISTICS_THREAD + i,
                statisticsMibGetThread);
        }

        // ftHgSNMP̎ThreadEX^[g
        Thread defaultSnmpMibGetThread;

        for (int i = 0; i < DEFAULT_SNMP_THREAD_NO; i++) {
            defaultSnmpMibGetThread =
                new Thread(new ThreadQueueCheckDefaultSnmpMibGet());
            defaultSnmpMibGetThread.start();
            EngineThreadList.getInstance().setThreadList(
                EngineThreadList.SNMP_CONFIG_THREAD + i, defaultSnmpMibGetThread);
        }

        // Pingsm[hXgL[ւPushThreadEX^[g
        Thread pingListCheck =
            new Thread(new ThreadListReadQueuePushPingControl());
        pingListCheck.start();
        EngineThreadList.getInstance().setThreadList(
            EngineThreadList.PING_QUEUE_THREAD, pingListCheck);

        // vMIB̎sm[hXgL[ւPushThreadEX^[g
        Thread statisticsMibListCheck =
            new Thread(new ThreadListReadQueuePushStatisticMibControl());
        statisticsMibListCheck.start();
        EngineThreadList.getInstance().setThreadList(
            EngineThreadList.SNMP_STATISTICS_QUEUE_THREAD,
            statisticsMibListCheck);

        // ftHgSNMP̎sm[hXgL[ւPushThreadEX^[g
        Thread defaultSnmpMibListCheck =
            new Thread(new ThreadListReadQueuePushDefaultSnmpMib());
        defaultSnmpMibListCheck.start();
        EngineThreadList.getInstance().setThreadList(
            EngineThreadList.SNMP_CONFIG_QUEUE_THREAD, defaultSnmpMibListCheck);

        /*
         * MailMK[hThread
         */
        ThreadMailSendGuard.getInstance().startThread();

        EngineThreadList.getInstance().setThreadList(
            EngineThreadList.MAIL_GUARD_THREAD,
            ThreadMailSendGuard.getInstance().getMailGuardThread());

        /*
         * Database limit check Thread
         */
        ThreadPeriodHoldCheck.getInstance().startThread();

        EngineThreadList.getInstance().setThreadList(
            EngineThreadList.DATABASE_LIMIT_CHECK_THREAD,
            ThreadPeriodHoldCheck.getInstance().getPeriodHoldCheckThread());

        /*
         * HTTPsThreadEX^[g
         */
        Thread httpThread;

        for (int i = 0; i < HTTP_CHECK_THREAD_NO; i++) {
            httpThread = new Thread(new ThreadQueueCheckHTTP());
            httpThread.start();
            EngineThreadList.getInstance().setThreadList(
                EngineThreadList.HTTP_THREAD + i, httpThread);
        }

        /*
         * HTTPsm[hXgL[ւPushThreadEX^[g
         */
        Thread httpListCheck =
            new Thread(new ThreadListReadQueuePushHTTPControl());
        httpListCheck.start();
        EngineThreadList.getInstance().setThreadList(
            EngineThreadList.HTTP_QUEUE_THREAD, httpListCheck);

        /*
         * Pop3sThreadEX^[g
         */
        Thread pop3Thread;

        for (int i = 0; i < POP3_CHECK_THREAD_NO; i++) {
            pop3Thread = new Thread(new ThreadQueueCheckPop3());
            pop3Thread.start();
            EngineThreadList.getInstance().setThreadList(
                EngineThreadList.POP3_THREAD + i, pop3Thread);
        }

        /*
         * Pop3sm[hXgL[ւPushThreadEX^[g
         */
        Thread pop3ListCheck =
            new Thread(new ThreadListReadQueuePushPop3Control());
        pop3ListCheck.start();
        EngineThreadList.getInstance().setThreadList(
            EngineThreadList.POP3_QUEUE_THREAD, pop3ListCheck);

        /*
         * SMTPsThreadEX^[g
         */
        Thread smtpThread;

        for (int i = 0; i < SMTP_CHECK_THREAD_NO; i++) {
            smtpThread = new Thread(new ThreadQueueCheckSmtp());
            smtpThread.start();
            EngineThreadList.getInstance().setThreadList(
                EngineThreadList.SMTP_THREAD + i, smtpThread);
        }

        /*
         * SMTPsm[hXgL[ւPushThreadEX^[g
         */
        Thread smtpListCheck =
            new Thread(new ThreadListReadQueuePushSmtpControl());
        smtpListCheck.start();
        EngineThreadList.getInstance().setThreadList(
            EngineThreadList.SMTP_QUEUE_THREAD, smtpListCheck);
        
        
        /*
         * DatabaseĎsThreadEX^[g
         */
        Thread databaseThread;

        for (int i = 0; i < DATABASE_CHECK_THREAD_NO; i++) {
        	databaseThread = new Thread(new ThreadQueueCheckDatabaseWatch());
        	databaseThread.start();
            EngineThreadList.getInstance().setThreadList(
                EngineThreadList.DATABASE_THREAD + i, databaseThread);
        }

        /*
         * DatabaseĎsm[hXgL[ւPushThreadEX^[g
         */
        Thread databaseListCheck =
            new Thread(new ThreadListReadQueuePushDatabaseWatchControl());
        databaseListCheck.start();
        EngineThreadList.getInstance().setThreadList(
            EngineThreadList.DATABASE_QUEUE_THREAD, databaseListCheck);
    }
}
