/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.map;

import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.ping.EditorNodePingResponseData;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;



/**
 * m[hMapł̃m[hIconIj[ŁAPinge[u\I
 * ꍇ s郁\bhSelectionAdapterNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapMenuNodePingTable extends SelectionAdapter {
    /* MO */
    private static Logger logger;

    /* m[hĎ */
    private NodeInformation nodeInfo;

    /*
     * SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     */
    protected boolean isSocket;

    /**
     * m[hMapł̃m[hIconIj[ŁAPinge[u\
     * Iꍇ s郁\bhSelectionAdapter
     * NXCX^X𐶐܂B
     *
     * @param nodeInfo m[hĎ
     * @param isSocket SocketɂăT[of[^擾邩tO
     */
    public NodeMapMenuNodePingTable(NodeInformation nodeInfo, boolean isSocket) {
        logger = Logger.getLogger(this.getClass().getName());
        this.nodeInfo = nodeInfo;
        this.isSocket = isSocket;
    }

    /**
     * m[hIconIj[ŁAPinge[u\IXi[łB
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        String nodeName =
            nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            /*
            * IꂽGg̃m[hURLEditorɃuEU
            * I[v
            * EditorID̓uEŨNX
            */
            activePage.openEditor(
                new EditorInputNodeView(
                    nodeName + EditorNodePingResponseData.TITLE_SUFFIX, nodeInfo,
                    isSocket), EditorNodePingResponseData.class.getName());
        } catch (PartInitException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
        }
    }
}
