/*
 * Created on 2003/07/23
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.noderegister.snmp;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

import netjfwatcher.engine.nodecontrol.NodeKind;
import netjfwatcher.engine.server.protocol.snmp.NetSnmpOid;
import netjfwatcher.engine.server.protocol.snmp.SnmpIfOctet;
import netjfwatcher.engine.server.protocol.snmp.SnmpInterfacesMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpPrintMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpSystemMibGet;
import netjfwatcher.engine.snmpmanager.statistics.StatisticsMibDBRegister;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.preference.SnmpPreference;


/**
 * SNMP System MIBInterface MIB̎悵ăf[^x[XɊi[Thread
 * ܂B
 * SNMPĎxSNMP\擾ȏ̏ꍇŃm[ho^yуm[hĎ
 * ҏWɌĂ΂܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeSnmpRegisterInitializeThread implements Runnable {
    /* MO */
    private static Logger logger;

    /* m[hIPAhX */
    private String targetip;

    /* SNMPo[W */
    private int version;

    /* ̎ */
    private int period;

    /* R~jeB */
    private String community;

    /* SNMPĎx */
    private int snmpLevel;

    /* m[h */
    private String nodeKind;
    
    /**
     * SNMP System MIBInterface MIB̎悵ăf[^x[XɊi[
     * ThreadCX^X𐶐܂B
     *
     * @param targetip m[hIPAhX
     * @param version SNMPo[W
     * @param period ̎
     * @param community R~jeB
     * @param snmpLevel SNMPĎx
     * @param nodeKind m[h
     */
    public NodeSnmpRegisterInitializeThread(
        final String targetip, final int version, final int period,
        final String community, final int snmpLevel, final String nodeKind) {
        this.targetip = targetip;
        this.version = version;
        this.period = period;
        this.snmpLevel = snmpLevel;
        this.community = community;
        this.nodeKind = nodeKind;
        logger = Logger.getLogger(this.getClass().getName());

    }

    /**
     * SNMP System MIBInterface MIB̎悵ăf[^x[XɊi[
     * Threads܂B
     *
     */
    public void run() {
        try {
            // System MIB
            SnmpSystemMibGet systemMib = new SnmpSystemMibGet();

            systemMib.setSnmpSystemMibGet(targetip, version, community);
            systemMib.getInitialyzeSystemMIB();
            logger.info("SNMP System Mib Get " + targetip);

            // Interfaces MIB
            SnmpInterfacesMibGet mibInterfacesGet = new SnmpInterfacesMibGet();
            mibInterfacesGet.setSnmpInterfacesMibGet(
                targetip, version, community);
            mibInterfacesGet.getInitialyzeInterfacesMIB();

            logger.info("SNMP Interfaces Mib Get " + targetip);

            if(nodeKind.equals(NodeKind.PRINTER)) {
            	SnmpPrintMibGet get = new SnmpPrintMibGet();
            	get.setSnmpPrintMibGet(
                        targetip, version, community);
            	get.getInitialyzePrintMIB();
            	logger.info("SNMP Print Mib Get " + targetip);
            }

            
            
            
            
            
            if (snmpLevel == SnmpPreference.SNMP_LEVEL2) {
                StatisticsMibDBRegister mibStatisGet =
                    new StatisticsMibDBRegister(targetip, version, community);

                // ifInOctetsZbg
                mibStatisGet.setDatabaseStatisMibInfomation(
                    SnmpIfOctet.IF_IN_OCTETS, Integer.toString(period),
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);

                // ifOutOctetsZbg
                mibStatisGet.setDatabaseStatisMibInfomation(
                    SnmpIfOctet.IF_OUT_OCTETS, Integer.toString(period),
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);
            }

            if (snmpLevel == SnmpPreference.SNMP_LEVEL3) {
                StatisticsMibDBRegister mibStatisGet =
                    new StatisticsMibDBRegister(targetip, version, community);
                mibStatisGet.setDatabaseStatisMibInfomation(
                    NetSnmpOid.LALOAD, Integer.toString(period),
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);
            }

            if (snmpLevel == SnmpPreference.SNMP_LEVEL4) {
                StatisticsMibDBRegister mibStatisGet =
                    new StatisticsMibDBRegister(targetip, version, community);
                mibStatisGet.setDatabaseStatisMibInfomation(
                    NetSnmpOid.DSK_TOTAL, Integer.toString(period),
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);
                mibStatisGet.setDatabaseStatisMibInfomation(
                    NetSnmpOid.DSK_AVAIL, Integer.toString(period),
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);
                mibStatisGet.setDatabaseStatisMibInfomation(
                    NetSnmpOid.DSK_USED, Integer.toString(period),
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
                    StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);
            }
        } catch (UnknownHostException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (SocketException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (SnmpMIBGetException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}
