/*
 * Created on 2006/12/27
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;


public final class ListQueueDatabaseWatchControl {

    private Map<String, NodeWatchInfo> databaseHashMap;

    /*
     * IPAhXL[Ƃm[hĎێHashMap𐶐
     * ܂B
     *
     */
    private ListQueueDatabaseWatchControl() {
        databaseHashMap = Collections.synchronizedMap(new LinkedHashMap<String, NodeWatchInfo>());
    }


    public void setDatabaseNode(String ip, NodeWatchInfo nodeInfo) {
        // JEglZbg
        nodeInfo.getDatabaseWatcherInfo().setCountWatcherPeriod(nodeInfo.getDatabaseWatcherInfo().getWatcherPeriod());
        // Xgɒǉ
        databaseHashMap.put(ip, nodeInfo);
    }


    public NodeWatchInfo getDatabaseNode(String ip) {
        return (NodeWatchInfo) databaseHashMap.get(ip);
    }


    public void removeDatabaseNode(String ip) {
        databaseHashMap.remove(ip);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ListQueueDatabaseWatchControl getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }


    public Map getDatabaseHashMap() {
        return databaseHashMap;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final ListQueueDatabaseWatchControl DBPOOL = new ListQueueDatabaseWatchControl();
    }
}
