/*
 * Created on 2004/05/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * IPopĎ삷m[hĎ񃊃Xgm[hIPAhX
 * L[ƂĕێAPopĎsThread𐧌䂷邽߂̃Xgێ
 * NXłB
 * ʃXbhł̃Xg̃JE^PbŃJEg_E0([)
 * ȂƎsL[Push܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ListQueuePopControl {
    /* IPAhXKeyƂPopĎێMap */
    private Map<String, NodeWatchInfo> popHashMap;

    /*
     * IPAhXL[Ƃm[hĎێMap𐶐
     * ܂B
     */
    private ListQueuePopControl() {
        popHashMap = Collections.synchronizedMap(new LinkedHashMap<String, NodeWatchInfo>());
    }

    /**
     * w肳ꂽIPAhXL[ƂāAm[hĎMapɊi[
     * ܂B
     * ̎APopĎJE^ɃZbg܂B
     *
     * @param ip m[hIPAhX
     * @param nodeInfo m[hĎ
     */
    public void setPop3Node(String ip, NodeWatchInfo nodeInfo) {
        nodeInfo.setCountPopPeriod(nodeInfo.getPopPeriod());

        // Xgɒǉ
        popHashMap.put(ip, nodeInfo);
    }

    /**
     * wm[hIPAhXPopĎԂ܂B
     *
     * @param ip m[hIPAhX
     * @return m[hĎ
     */
    public NodeWatchInfo getPopNode(String ip) {
        return (NodeWatchInfo) popHashMap.get(ip);
    }

    /**
     * wm[hIPAhXPopĎ폜܂B
     *
     * @param ip PopĎ
     */
    public void removePopNode(String ip) {
        popHashMap.remove(ip);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ListQueuePopControl getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * m[hPopĎێMapԂ܂B
     *
     * @return m[hPopĎێMap
     */
    public Map getPopHashMap() {
        return popHashMap;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final ListQueuePopControl DBPOOL = new ListQueuePopControl();
    }
}
