/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.preference.SnmpPreference;



/**
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class MibGetNextInfoQueue {
    /*
     * MIB̎CX^XQueue̎悷鎞̃^CAEgl
    */
    private static final int QUEUE_TIMEOUT = 120;

    /* 1bJEgmsJE^[l */
    private static final int BASE_SECOUND_COUNT = 1000;

    /* JE^[Waitl */
    private static final int WAIT_COUNT = 5;

    /**
     * Mib GetNextCX^X擾Wait(ms)
     */
    public static final int THREAD_WAIT_COUNT = BASE_SECOUND_COUNT * WAIT_COUNT;

    /* Busy Description */
    private static final String BUSY = "busy";

    /* Unbusy Description */
    private static final String UNBUSY = "unbusy";

    /* m[hBusyԕێMap */
    private static Map nodeBusyMap = Collections.synchronizedMap(new HashMap());

    /* m[hAhXێMap */
    private static Map nodeAddressMap =
        Collections.synchronizedMap(new HashMap());

    /* Thread̑҂sɎwThread݂邩̃`FbNpMap */
    private static Map threadNameMap =
        Collections.synchronizedMap(new HashMap());

    /* Thread̑҂sList */
    private static List threadNameList =
        Collections.synchronizedList(new ArrayList());

    /* MO */
    private static Logger logger;

    /**
     *
     *
     */
    private MibGetNextInfoQueue() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Mib GetNextCX^X܂B
     *
     * @param nodeAddressKey AhXL[
     * @param threadName Thread
     */
    public synchronized void releaseMibGetInstance(
        String nodeAddressKey, String threadName) {
        nodeBusyMap.put(nodeAddressKey, UNBUSY);
        removeThreadName(threadName);
    }

    /**
     * Mib GetNextCX^XQueuem[hAhXThreadɂĎ擾܂B
     * Threadgp̂́ASystem/Interface/veMIB̎揈ϓɎs
     * 悤ɂ邽߂łB
     * CX^X擾ɂāAw̃G[WFgAddress
     * Busy̏ꍇɂnullԂ܂B
     * BusyłȂꍇŁAwThread҂s̐擪̏ꍇ
     * QueueCX^X擾ĕԂ܂B
     * CX^X擾ɂBusyZbg܂B
     * Thread҂s̐擪łȂꍇɂnullԂƂƂ
     * ҂sThreadZbg܂B
     *
     * ̑҂sɂMIB̎̏ۏႵ܂B
     * ܂AG[WFgAddressKeyƂQueueɂMIB GetNext
     * CX^XǗɂCX^X𐧌܂B
     *
     * @param nodeAddressKey AgnetAhX
     * @param threadName Thread
     * @return info MibGetNextInfo MIB̎CX^X
     * @throws SocketException Socket̐Ɏsꍇ
     */
    public synchronized MibGetNextInfo popMibGetInstanceQueue(
        String nodeAddressKey, String threadName) throws SocketException {
        MibGetNextInfo mibGetInfo = null;

        if (nodeAddressMap.containsKey(nodeAddressKey)) {
            if (((String) nodeBusyMap.get(nodeAddressKey)).equals(BUSY)) {
                /* wAgentAhXBusyԂ̂߂Nullԋp */
                return null;
            }

            String getThreadName = getThreadName(threadName);

            if (getThreadName != null) {
                /*
                 * wAgentAhXpMib GetNextCX^X
                 * 擾҂擪Thread̂߂ɃCX^Xԋp
                 */
                nodeBusyMap.put(nodeAddressKey, BUSY);
                mibGetInfo =
                    (MibGetNextInfo) nodeAddressMap.get(nodeAddressKey);

                return mibGetInfo;
            }

            /*
             * wAgentAhXpMib GetNextCX^X
             * 擾҂擪ThreadłȂ߂Nullԋp
             */
            setThread(threadName);

            return null;
        }

        /* wAgentAhXpMib GetNextCX^X𐶐 */
        mibGetInfo = new MibGetNextInfo();
        nodeAddressMap.put(nodeAddressKey, mibGetInfo);
        nodeBusyMap.put(nodeAddressKey, BUSY);

        return mibGetInfo;
    }

    /**
     * Mib GetNextCX^XQueue擾ɂBusyɂĎ擾
     * s̏ꍇɃgCtimeout𒴂ۂ̃`FbN܂B
     * ̃\bh́ATHREAD_WAIT_COUNT = BASE_SECOUND_COUNT * WAIT_COUNT
     * (5sec)ŌĂ΂܂B
     *
     * @param targetIP G[WFgAddress
     * @param oid OID
     * @param checkCount Mib GetNextCX^X擾gCJEg
     * @param version Snmpo[W
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     */
    public synchronized void checkTimeout(
        final String targetIP, final String oid, final int checkCount,
        final int version) throws SnmpMIBGetException {
        /* Socket Timeoutl */
        String socketTimeoutString;

        /* gC */
        String retryString;

        switch (version) {
        case SnmpPreference.SNMP_VERSION_1:
            socketTimeoutString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV1Timeout();
            retryString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV1Retry();

            break;

        case SnmpPreference.SNMPV2C:
            socketTimeoutString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV1Timeout();
            retryString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV2Retry();

            break;

        case SnmpPreference.SNMPV3:
            socketTimeoutString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV1Timeout();
            retryString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV3Retry();

            break;

        default:
            logger.warning("Bad Snmp version: " + version);
            throw new SnmpMIBGetException("Bad SNMP Version = " + version);
        }

        int timeout = Integer.parseInt(socketTimeoutString);
        int retry = Integer.parseInt(retryString);

        if (checkCount > QUEUE_TIMEOUT) {
            String message =
                "Abort get SNMP MIB GetNext Instance. Node IP=" + targetIP
                + " OID=" + oid + " timeout=" + timeout + " retry=" + retry;
            AlarmMessageMake alarm = AlarmMessageMake.getInstance();
            alarm.setEorrorTest(targetIP, message);
            logger.warning(message);
            throw new SnmpMIBGetException(
                "Abort get MIB IP=" + targetIP + " OID=" + oid);
        }
    }

    /**
     * wThreadThread҂sɃZbg܂B
     *
     * @param threadName Thread
     */
    public synchronized void setThread(String threadName) {
        /*
             * Thread҂sɊThreado^Ă邩
             * `FbN
             */
        if (!threadNameMap.containsKey(threadName)) {
            threadNameList.add(threadName);
            threadNameMap.put(threadName, threadName);
        }
    }

    /**
     * wThreadThread҂s񂩂폜܂B
     *
     * @param threadName Thraed
     */
    public synchronized void removeThreadName(final String threadName) {
        for (int i = 0; i < threadNameList.size(); i++) {
            String removeThredaName = (String) threadNameList.get(i);

            if (threadName.equals(removeThredaName)) {
                threadNameList.remove(i);
            }
        }

        threadNameMap.remove(threadName);
    }

    /**
     * wThread҂s̐擪łꍇɁAThread
     * Ԃ܂B
     * ҂s̐擪łȂꍇɂnullԂ܂B
     *
     * @param threadName Thread
     * @return Thread
     */
    public synchronized String getThreadName(String threadName) {
        /* ҂s̒`FbN */
        if (threadNameList.size() > 0) {
            String waitThreadName = (String) threadNameList.get(0);

            if (threadName.equals(waitThreadName)) {
                /*
                 * ҂s̐擪wThread̏ꍇ
                 * ҂s񂩂Thread폜āAThread
                 * Ԃ
                 */
                threadNameList.remove(0);
                threadNameMap.remove(threadName);

                return waitThreadName;
            }

            return null;
        }

        /* ҂s̒0̏ꍇAwThraedԂ */
        return threadName;
    }

    /* ( Javadoc)
         * @see java.lang.Object#finalize()
         */
    protected void finalize() throws Throwable {
        super.finalize();
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static MibGetNextInfoQueue getInstance() {
        return SingletonAboutMessage.MIB_GETNEXT_POOL;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final MibGetNextInfoQueue MIB_GETNEXT_POOL = new MibGetNextInfoQueue();
    }
}
