/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;



/**
 * SNMPMbZ[W𐶐郁\bhNXłB
 *
 * SNMP OIDValuevarListAPDUyуbZ[WE
 * ݒ肵܂B
 *
 *
 * SNMPbZ[W
 * +----------+-----------+---------------+
 * | Version  | Community |   SNMP PDU    |
 * +----------+-----------+---------------+
 *                        |               |
 *                        |               |
 * SNMP PDU
 * +--------+--------------+-------------+------------+
 * |   ID   | Error Status | Erroe Index |   varList  |
 * +--------+--------------+-------------+------------+
 *                                       |            |
 *                                       |            |
 * SNMP varList
 * +-----+-------+-----+-------+---
 * | OID | Value | OID { Value |   .....
 * +-----+-------+-----*-------+---
 *
 * SNP Pair
 *
 * +-----+-------+
 * | OID | Value |
 * +-----+-------+
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpManagerCreateSendMessage {
    /* MO */
    private static Logger logger;

    /* SNMPbZ[W */
    private SnmpMessage snmpMessage = new SnmpMessage();

    /* SNMP PDU */
    private SnmpPDU pdu = new SnmpPDU();
    

    /* SNMP VarList */
    private SnmpSequence varList = new SnmpSequence();

    /* SNMP OIDSNMP ValuẽyA */
    private SnmpVariablePair nextPair = new SnmpVariablePair();

    /* SNMP OID */
    private SnmpObjectIdentifier requestedObjectIdentifier =
        new SnmpObjectIdentifier();

    
    /* SNMP Obejct(SNMP Value) */
    private SnmpNull snmpNull = new SnmpNull();

    /**
     * SNMPbZ[WCX^X𐶐܂B
     *
     */
    public SnmpManagerCreateSendMessage() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMPR}hM̂߂SNMP MessageCX^X𐶐ĕԂ܂B
     *
     * @param version SNMPo[W
     * @param community R~jeB
     * @param requestID NGXgID
     * @param requestOID OID
     * @param pduType PDU Type
     * @return snmpMessage SNMP Message
     * @throws SnmpBadValueException SnmpbZ[W쐬Ɏsꍇ
     */
    public SnmpMessage createSNMPMessage(
        int version, String community, int requestID, String requestOID,
        byte pduType) throws SnmpBadValueException {
        try {
            // SNMP PDU
            pdu = createPDU(requestID, requestOID, pduType, snmpNull);

            // SNMPbZ[W
            snmpMessage.setSNMPMessage(version, community, pdu);
        } catch (SnmpBadValueException e) {
            logger.warning("Abort create message : " + e.getMessage());
            e.printStackTrace();
            throw new SnmpBadValueException(
                requestOID + " : " + e.getMessage());
        } finally {
        }

        return snmpMessage;
    }

    /**
     * PDU𐶐܂B
     *
     * @param requestID NGXgID
     * @param requestOID OID
     * @param pduType PDU Type
     * @param newValue SNMPIuWFNg
     * @throws SnmpBadValueException f[^ňُ킪ꍇ
     */
    private SnmpPDU createPDU(
        int requestID, String requestOID, byte pduType, AbstractSnmpObject newValue)
        throws SnmpBadValueException {

        int errorStatus = SnmpPreference.ERROR_STATUS_CORRECT;
        int errorIndex = SnmpPreference.ERROR_INDEX_CORRECT;

        /* SNMP PDU */
        try {
        	/* OIDSNMP Valueݒ */
            requestedObjectIdentifier.setSNMPObjectIdentifier(requestOID);
            nextPair.setSNMPVariablePair(requestedObjectIdentifier, newValue);

            /* SNMP varListݒ */
            varList.clearSNMPObjectList();
            varList.addSNMPObject(nextPair);

            /* SNMP PDU */
            pdu.setSNMPPDU(
                pduType, requestID, errorStatus, errorIndex, varList);
        } catch (SnmpBadValueException e) {
            logger.warning("Abort create message : " + e.getMessage());
            e.printStackTrace();
            throw new SnmpBadValueException(
                requestOID + " : " + e.getMessage());
        }

        return pdu;
    }
}
