/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 *
 * <p>SNMP V3v(USM v)AgentAhXɊǗNXłB</p>
 * <p>Statistics for the User-based Security Model</p>
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SnmpV3UsmStatisticsManager {
    /* SNMP V3 AgentAhXKeyƂSNMP V3vi[Map */
    private static Map addressMap = Collections.synchronizedMap(new HashMap());

    /*
     *
     */
    private SnmpV3UsmStatisticsManager() {
    }

    /**
     * wSNMP V3 AgentAhXSNMP V3vԂ܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     * @return snmpV3UsmStatisticsInfo SNMP V3v
     */
    public synchronized SnmpV3UsmStatisticsInfo getSnmpStatisticsInfo(
        String addressKey) {
        SnmpV3UsmStatisticsInfo snmpV3UsmStatisticsInfo = null;

        if (addressMap.containsKey(addressKey)) {
            snmpV3UsmStatisticsInfo =
                (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            /*
             * wSNMP V3 AgentAhXɑΉSNMP V3v
             * ݂Ȃꍇ́AVɐ
             */
            snmpV3UsmStatisticsInfo = new SnmpV3UsmStatisticsInfo();
        }

        return snmpV3UsmStatisticsInfo;
    }

    /**
     * DecryptionErrorsZbg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     * @param value JE^l
     */
    public void setUsmStatsDecryptionErrors(String addressKey, int value) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.setUsmStatsDecryptionErrors(value);
        addressMap.put(addressKey, info);
    }

    /**
     * NotInTimeWindowsZbg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     * @param value JE^l
     */
    public void setUsmStatsNotInTimeWindows(String addressKey, int value) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.setUsmStatsNotInTimeWindows(value);
        addressMap.put(addressKey, info);
    }

    /**
     * UsmStatsUnknownEngineIDsZbg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     * @param value UsmStatsUnknownEngineIDsf[^
     */
    public void setUsmStatsUnknownEngineIDs(String addressKey, int value) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.setUsmStatsUnknownEngineIDs(value);
        addressMap.put(addressKey, info);
    }

    /**
     * UnknownUserNamesZbg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     * @param value UnknownUserNamesf[^
     */
    public void setUsmStatsUnknownUserNames(String addressKey, int value) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.setUsmStatsUnknownUserNames(value);
        addressMap.put(addressKey, info);
    }

    /**
     * UnsupportedSecLevelsZbg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     * @param value UnsupportedSecLevelsf[^
     */
    public void setUsmStatsUnsupportedSecLevels(String addressKey, int value) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.setUsmStatsUnsupportedSecLevels(value);
        addressMap.put(addressKey, info);
    }

    /**
     * WrongDigestsZbg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     * @param value WrongDigestsf[^
     */
    public void setUsmStatsWrongDigests(String addressKey, int value) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.setUsmStatsWrongDigests(value);
        addressMap.put(addressKey, info);
    }

    /**
     * DecryptionErrorsJEg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     */
    public void addUsmStatsDecryptionErrors(String addressKey) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.addUsmStatsDecryptionErrors();
        addressMap.put(addressKey, info);
    }

    /**
     * NotInTimeWindowsJEg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     */
    public void addUsmStatsNotInTimeWindows(String addressKey) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.addUsmStatsNotInTimeWindows();
        addressMap.put(addressKey, info);
    }

    /**
     * UnknownEngineIDsJEg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     */
    public void addUsmStatsUnknownEngineIDs(String addressKey) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.addUsmStatsUnknownEngineIDs();
        addressMap.put(addressKey, info);
    }

    /**
     * UnknownUserNamesJEg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     */
    public void addUsmStatsUnknownUserNames(String addressKey) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.addUsmStatsUnknownUserNames();
        addressMap.put(addressKey, info);
    }

    /**
     * UnsupportedSecLevelsJEg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     */
    public void addUsmStatsUnsupportedSecLevels(String addressKey) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.addUsmStatsUnsupportedSecLevels();
        addressMap.put(addressKey, info);
    }

    /**
     * addUsmStatsWrongDigestsJEg܂B
     *
     * @param addressKey SNMP V3 AgentAhX
     */
    public void addUsmStatsWrongDigests(String addressKey) {
        SnmpV3UsmStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpV3UsmStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpV3UsmStatisticsInfo();
        }

        info.addUsmStatsWrongDigests();
        addressMap.put(addressKey, info);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static SnmpV3UsmStatisticsManager getInstance() {
        return SingletonResource.USM_STATISTICS_MANAGER;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final SnmpV3UsmStatisticsManager USM_STATISTICS_MANAGER =
            new SnmpV3UsmStatisticsManager();
    }
}
