/*
 * Created on 2004/05/03
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.statistics;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;



/**
 * w̃m[hIPAhXOID̓vMIB̎悵Aw̃f[^x[X
 * e[uɊi[܂B
 * vMIB̎yуf[^x[Xi[ɂẮAThreadƂē삵
 * ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadStatisticsMibGet implements Runnable {
    /* MO */
    private static Logger logger;

    /* m[hIPAhX */
    private String targetip;

    /* SNMPo[W */
    private int version;

    /* R~jeB */
    private String community;

    /* OID */
    private String oid;

    /* ̎ */
    private int period;

    /* vMIBi[e[u */
    private String tableName;

    /**
     * vMIB̎悵e[uɊi[NXCX^X𐶐
     * ܂B
     *
     * @param targetip m[hIPAhX
     * @param version SNMPo[W
     * @param community R~jeB
     * @param oid OID
     * @param period ̎
     * @param tableName i[e[u
     */
    public ThreadStatisticsMibGet(
        final String targetip, final int version, final String community,
        final String oid, final int period, final String tableName) {
        logger = Logger.getLogger(this.getClass().getName());

        this.targetip = targetip;
        this.version = version;
        this.community = community;
        this.oid = oid;
        this.period = period;

        this.tableName = tableName;
    }

    /**
     * vMIB̎悵Ae[uɊi[܂B
     *
     */
    public void run() {
        int count = 0;

        /*
         * m[hǉɓvMIB̎抮܂œvMIB̎Wait
         */
        while (true) {
            count++;

            NodeWatchInfo nodeInfo =
                BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(targetip);

            if (
                nodeInfo.getStatisticsMIBStatus().equals(
                        NodeWatchInfo.STATISTICS_MIB_OK)) {
                break;
            }

            try {
                /*
                 * vMIB̎OɃm[hvMIB̎揀Wait
                 * (e[u܂)邪ATimeout`FbN
                 */
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    targetip, "Wait STATISTICS_MIB_OK", count, version);
            } catch (SnmpMIBGetException e2) {
                logger.warning(e2.getMessage());
                e2.printStackTrace();

                break;
            }

            try {
                Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
            } catch (InterruptedException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }

        /* vMIB̎CX^X */
        MibGetNextInfo mibGetInstance = null;

        ArrayList statisList = null;

        try {
            int checkCount = 0;

            while (mibGetInstance == null) {
                mibGetInstance =
                    MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(
                        targetip, Thread.currentThread().getName());

                try {
                    Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
                } catch (InterruptedException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }

                checkCount++;
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    targetip, oid, checkCount, version);
            }

            logger.info(
                "IP Address=" + targetip + " Table=" + tableName + " Version="
                + version + " OID=" + oid);
            mibGetInstance.setMibGetNext(targetip, version, community);

            // statisList = mibget.getNextMib(oid);
            statisList = mibGetInstance.getNextMibValueList(oid);

            if (statisList != null) {
                this.setMibStatisticsDatabase(tableName, oid, statisList);
            }
        } catch (UnknownHostException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + oid + " Period="
                + period);
            e.printStackTrace();
        } catch (SocketException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + oid + " Period="
                + period);
            e.printStackTrace();
        } catch (SnmpMIBGetException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + oid + " Period="
                + period);
            e.printStackTrace();
        } finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    targetip, Thread.currentThread().getName());
            }
        }
    }

    /**
     * ̎悵vMIB̒lf[^x[Xe[uɊi[܂B
     *
     * @param tableName f[^i[f[^x[Xe[u
     * @param oid OID
     * @param statisItemList vMIBli[Xg
     */
    void setMibStatisticsDatabase(
        final String tableName, final String oid, final ArrayList statisItemList) {
        if (tableName == null) {
            return;
        }

        try {
            DBTableStatisticsMIBControl statisMibTableControl =
                DBTableStatisticsMIBControl.getInstance();
            statisMibTableControl.put(tableName, oid, statisItemList);
        } catch (DatabaseConnectionException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + oid + " Period="
                + period);
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + oid + " Period="
                + period);
            e.printStackTrace();
        }
    }
}
