/*
 * Created on 2003/08/15
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;

import netjfwatcher.engine.socket.info.NodeInformation;


/**
 * GWɃm[hĎ̋N/~/ċNʒmNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionNodeControl extends AbstractConnectionEngine {
    /**
     * GWɃm[hĎ̋N/~/ċNʒmNXCX^X
     * 𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionNodeControl(final String engineAddress) {
        super(engineAddress);
    }

    /**
     * GWɃm[hĎ̋N/~/ċNʒm܂B
     *
     * @param nodeIPAddress m[hIPAhX
     * @param code R}hR[h
     * @param nodeInfo m[hĎ
     * @return responseCode ʃR[h
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public String requestThread(
        final String nodeIPAddress, final String code,
        final NodeInformation nodeInfo)
        throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setNodeInformation(nodeInfo);
        commnadInfo.setCode(code);
        commnadInfo.setIpaddress(nodeIPAddress);

        String responseCode = (String) this.communicationToEngine(commnadInfo);

        return responseCode;
    }

    /**
     * GWɃm[hĎ̋N/~/ċNʒm܂B
     *
     * @param code R}hR[h
     * @param nodeInfoList m[hĎ񃊃Xg
     * @return responseCode ʃR[h
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public String requestThread(
        final String code, final ArrayList nodeInfoList)
        throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setNodeInformationList(nodeInfoList);
        commnadInfo.setCode(code);

        String responseCode = (String) this.communicationToEngine(commnadInfo);

        return responseCode;
    }
}
