/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.common;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.osgi.framework.Bundle;



/**
 * m[hEditorɕ\NXׂۃNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractEditorNodeView extends EditorPart {
    /* MO */
    private static Logger logger;

    /* Xe[^XC}l[W */
    protected SubStatusLineManager statusLineManager;

    /** Error Image */
    protected Image errorImage;

    /** Warning Image */
    protected Image warningImage;

    /** Information Image */
    protected Image infoImage;

    /** Table */
    protected Table table;

    /*
     * SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     */
    protected boolean isSocket;

    /** Error Imaget@C */
    protected String errorImageFile = "icons/alarm_level_.gif";

    /** Warning Imaget@C */
    protected String warningImageFile = "icons/alarm_level_warning.gif";

    /** Information Imaget@C */
    protected String infoImageFile = "icons/alarm_level_info.gif";

	/** zFColor` */
	protected static Color WHITE_COLOR = new Color(null, 255, 255, 255);

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     * m[hEditorɕ\NXׂۃNX
     * RXgN^łB
     */
    public AbstractEditorNodeView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    abstract public void createPartControl(Composite parent);

    /**
     * Xe[^XC\Zbg܂B
     *
     */
    protected abstract void setStatusLine();

    /**
     * Error/Warning/Information Image𐶐܂B
     *
     * @param parentComposite Composite
     */
    protected void createImage(Composite parentComposite) {
        /* Displayo */
        Display display = parentComposite.getDisplay();

        URL url = null;

        try {
            url = bundle.getEntry(errorImageFile);

            if (url == null) {
                /* Icon\[Xt@CȂꍇMO̎ */
                logger.severe("Not found icon file : " + errorImageFile);
            } else {
                errorImage = new Image(display, url.openStream());
            }

            url = bundle.getEntry(warningImageFile);

            if (url == null) {
                /* Icon\[Xt@CȂꍇMO̎ */
                logger.severe("Not found icon file : " + errorImageFile);
            } else {
                warningImage = new Image(display, url.openStream());
            }

            url = bundle.getEntry(infoImageFile);

            if (url == null) {
                /* Icon\[Xt@CȂꍇMO̎ */
                logger.severe("Not found icon file : " + errorImageFile);
            } else {
                /* m[hIconC[W */
                infoImage = new Image(display, url.openStream());
            }
        } catch (IOException e) {
            logger.warning(
                "Abort create image " + e.getMessage() + " for "
                + errorImageFile);
            e.printStackTrace();
        }
    }

    /**
     * tH[JXZbg̏łB
     */
    public void setFocus() {
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#isDirty()
     */
    public boolean isDirty() {
        return false;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#doSave(org.eclipse.core.runtime.IProgressMonitor)
     */
    public void doSave(IProgressMonitor monitor) {
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#doSaveAs()
     */
    public void doSaveAs() {
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
     */
    public boolean isSaveAsAllowed() {
        return false;
    }

    /**
     * EditorEBhEɏݒs܂B
     *
     * @param site TCg
     * @param input ͒l
     * @throws PartInitException ͒lݒ肪ُ̏ꍇ
     */
    public void init(IEditorSite site, IEditorInput input)
        throws PartInitException {
        /* ͒lݒ肪킩`FbN */
        if (
            !(input instanceof EditorInputNodeView)
                && !(input instanceof EditorInputNodeChart)) {
            logger.warning("Wrong input: " + input.getClass());
            throw new PartInitException("Wrong input: " + input.getClass());
        }

        setSite(site);
        setInput(input);
        setPartName(input.getName());
    }

    /* ( Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (errorImage != null) {
            errorImage.dispose();
        }

        if (warningImage != null) {
            warningImage.dispose();
        }

        if (infoImage != null) {
            infoImage.dispose();
        }

        if (table != null) {
            table.dispose();
        }
    }
}
