package netjfwatcher.engine.view.editorpart.common;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class EditorNodeChartMouseListener extends MouseAdapter implements
		MouseMoveListener {
	/* Composite */
	private ScrolledComposite scrollComposite;

	private Composite parent;

	/* GC */
	private GC gc;

	private Canvas canvas;

	private AbstractEditorNodeChart chartInstance;

	/**
	 * }EXXi[NXCX^X𐶐܂B
	 * 
	 * @param display
	 *            Display
	 * @param parent
	 *            Composite
	 * @param canvas
	 *            Canvas
	 * @param gc
	 *            GC
	 * @param statusLineManager
	 *            Xe[^XC}l[W
	 * @param isSocket
	 *            RCPNCAgƂSocketɂăT[oƒʐMs̃tO
	 */
	public EditorNodeChartMouseListener(ScrolledComposite scrollComposite,
			Display display, final Composite parent, Canvas canvas, GC gc,
			AbstractEditorNodeChart chartInstance, boolean isSocket) {
		this.scrollComposite = scrollComposite;
		this.gc = gc;
		this.parent = parent;
		this.canvas = canvas;
		this.chartInstance = chartInstance;

	}

	/**
	 * }EXDownCxgXi[łB m[hIcon̈ړ܂́Am[hԃN`Jn܂B
	 * 
	 * @param event
	 *            MouseEvent
	 */
	public void mouseDown(MouseEvent event) {

		/* SCanvasɂVieẅʒu */
		Point canvaPoint = canvas.getLocation();

		int canvaAbsPointX = Math.abs(canvaPoint.x);
		int canvaAbsPointY = Math.abs(canvaPoint.y);
		/* \ĂMapr[TCY */
		// Rectangle mapViewRectangle = gc.getClipping();
		Point mapScrollCompositePoint = scrollComposite.getSize();
		int overviewPointX = canvaAbsPointX;
		int overviewPointY = canvaAbsPointY + mapScrollCompositePoint.y - 16 - AbstractEditorNodeChart.OFFSET;

		if (event.x >= overviewPointX && event.x <= overviewPointX + 16
				&& event.y >= overviewPointY) {

			int xScall = chartInstance.getChartXScall();
			int yScall = chartInstance.getChartYScall();
			chartInstance.setChartXScall((int) (xScall * 1.1));
			chartInstance.setChartYScall((int) (yScall * 1.1));

			chartInstance.redraw();
		} else if (event.x > overviewPointX + 16
				&& event.x <= overviewPointX + 16 * 2
				&& event.y >= overviewPointY) {

			int xScall = chartInstance.getChartXScall();
			int yScall = chartInstance.getChartYScall();

			chartInstance.setChartXScall((int) (xScall * 0.9));
			chartInstance.setChartYScall((int) (yScall * 0.9));
			chartInstance.redraw();
		}

	}

	/**
	 * }EXUpCxgXi[łB m[hIcon̈ړ܂́Am[hԃN̊ms܂B
	 * 
	 * @param event
	 *            MouseEvent
	 */
	public void mouseUp(MouseEvent event) {

	}

	/**
	 * }EXړXi[łB [hɂm[hIcon̈ړyуm[hԃN̕`s܂B
	 * 
	 * @param event
	 *            MouseEvent
	 */
	public void mouseMove(MouseEvent event) {

	}

	/**
	 * m[hMapr[ĕ`悵܂B
	 * 
	 */
	public void redraw() {
		// System.out.println("redraw");
	}

}
