/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpStatisticsInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpStatisticsManager;
import netjfwatcher.engine.snmpmanager.process.SnmpV3UsmStatisticsInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpV3UsmStatisticsManager;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.ConnectionSnmpStatisricsInfo;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

/**
 * SnmpvAgent AddressɃe[u\NXłB
 * 
 * SnmpvƂāAȉ܂B (1) Snmp Ver Socket timeout Unmuch request ID
 * SnmpErrorStatus
 * 
 * (2) Snmp Ver.3 SnmpV3 Unmuch msgID UsmStatsUnsupportedSecLevels
 * UsmStatsNotInTimeWindows UsmStatsUnknownUserNames UsmStatsUnknownEngineIDs
 * UsmStatsWrongDigests UsmStatsDecryptionErrors
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorSnmpStatisticsInfo extends AbstractEditorNodeView {
	/** SNMPvgRv\^CgSuffix */
	public static final String TITLE_SUFFIX = " Snmp Statistics Info View";

	/** eLXg */
	public static final int TEXT_WIDTH = 100;

	/** JEgl\eLXg */
	public static final int COUNT_TEXT_WIDTH = 70;

	/** \eLXg */
	public static final int DATE_TEXT_WIDTH = 150;

	/* MO */
	private static Logger logger;

	/* Snmpv\e[uJʒu */

	/** IP Addresse[uJʒu */
	public static final int IP_ADDRESS_POS = 0;

	/** m[he[uJʒu */
	public static final int NODE_NAME_POS = 1;

	/** SNMPo[We[uJʒu */
	public static final int SNMP_VERSION_POS = 2;

	/** Socket^CAEge[uJʒu */
	public static final int SOCKET_TIMEOUT_POS = 3;

	/** Unmuch request IDe[uJʒu */
	public static final int UNMUCH_REQUEST_ID_POS = 4;

	/** SnmpErrorStatuse[uJʒu */
	public static final int ERROR_STATUS_POS = 5;

	/** SnmpV3 Unmuch msgIDe[uJʒu */
	public static final int UNMUCH_SNMPV3_MSG_ID_POS = 6;

	/** UsmStatsUnsupportedSecLevelse[uJʒu */
	public static final int USM_UNSUPPORT_LEVELS_POS = 7;

	/** UsmStatsNotInTimeWindowse[uJʒu */
	public static final int USM_NOT_INTIME_WINDOWS = 8;

	/** UsmStatsUnknownUserNamese[uJʒu */
	public static final int USM_UNKNOWN_USERNAME = 9;

	/** UsmStatsUnknownEngineIDse[uJʒu */
	public static final int USM_UNKNOWN_ENGINE_ID = 10;

	/** UsmStatsWrongDigestse[uJʒu */
	public static final int USM_WRONG_DIGESTS = 11;

	/** UsmStatsDecryptionErrorse[uJʒu */
	public static final int USM_DECRYPTION_ERRORS = 12;

	/** Snmpv\e[uJwb_[z */
	public static final String[] COLUMN_HEADER = { "IP Address", "Node name",
			"SNMP Version", "Socket timeout", "Unmuch request ID",
			"SnmpErrorStatus", "SnmpV3 Unmuch msgID",
			"UsmStatsUnsupportedSecLevels", "UsmStatsNotInTimeWindows",
			"UsmStatsUnknownUserNames", "UsmStatsUnknownEngineIDs",
			"UsmStatsWrongDigests", "UsmStatsDecryptionErrors" };

	/* SNMPve[uJRatio */
	private static final float COLUMN_RATIO0 = 0.08f;

	private static final float COLUMN_STATISTICS_RATIO = 0.1f;

	/* e[uXV{^ */
	private Button refreshButton;

	/* Snmpv\TableViewer */
	private TableViewer viewer;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorSnmpStatisticsInfo() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		isSocket = nodeViewEditorInput.isSocket();

		/*
		 * ViewCAEg
		 */
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout = new GridLayout(12, false);
		Composite composite = new Composite(parent, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

		refreshButton = new Button(composite, SWT.NONE);
		refreshButton.setText("Get Now");
		refreshButton.setLayoutData(new GridData());

		Label label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		StatisticsTable statisticsTable = new StatisticsTable();
		table = statisticsTable.createTable(parent);

		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		setTableStatisticsData();

		createContextMenu();

		/*
		 * XV{^Xi[
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				refreshButton.setEnabled(false);

				try {
					setTableStatisticsData();
				} finally {
					refreshButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		setTableStatisticsData();
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[WZbg */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/*  */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
	}

	/*
	 * f[^x[XWSnmpvf[^Xge[u\ s܂B
	 */
	private void setTableStatisticsData() {
		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		ArrayList nodeList = getNodeList();

		/* ̎[v */
		for (int dateCount = 0; dateCount < nodeList.size(); dateCount++) {
			NodeInformation nodeInfo = (NodeInformation) nodeList
					.get(dateCount);

			String[] statisticsInfo = null;

			if (!isSocket) {
				statisticsInfo = new String[COLUMN_HEADER.length];

				statisticsInfo[IP_ADDRESS_POS] = nodeInfo.getIpaddress();
				statisticsInfo[NODE_NAME_POS] = nodeInfo.getNodename();

				String snmpLevel = nodeInfo.getSnmpLevel();

				if (!snmpLevel.equals("0")) {
					statisticsInfo[SNMP_VERSION_POS] = nodeInfo
							.getSnmpVersion();
				} else {
					statisticsInfo[SNMP_VERSION_POS] = "--";
				}

				SnmpStatisticsInfo snmpInfo = SnmpStatisticsManager
						.getInstance().getSnmpStatisticsInfo(
								nodeInfo.getIpaddress());
				SnmpV3UsmStatisticsInfo snmpV3Info = SnmpV3UsmStatisticsManager
						.getInstance().getSnmpStatisticsInfo(
								nodeInfo.getIpaddress());

				statisticsInfo[SOCKET_TIMEOUT_POS] = Integer.toString(snmpInfo
						.getSnmpSocketTimeout());
				statisticsInfo[UNMUCH_REQUEST_ID_POS] = Integer
						.toString(snmpInfo.getSnmpUnmuchRequestID());
				statisticsInfo[ERROR_STATUS_POS] = Integer.toString(snmpInfo
						.getSnmpErrorStatus());
				statisticsInfo[UNMUCH_SNMPV3_MSG_ID_POS] = Integer
						.toString(snmpInfo.getSnmpV3UnmuchmsgID());
				statisticsInfo[USM_UNSUPPORT_LEVELS_POS] = Integer
						.toString(snmpV3Info.getUsmStatsUnsupportedSecLevels());
				statisticsInfo[USM_NOT_INTIME_WINDOWS] = Integer
						.toString(snmpV3Info.getUsmStatsNotInTimeWindows());
				statisticsInfo[USM_UNKNOWN_USERNAME] = Integer
						.toString(snmpV3Info.getUsmStatsUnknownUserNames());
				statisticsInfo[USM_UNKNOWN_ENGINE_ID] = Integer
						.toString(snmpV3Info.getUsmStatsUnknownEngineIDs());
				statisticsInfo[USM_WRONG_DIGESTS] = Integer.toString(snmpV3Info
						.getUsmStatsWrongDigests());
				statisticsInfo[USM_DECRYPTION_ERRORS] = Integer
						.toString(snmpV3Info.getUsmStatsDecryptionErrors());
			} else {
				String engineAddress = ClientEngineInfo
						.getClientEngineInfoInstance().getEngineAddress();

				ConnectionSnmpStatisricsInfo connectNodeInfo = new ConnectionSnmpStatisricsInfo(
						engineAddress);

				try {
					statisticsInfo = connectNodeInfo
							.getSnmpStatisticsInfo(nodeInfo);
				} catch (EngineConnectException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();
				} catch (IOException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();
				}
			}

			/*
			 * ̎ɃCX^Xf[^Zbg
			 */
			TableItem item = new TableItem(table, SWT.NULL);

			item.setText(statisticsInfo);
			item.setData(statisticsInfo);
		}
	}

	/**
	 * f[^x[XNode listǂݍŕԂ܂B
	 * 
	 * @return nodeList m[hĎ񃊃Xg
	 */
	public ArrayList getNodeList() {
		ArrayList nodeList = null;

		try {
			if (!isSocket) {
				DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
						.getInstance();
				nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
			} else {
				String engineAddress = ClientEngineInfo
						.getClientEngineInfoInstance().getEngineAddress();

				ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(
						engineAddress);
				nodeList = connectNodeInfo.getNodeInformationList(null, null);
			}
		} catch (SQLException e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			shell.dispose();

			return nodeList;
		} catch (Exception e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			shell.dispose();

			return nodeList;
		}

		return nodeList;
	}

	/**
	 * IP AdrressANodeySnmp Ver.̃J̕Ԃ܂B
	 * 
	 * @return IP AdrressANodeySnmp Ver.̃J̕
	 */
	private int computeNodeColWidth() {
		return (int) (getSite().getShell().getSize().x * COLUMN_RATIO0);
	}

	/**
	 * vJ̕Ԃ܂B
	 * 
	 * @return vJ̕
	 */
	private int computeStatisticsDataColWidth() {
		return (int) (getSite().getShell().getSize().x * COLUMN_STATISTICS_RATIO);
	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/*
	 * vMIBe[uNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * 
	 * @version 1.0
	 */
	private final class StatisticsTable extends AbstractTableView {
		/* J̃\[gz */
		private boolean[] isColDirection;

		/*
		 * SnmpvMIB\e[u𐶐ĕԂ܂B
		 * 
		 * @return table Table
		 */
		private Table createTable(Composite parent) {
			GridData data2 = new GridData();
			data2.horizontalAlignment = GridData.FILL;
			data2.verticalAlignment = GridData.FILL;
			data2.grabExcessHorizontalSpace = true;
			data2.grabExcessVerticalSpace = true;

			/* e[u */
			table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
					| SWT.FULL_SELECTION);
			table.setLinesVisible(true);
			table.setHeaderVisible(true);
			table.setLayoutData(data2);

			/* \[gtO */
			isColDirection = new boolean[COLUMN_HEADER.length];

			/* e[uColumn */
			TableColumn[] col = new TableColumn[COLUMN_HEADER.length];

			/*
			 * vMIBCX^XColumn𐶐
			 */
			for (int i = 0; i < col.length; i++) {
				col[i] = new TableColumn(table, SWT.CENTER);
				col[i].setText(COLUMN_HEADER[i]);

				if (i <= SNMP_VERSION_POS) {
					col[i].setWidth(computeNodeColWidth());
				} else {
					col[i].setWidth(computeStatisticsDataColWidth());
				}

				isColDirection[i] = true;

				/*
				 * vMIBCX^XColumn\[gXi[Zbg
				 */
				final int count = i;
				col[i].addListener(SWT.Selection, new Listener() {
					public void handleEvent(Event e) {
						if (count <= SNMP_VERSION_POS) {
							isColDirection[count] = sortTable(table, count,
									isColDirection[count]);
						} else {
							/* J\[gA\[gێ */
							isColDirection[count] = sortIntegerTable(table,
									count, isColDirection[count]);
						}
					}
				});
			}

			/*
			 * e[uړꍇ͂TCYꍇ̃Xi[łB
			 * 
			 */
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
					.addControlListener(new ControlListener() {
						public void controlMoved(ControlEvent event) {
							// nothing
						}

						public void controlResized(ControlEvent event) {
							setResizedTableColumnWidth();
						}
					});

			return table;
		}

		protected void setResizedTableColumnWidth() {
			/*
			 * e[u\Ԃł΃e[uJZbg
			 */
			if (getEditorSite().getPage().isPartVisible(
					getEditorSite().getPart())
					&& getSite().getShell() != null) {
				if (getSite().getShell().getSize() != null) {

				}
			}
		}
	}
}
