/*
 * Created on 2004/12/30
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.bit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;



/**
 * ASN.1 Type(^O)ɂBit String(^Oԍ0x03)ɑΉ
 * SNMPIuWFNg𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpBit extends AbstractSnmpObject {
	/* bitf[^ێ郊Xg */
    private List bitsList;

    /**
     * <p>BITS 𐶐܂B</p>
     */
    public SnmpBit() {
        tag = SnmpBERCodec.SNMPBITSTRING_TAG;
        tagDescription = SnmpBERCodec.SNMPBITSTRING;
        bitsList = Collections.synchronizedList(new ArrayList());
        bitsList.add(new byte[] { 0 });
    }

    /**
     * <p>l (oCgz) w肵āABITS 𐶐܂B</p>
     *
     * @param initData l
     */
    public SnmpBit(byte[] initData) {
        tag = SnmpBERCodec.SNMPBITSTRING_TAG;
        tagDescription = SnmpBERCodec.SNMPBITSTRING;
        bitsList = Collections.synchronizedList(new ArrayList());

        for (int i = 0, li = initData.length; i < li; i++) {
            bitsList.add(new byte[] { initData[i] });
        }
    }

    /**
     * <p>l () w肵āABITS 𐶐܂B</p>
     *
     * @param init l
     */
    public SnmpBit(int init) {
        this();
        tag = SnmpBERCodec.SNMPBITSTRING_TAG;
        tagDescription = SnmpBERCodec.SNMPBITSTRING;

        int mask = 1;

        for (int i = 0; i < 32; i++) {
            if ((init & mask) != 0) {
                setValue(Integer.toString(i));
            }

            mask <<= 1;
        }
    }

    /**
     * bitf[^ێ郊XgԂ܂B
     *
     * @return bitsList bitf[^ێ郊Xg
     */
    public Object getValue() {
        return bitsList;
    }

    /**
     * <p>ŉʃrbg n rbgڂ̃rbg 1 ɐݒ肵܂B</p>
     *
     * @param nPos ŉʃrbg̈ʒu
     */
    public void setValue(Object nPos) {
        int n = Integer.parseInt((String) nPos);
        int index = n / 8;
        byte b = (byte) (1 << (7 - (n % 8)));

        // byte ǉ
        for (int i = bitsList.size(); i <= index; i++) {
            bitsList.add(new byte[] { 0 });
        }

        // rbg 1 ɐݒ
        byte[] array = (byte[]) bitsList.get(index);
        array[0] |= b;
    }

    /**
     * <p>ŉʃrbg n rbgڂ̃rbg 0 ɐݒ肵܂B</p>
     *
     * @param nPos ŉʃrbg̈ʒu
     */
    public void clearBit(int nPos) {
        int index = nPos / 8;
        byte b = (byte) (1 << (7 - (nPos % 8)));

        // byte ʒu Vector ̃TCYzĂ
        if (index >= bitsList.size()) {
            return;
        }

        // rbg 0 ɐݒ
        byte[] array = (byte[]) bitsList.get(index);
        array[0] &= ~b;

        // Ō byte  0 Ȃ폜
        for (int i = bitsList.size() - 1; i > 0; i--) {
            array = (byte[]) bitsList.get(i);

            if (array[0] == 0) {
                bitsList.remove(i);
            } else {
                break;
            }
        }
    }

    /**
     * <p>ŉʃrbg n rbgڂ̃rbgԂ܂B<br>
     * rbg 1 Ȃ trueA0 Ȃ false Ԃ܂B</p>
     *
     * @param nPos ŉʃrbg̈ʒu
     * @return rbg 1 Ȃ trueA0 Ȃ false
     */
    public boolean isBit(int nPos) {
        int index = nPos / 8;
        byte b = (byte) (1 << (7 - (nPos % 8)));

        // byte ʒu Vector ̃TCYzĂ
        if (index >= bitsList.size()) {
            return false;
        }

        byte[] array = (byte[]) bitsList.get(index);
        b = (byte) (array[0] & b);

        return (b == 0) ? false : true;
    }

    /**
     * ێĂBITSIuWFNg ̃oCgzԂ܂B
     *
     * @return oCgz
     */
    public byte[] getBEREncoding() {
        int size = bitsList.size();
        byte[] bytes = new byte[size];

        for (int i = 0; i < size; i++) {
            bytes[i] = ((byte[]) bitsList.get(i))[0];
        }

        return bytes;
    }

    /**
     * <p> BITS ̕\Ԃ܂B</p>
     *
     * @return \
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int len = bitsList.size();

        if (len == 0) {
            sb.append("00");
        } else {
            byte[] array = (byte[]) bitsList.get(0);
            StringBuffer sb2 = new StringBuffer("0");
            sb2.append(Integer.toHexString(array[0]).toUpperCase());

            String str = sb2.toString();
            sb.append(str.substring(str.length() - 2));
        }

        for (int i = 1; i < len; i++) {
            sb.append(" ");

            byte[] array = (byte[]) bitsList.get(i);
            StringBuffer sb2 = new StringBuffer("0");
            sb2.append(Integer.toHexString(array[0]).toUpperCase());

            String str = sb2.toString();
            sb.append(str.substring(str.length() - 2));
        }

        return sb.toString();
    }
}
