/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
* Unknown SNMPIuWFNgNXłB
*
* @author Yoshimasa Matsumoto
* @version 1.0
*/
public class SnmpUnknownObject extends AbstractSnmpObject {
    /* Unknown SNMPIuWFNgƂĕێl */
    private byte[] data;

    /**
    *  oCgzf[^ێSNMP UnknownIuWFNg𐶐܂B
    *
    * @param enc ASN.1 BERoCgf[^z
    */
    public SnmpUnknownObject(byte[] enc) {
        data = enc;
        tag = SnmpBERCodec.SNMPUNKNOWNOBJECT_TAG;
        tagDescription = SnmpBERCodec.SNMPUNKNOWNOBJECT;
    }

    /**
     * SNMP UnknownIuWFNgŕێlԂ܂B
     *
     * @return data SNMP UnknownIuWFNgŕێl
     */
    public Object getValue() {
        return data;
    }

    /**
    * SNMP UnknownIuWFNgɒlZbg܂B
    *
    * @param data Zbgl
    * @throws SnmpBadValueException Zbglُȏꍇ
    */
    public void setValue(Object data) throws SnmpBadValueException {
        if (data instanceof byte[]) {
            this.data = (byte[]) data;
        } else {
            throw new SnmpBadValueException(
                " Unknown Object: bad object supplied to set value ");
        }
    }

    /**
    * SNMP UnknownIuWFNgŕێlBERGR[fBOɂ
    * oCgzf[^ƂĕԂ܂B
    *
    * @return oCgzf[^
    */
    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;

        try {
            byte type = SnmpBERCodec.SNMPUNKNOWNOBJECT_TAG;

            // calculate encoding for length of data
            byte[] len = this.encodeLength(data.length);

            // encode T,L,V info
            outBytes.write(type);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);

            outBytesArray = outBytes.toByteArray();
        } finally {
            try {
                outBytes.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return outBytesArray;
    }

    /**
    * SNMP UnknownIuWFNg̒l𕶎ɕϊĕԂ܂B
    *
    * @return lϊ
    */
    public String toString() {
        return new String(data);
    }
}
