/*
 * Created on 2004/10/25
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpv3;

import java.util.StringTokenizer;
import java.util.Vector;


/**
 * SNMP V3 OIDێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3OID {
    /** ZeroDotZero */
    public static final SnmpV3OID ZERO_DOT_ZERO = new SnmpV3OID("0.0");

    /* OID */
    private int[] oid = null;

    /**
     * w肳ꂽ OID 񂩂 OID 𐶐܂B
     *
     * @param oidString OID 
     */
    public SnmpV3OID(String oidString){
        // int zɕϊ
        Vector vector = new Vector();
        StringTokenizer st = new StringTokenizer(oidString, ".");

        while (st.hasMoreTokens()) {
            vector.addElement(st.nextToken());
        }

        oid = new int[vector.size()];

        for (int i = 0, li = vector.size(); i < li; i++) {
            oid[i] = Integer.parseInt((String) vector.elementAt(i));

            if (oid[i] < 0) {
                throw new IllegalArgumentException("Negative value");
            }
        }

        vector.removeAllElements();
    }

    /**
     *  OID ̃nbVR[hԂ܂B
     * OID IuWFNg̃nbVR[ȟ͎vZŌvZ܂B
     *
     * id[0]*31^(n-1) + id[1]*31^(n-2) + ... + id[n-1]
     *
     *
     * @return nbVR[hl
     */
    public int hashCode() {
        int hashCode = 0;

        for (int i = 0, li = oid.length; i < li; i++) {
            hashCode *= 31;
            hashCode += oid[i];
        }

        return hashCode;
    }

    /**
     *  OID ̕\Ԃ܂B
     *
     * @return \
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int len = oid.length;

        if (len > 0) {
            sb.append(oid[0]);
        }

        for (int i = 1; i < len; i++) {
            sb.append(".");
            sb.append(oid[i]);
        }

        return sb.toString();
    }
}
