/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;


/**
 * SNMP AgentCX^Xe[uTableLabel/Font ProviderNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentTableViewLabelProvider implements ITableLabelProvider,
    IFontProvider {
    /** SNMP AgnetCX^Xe[uJwb_[ */
    public static final String[] COLUMNS =
        new String[] { "No.", "OID Discription", "OID", "Value", "Type", "Access" };

    /** SNMP AgnetCX^Xe[uJ */
    public static final int AGENT_ARRAY_COUNT = 6;

    /** SNMP AgentCX^XNo.Jʒu */
    public static final int AGENT_MIB_INSTANCE_NO = 0;

    /** SNMP AgentCX^XOID DescriptionJʒu */
    public static final int OID_DESC = 1;

    /** SNMP AgentCX^XOIDJʒu */
    public static final int OID = 2;

    /** SNMP AgentCX^XValueJʒu */
    public static final int VALUE = 3;

    /** SNMP AgentCX^XTypeJʒu */
    public static final int TYPE = 4;

    /** SNMP AgentCX^XAccessJʒu */
    public static final int ACCESS = 5;

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * ITableLabelProvider#getColumnImage(java.lang.Object, int)
     */
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * ITableLabelProvider#getColumnText(java.lang.Object, int)
     */
    public String getColumnText(Object element, int columnIndex) {
        String[] test = (String[]) element;

        return test[columnIndex];
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.IFontProvider#getFont(java.lang.Object)
     */
    public Font getFont(Object element) {
        FontRegistry fr = JFaceResources.getFontRegistry();

        return fr.get(JFaceResources.DEFAULT_FONT);
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
     */
    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
     */
    public void addListener(ILabelProviderListener listener) {
        // nothing
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
     */
    public void dispose() {
        // nothing
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
     */
    public void removeListener(ILabelProviderListener listener) {
        // nothing
    }
}
