/*
 * Created on 2006/10/12
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.resourceconfig.EngineResourceConfig;
import netjfwatcher.engine.resourceconfig.EngineResourceInfo;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewSorter;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;

/**
 * EngineXgTree r[NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EngineListView extends ViewPart {

	private TreeViewer viewer;

	private EngineTreeGroup engineTreeGroupRootOfRoot;

	private Map engineConnectStateMap;

	private Bundle bundle;

	private Display display;

	private static final String engineIconFileName = "icons/engine.gif";

	private static final String engineStopIconFileName = "icons/engine_stop.gif";

	private Image engineIocnImage;

	private Image engineStopIocnImage;

	/* EditorsPartANVBuilder */
	private static ActionBuilderEditorsPartClose actionBuilder = new ActionBuilderEditorsPartClose();

	private static ActionBuilderXMLSocket xmlSocketAction = new ActionBuilderXMLSocket();

	private ActionEngineTreeRefresh refreshAction = new ActionEngineTreeRefresh();

	/* MO */
	private static Logger logger = null;

	public EngineListView() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	class EngineListLabelProvider extends LabelProvider implements
			IColorProvider {

		public EngineListLabelProvider() {

		}

		public Image getImage(Object element) {

			EngineInfo engineInfo = ((IEngineNode) element).getEngineInfo();

			String state = (String) engineConnectStateMap.get(engineInfo
					.getEngineAddress());
			if (state == null
					|| state.equals(XMLSocketConnectThread.UNCONNECT_MSG)) {
				return engineStopIocnImage;
			} else {
				return engineIocnImage;
			}

		}

		public String getText(Object element) {
			IEngineNode node = (IEngineNode) element;
			EngineInfo engineInfo = node.getEngineInfo();
			return engineInfo.getEngineAddress();
		}

		public Color getForeground(Object element) {
			IEngineNode node = (IEngineNode) element;
			EngineInfo engineInfo = node.getEngineInfo();
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();
			if (engineInfo.getEngineAddress().equals(engineAddress)) {
				return Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
			} else {
				return Display.getCurrent().getSystemColor(SWT.COLOR_BLACK);
			}
		}

		public Color getBackground(Object element) {
			IEngineNode node = (IEngineNode) element;
			EngineInfo engineInfo = node.getEngineInfo();
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();
			if (engineInfo.getEngineAddress().equals(engineAddress)) {
				return Display.getCurrent().getSystemColor(SWT.COLOR_DARK_BLUE);
			} else {
				return Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
			}
		}

		public void dispose() {

		}
	}

	public void createPartControl(Composite parent) {

		display = parent.getDisplay();
		bundle = NetJFWatcherPlugin.getInstance().getBundle();

		createImage();

		viewer = new TreeViewer(parent);
		viewer.setUseHashlookup(true);

		/* \[^[Zbg */
		viewer.setSorter(new NetMenuTreeViewSorter());
		viewer.setContentProvider(new EngineTreeViewContentProvider());
		viewer.setLabelProvider(new EngineListLabelProvider());
		viewer.setInput(createInitialInput());

		setTreeViewer();

		viewer.addSelectionChangedListener(new EngineListListener(viewer));
		refreshAction.setEngineListTreeViewer(this);
		XMLSocketConnectTimerProcessor.getInstance().setEngineListTreeViewer(
				getSite(), viewer);

		/* Contextj[Zbg */
		createContextMenu();

		/* ANVZbg */
		initActions();

	}

	private void createImage() {
		try {
			URL url = null;
			url = bundle.getEntry(engineIconFileName);

			if (url == null) {
				/* Icon\[Xt@CȂꍇMO̎ */
				logger
						.severe("Not found icon file : "
								+ engineStopIconFileName);
			} else {

				engineIocnImage = new Image(display, url.openStream());

			}

			url = bundle.getEntry(engineStopIconFileName);

			if (url == null) {
				/* Icon\[Xt@CȂꍇMO̎ */
				logger
						.severe("Npt found icon file : "
								+ engineStopIconFileName);
			} else {

				engineStopIocnImage = new Image(display, url.openStream());

			}
		} catch (IOException e) {
			logger.warning("Abort create image " + e.getMessage() + " for "
					+ engineStopIconFileName);
			e.printStackTrace();
		}

	}

	public void setTreeViewer() {
		engineConnectStateMap = XMLSocketConnectThread.getInstance()
				.getEngineConnectStateMap();

		engineTreeGroupRootOfRoot.removeChildAll();

		createEngineList();

		viewer.expandAll();
		viewer.refresh();

	}

	private void createEngineList() {
		/* ViewerݒŐݒ肳ꂽViewer̓f[^擾 */
		IEngineNode engineNode = (IEngineNode) viewer.getInput();
		EngineTreeGroup baseMenuGroup = engineNode.getParent();

		if (engineNode instanceof EngineTreeGroup) {
			baseMenuGroup = (EngineTreeGroup) engineNode;
		}

		ArrayList engineList = EngineResourceConfig.getInstance()
				.getEngineInfo().getEngineInfoList();

		String engineAddress = "";
		String enginePortString = "";

		for (int i = 0; i < engineList.size(); i++) {
			engineAddress = ((EngineResourceInfo) engineList.get(i))
					.getEngineIPaddress();
			enginePortString = ((EngineResourceInfo) engineList.get(i))
					.getEnginePort();

			EngineInfo engineInfo = new EngineInfo();
			engineInfo.setEngineAddress(engineAddress);
			engineInfo.setEnginePort(enginePortString);

			EngineTree engineTreeNode = new EngineTree(engineInfo);
			baseMenuGroup.addChild(engineTreeNode);

		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void setFocus() {
	}

	/**
	 * ViewerݒpIuWFNg𐶐ĕԂ܂B
	 * 
	 * @return rootOfRoot Object
	 */
	private Object createInitialInput() {
		engineTreeGroupRootOfRoot = new RootOfRootEngineTreeGroup();

		return engineTreeGroupRootOfRoot;
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W */
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		menuManager.addMenuListener(new IMenuListener() {
			/**
			 * j[Xi[łB
			 * 
			 * @param manager
			 *            IMenuManager
			 */
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/* j[Zbg */
		Menu menu = menuManager.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuManager, viewer);
	}

	/**
	 * ContextMenuZbg܂B preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		manager.add(getActionBuilder().actionCloseAllEditors());
		manager.add(xmlSocketAction.getActionXMLSocketView());
	}

	/**
	 * ANV̏s܂B
	 * 
	 */
	private void initActions() {
		/* ToolBarManagerZbg */
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		toolBarManager.add(refreshAction);
		toolBarManager.add(xmlSocketAction.getActionXMLSocketView());
		// Editor Pats closeANV
		toolBarManager.add(getActionBuilder().actionCloseAllEditors());

	}

	/**
	 * ActionBuilderԂ܂B
	 * 
	 * @return actionBuilder ActionBuilder
	 */
	public ActionBuilderEditorsPartClose getActionBuilder() {
		return actionBuilder;
	}

	/**
	 * u{́vŏʃO[vBgetParentnullԂAr[ɂ͌ȂỹO[vB
	 * <p>
	 */
	private static final class RootOfRootEngineTreeGroup extends
			EngineTreeGroup {
		RootOfRootEngineTreeGroup() {

		}

		/**
		 * em[hԂ܂B
		 * 
		 * @return em[h
		 */
		public EngineTreeGroup getParent() {
			return null;
		}

		/**
		 * qm[h폜܂B
		 * 
		 * @param toRemove
		 *            Node
		 */
		public void removeChild(Node toRemove) {
			// ROOT O[vƍB
		}
	}

	protected void finalize() throws java.lang.Throwable {
		super.finalize();
		if (engineIocnImage != null && engineIocnImage.isDisposed()) {
			engineIocnImage.dispose();
		}
		if (engineStopIocnImage != null && engineStopIocnImage.isDisposed()) {
			engineStopIocnImage.dispose();
		}

	}
}
