/*
 * Created on 2005/02/12
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.preferences;

import java.io.IOException;
import java.util.logging.Logger;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.widgets.Shell;


/**
 * HTTPANZXp̃vtFXNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class HttpAccessPreference {
    /*  */
    private static final String HTTP_URL_XML_NODE_INFO_LIST =
        "nodewatch/export/NodeRegisterInfoExportAction";

    /* ʃm[hMapANZXURL */
    private static final String NODE_MAP = "nodemapframe.do?engineAddress=all";

    /* F؃m[h}l[WANZXURL */
    private static final String AUTH_NODE_LIST =
        "manager/authNodemanagerFrame.do?engineAddress=all";

    /* ʃm[h}l[WANZXURL */
    private static final String NODE_LIST =
        "nodemanagerFrame.do?engineAddress=all";

    /* eiX}l[WANZXURL */
    private static final String MAINTENANCE =
        "maintenance/maintestart.do?engineAddress=all";

    /* F؃m[hr[ANZXURL */
    private static final String AUTH_NODE_VIEW = "manager/authNodeviewframe.do";

    /* ʃm[hr[ANZXURL */
    private static final String NODE_VIEW = "nodeviewframe.do";

    /* MO */
    private static Logger logger = null;

    /* HTTP֘AvtFX */
    private static PreferenceStore webAccessPref;

    /**
        * HttpANZXpPreferenceNXCX^X
        * ܂B
        *
        */
    private HttpAccessPreference() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * httpANZXURLihttp://host:|[gԍ/Context/j
     * Ԃ܂B
     *
     * @return URL
     * @throws HttpAccessPreferenceException preferenceANZX
     * sꍇ
     */
    public String getUrl() throws HttpAccessPreferenceException {
        webAccessPref =
            new PreferenceStore(HttpAccessPreferencePage.WEB_PREFERENCE);

        try {
            webAccessPref.load();
        } catch (IOException e1) {
            logger.warning(
                "HTTP access preference load error : " + e1.getMessage());

            Shell shell = new Shell();

            MessageDialog.openError(
                shell, "HTTP access preference load error",
                "HTTP access Preference load error.");
            shell.dispose();

            /*
             * HTTPANZXURLvtFXɒ`ĂȂ
             * ꍇ
             */
            throw new HttpAccessPreferenceException(
                "HTTP access preference load error");

            // return "Error " + e1.getMessage();
        }

        return webAccessPref.getString(HttpAccessPreferencePage.HTTP_URL_KEY);
    }

    /**
     * m[hĎ񃊃XgC|[g邽߂HTTP UrlԂ܂B
     *
     * @return nodeListImportUrl m[hĎ񃊃XgC|[g邽߂HTTP Url
     * @throws HttpAccessPreferenceException preferenceANZX
     * sꍇ
     */
    public String getNodeListImportUrl() throws HttpAccessPreferenceException {
        String nodeListImportUrl = getUrl() + HTTP_URL_XML_NODE_INFO_LIST;

        return nodeListImportUrl;
    }

    /**
     * ʃm[hMapuEU\pURLԂ܂B
     *
     * @return menuUrl ʃm[hMapuEU\pURL
     * @throws HttpAccessPreferenceException preferenceANZX
     * sꍇ
     */
    public String getNodeMapUrl() throws HttpAccessPreferenceException {
        String menuUrl = getUrl() + NODE_MAP;

        return menuUrl;
    }

    /**
     * ێ}l[WuEU\pURLԂ܂B
     *
     * @return menuUrl ێ}l[WuEU\pURL
     * @throws HttpAccessPreferenceException preferenceANZX
     * sꍇ
     */
    public String getMaintenanceUrl() throws HttpAccessPreferenceException {
        String menuUrl = getUrl() + MAINTENANCE;

        return menuUrl;
    }

    /**
     * F؃m[h}l[WuEU\pURLԂ܂B
     *
     * @return menuUrl F؃m[h}l[WuEU\pURL
     * @throws HttpAccessPreferenceException preferenceANZX
     * sꍇ
     */
    public String getAuthNodeManagerUrl() throws HttpAccessPreferenceException {
        String menuUrl = getUrl() + AUTH_NODE_LIST;

        return menuUrl;
    }

    /**
     * ʃm[h}l[WuEU\pURLԂ܂B
     *
     * @return menuUrl ʃm[h}l[WuEU\pURL
     * @throws HttpAccessPreferenceException preferenceANZX
     * sꍇ
     */
    public String getNodeManagerUrl() throws HttpAccessPreferenceException {
        String menuUrl = getUrl() + NODE_LIST;

        return menuUrl;
    }

    /**
     * F؃m[hViewuEU\URLԂ܂B
     *
     * @return nodeViewUrl F؃m[hViewuEU\URL
     * @throws HttpAccessPreferenceException preferenceANZX
     * sꍇ
     */
    public String getAuthNodeViewUrl() throws HttpAccessPreferenceException {
        String nodeViewUrl = getUrl() + AUTH_NODE_VIEW;

        return nodeViewUrl;
    }

    /**
     * F؃m[hViewuEU\URLԂ܂B
     *
     * @return nodeViewUrl F؃m[hViewuEU\URL
     * @throws HttpAccessPreferenceException preferenceANZX
     * sꍇ
     */
    public String getNodeViewUrl() throws HttpAccessPreferenceException {
        String nodeViewUrl = getUrl() + NODE_VIEW;

        return nodeViewUrl;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static HttpAccessPreference getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final HttpAccessPreference RESOURCE = new HttpAccessPreference();
    }
}
