/*
 * Created on 2005/02/03
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.preferences;

import java.io.IOException;
import java.util.logging.Logger;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;


/**
 * HTTPANZXvtFXy[W\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class HttpAccessPreferencePage extends PreferencePage
    implements IWorkbenchPreferencePage {
    /** HTTPANZXvtFXۑt@C */
    public static final String WEB_PREFERENCE = "resources/webAccess.pref";

    /** HTTPANZXvtFXHostANZXKey */
    public static final String HTTP_HOST_KEY = "HTTP_HOST";

    /** HTTPANZXvtFXPortANZXKey */
    public static final String HTTP_PORT_KEY = "HTTP_PORT";

    /** HTTPANZXvtFXContextANZXKey */
    public static final String HTTP_CONTEXT_KEY = "HTTP_CONTEXT";

    /** HTTPANZXvtFXHostANZXKey */
    public static final String DEFAULT_HTTP_HOST_DATA = "127.0.0.1";

    /** HTTPANZXvtFXPortANZXKey */
    public static final String DEFAULT_HTTP_PORT_DATA = "8080";

    /** HTTPANZXvtFXContextANZXKey */
    public static final String DEFAULT_HTTP_CONTEXT_DATA = "netjfwatcher";

    /** HTTPANZXvtFXUrlANZXKey */
    public static final String HTTP_URL_KEY = "HTTP_URL";

    /* HTTPANZXvtFXHost\x */
    private static final String HTTP_HOST_LABEL = "HTTP HOST";

    /* HTTPANZXvtFXPort\x */
    private static final String HTTP_PORT_LABEL = "HTTP PORT";

    /* HTTPANZXvtFXContext\x */
    private static final String HTTP_CONTEXT_LABEL = "CONTEXT";

    /* HTTPANZXvtFXUrl\x */
    private static final String HTTP_URL_LABEL = "URL";

    /* MO */
    private static Logger logger;

    /* Http Host text */
    private static final int HTTP_HOST_TEXT_WIDTH = 150;

    /* Http Port text */
    private static final int HTTP_PORT_TEXT_WIDTH = 50;

    /* Http Context text */
    private static final int HTTP_CONTEXT_TEXT_WIDTH = 150;

    /* Http URL text */
    private static final int HTTP_URL_TEXT_WIDTH = 300;

    /* GridData Horizontal Span */
    private static final int HORIZONTALSPAN = 4;

    /* HTTPANZXvtFXHost\eLXg */
    private Text httpHost;

    /* HTTPANZXvtFXPort\eLXg */
    private Text httpPort;

    /* HTTPANZXvtFXContext\eLXg */
    private Text httpContext;

    /* HTTPANZXvtFXUrl\eLXg */
    private Text httpUrltext;

    /* HTTPANZXvtFX */
    private PreferenceStore webAccessPref;

    /* m[heLXg\BackGroundFi[ */
    private Color textBackColor;

    /**
     * HTTPANZXvtFXy[WCX^X𐶐
     * ܂B
     *
     */
    public HttpAccessPreferencePage() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * vtFXy[W̏ݒs܂B
     *
     * @param workbench IWorkbench
     */
    public void init(IWorkbench workbench) {
        /* HTTPANZXvtFXt@C[h */
        webAccessPref = new PreferenceStore(WEB_PREFERENCE);

        try {
            webAccessPref.load();
        } catch (IOException e1) {
            logger.info(
                "HTTP Access preference IOException : " + e1.getMessage());

            // e1.printStackTrace();
        }
    }

    /**
     * HTTPANZXvtFXy[WRec𐶐܂B
     *
     * @param parent Composite
     * @return Control
     */
    protected Control createContents(Composite parent) {
        /* TextwiFZbg */
        textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);

        Composite composite = new Composite(parent, SWT.NULL);
        composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        composite.setLayout(gridLayout);

        GridData gridData = new GridData();
        gridData.horizontalSpan = HORIZONTALSPAN;

        Label label = new Label(composite, SWT.NONE);
        label.setText(HTTP_HOST_LABEL);
        label.setLayoutData(new GridData());
        httpHost = new Text(composite, SWT.BORDER);
        httpHost.setText(webAccessPref.getString(HTTP_HOST_KEY));
        gridData = new GridData();
        gridData.widthHint = HTTP_HOST_TEXT_WIDTH;
        httpHost.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText(HTTP_PORT_LABEL);
        label.setLayoutData(new GridData());
        httpPort = new Text(composite, SWT.BORDER);
        httpPort.setText(webAccessPref.getString(HTTP_PORT_KEY));
        gridData = new GridData();
        gridData.widthHint = HTTP_PORT_TEXT_WIDTH;
        httpPort.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText(HTTP_CONTEXT_LABEL);
        label.setLayoutData(new GridData());
        httpContext = new Text(composite, SWT.BORDER);
        httpContext.setText(webAccessPref.getString(HTTP_CONTEXT_KEY));
        gridData = new GridData();
        gridData.widthHint = HTTP_CONTEXT_TEXT_WIDTH;
        httpContext.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText(HTTP_URL_LABEL);
        label.setLayoutData(new GridData());

        httpUrltext = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        /* PreferenceHTTP_URL擾TextɃZbg */
        httpUrltext.setText(webAccessPref.getString(HTTP_URL_KEY));
        gridData = new GridData();
        gridData.widthHint = HTTP_URL_TEXT_WIDTH;
        httpUrltext.setLayoutData(gridData);
        httpUrltext.setEditable(false);
        httpUrltext.setEnabled(false);
        httpUrltext.setBackground(textBackColor);

        return composite;
    }

    /**
     * ftHg{^łB
     * HTTPANZX\Zbg܂B
     */
    protected void performDefaults() {
        httpHost.setText(webAccessPref.getString(HTTP_HOST_KEY));
        httpPort.setText(webAccessPref.getString(HTTP_PORT_KEY));
        httpContext.setText(webAccessPref.getString(HTTP_CONTEXT_KEY));
        httpUrltext.setText(webAccessPref.getString(HTTP_URL_KEY));
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    public boolean performOk() {
        // IPreferenceStore ps = getPreferenceStore();
        String workUrl =
            "http://" + httpHost.getText() + ":" + httpPort.getText() + "/"
            + httpContext.getText() + "/";

        httpUrltext.setText(workUrl);

        webAccessPref.setValue(HTTP_URL_KEY, httpUrltext.getText());
        webAccessPref.setValue(HTTP_HOST_KEY, httpHost.getText());
        webAccessPref.setValue(HTTP_PORT_KEY, httpPort.getText());
        webAccessPref.setValue(HTTP_CONTEXT_KEY, httpContext.getText());

        try {
            webAccessPref.save();
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }

        return super.performOk();
    }
}
