/*-------------*/
/* dxf2dat.cpp */
/*-------------*/
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<math.h>
#include "dxf2dat.h"

#define RTSTR 1024              //まさか1行が1000文字もあるわけないですが


//****** 1行ごとに読んでいく。引数はfgetsと同じ ******//
bool readline(char *s, int size, FILE * stream)
{
    if (fscanf(stream, "%s", s) == EOF) //1行まるまる文字列で読み込む。正しいDXFならスペースとか入らないでしょう。scanf系で十分のはず
        return false;           //もしもEEOFならさようなら
    char *a;
    a = strrchr(s, '\n');       //文字列の中に改行コードが（入る訳無いけど）あれば弾く。なんで私はこんなコードを混ぜたのか不明だけど、変えて動かなくな困るとから残しときます。
    if (a != NULL)
      {
          *a = '\0';
      }
    return true;
}
int g_linescnt;                 //平面数のカウント


//****** 各平面に対して。3DFACEフラグから0フラグまで一纏まりに処理 *****//
bool atSurface(FILE * in, FILE * out, char rtstr[])
{
    int i;
    char str[1024], flg[4];
    double x[4], y[4], z[4];
    int fx = 0, fy = 0, fz = 0;
    readline(rtstr, RTSTR, in); //最初の行を読み
    if (strcmp("3DFACE", rtstr) != 0)   //正しく3DFACEであるか
      {
          return true;
      }
    do                          //各要素に対して
      {
          readline(flg, sizeof(flg), in);       //フラグ行を読む




          //* その平面を読み終わった時の処理 *//
          if (strcmp(flg, "0") == 0)    //0フラグ（その平面に対して終わり）なら
            {
                if (fx != fy && fx != fz)       //xyz座標について同じ数の座標が拾えたか
                  {
                      printf("xyzの座票数が一致しません\n");
                      return false;
                  }
                fprintf(out, "%d\n", fx);       //拾った平面の角数を中間ファイルに出力
                g_linescnt++;   //平面数をカウント
                //平面の座標を出力
                for (i = 0; i < fx; i++)        //各角に対して
                  {
                      if (i > 0)
                          fprintf(out, " ");
                      fprintf(out, "%.15lf %.15lf %.15lf", x[i], y[i], z[i]);
                  }
                fprintf(out, "\n");
                return true;
            }
          //* 座標を読んで拾っていく処理 *//
          readline(str, sizeof(str), in);       //座標行を読む
          switch (flg[0])
            {
            case '0':          //終了フラグなら
                break;          //終了フラグかどうかは事前に拾っているけど、念のためです
            case '1':          //x座標
                x[fx] = atof(str);
                if (fx != atoi(flg) % 10)
                    printf("fxと文脈中の点番号が一致しません\n");
                fx++;
                break;
            case '2':          //y座標
                y[fy] = atof(str);
                if (fy != atoi(flg) % 10)
                    printf("fyと文脈中の点番号が一致しません\n");
                fy++;
                break;
            case '3':          //z座標
                z[fz] = atof(str);
                if (fz != atoi(flg) % 10)
                    printf("fzと文脈中の点番号が一致しません\n");
                fz++;
                break;
            default:
                return false;

            }
      }
    while (true);
}



//****** dxfファイルを読んでdatファイルを吐く関数 ******//
int dxf2dat(char input[], char output[])
{
    g_linescnt = 0;
    //読むファイルと開くファイルを開く処理
    FILE *in, *out;
    in = fopen(input, "r");
    if (in == NULL)
      {
          printf("dxfファイル %s が読めません\n", input);
          exit(1);
      }
    out = fopen(output, "w");
    if (out == NULL)
      {
          printf("中間ファイル %s を生成できません。\n", output);
          exit(1);
      }
    int *pointinf;
    char strbuf[RTSTR];
    int i;

    for (i = 0; i < 5; i++)
        readline(strbuf, sizeof(strbuf), in);   //最初の5行は読み飛ばす(ヘッダーなので）最後に読んだ行はstrbufに残っている（下のfor文のところでつかってます）
    //各平面ごとにatSurface関数に投げていく。
    //前の平面が終わった次の行がENDSECなら図形の最後と判断して終わる
    for (int i = 0; strcmp(strbuf, "ENDSEC") != 0; i++)
      {
          atSurface(in, out, strbuf);
      }
    fclose(in);
    fclose(out);
    return g_linescnt;
}
