/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.builtin;

import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkArray;
import net.morilib.awk.nano.value.AwkInteger;
import net.morilib.awk.nano.value.AwkString;
import net.morilib.awk.nano.value.AwkValue;

public class AwkSplit
extends AwkExpression {
    private AwkExpression src;
    private AwkExpression dest;
    private AwkExpression delimiter;

    public AwkSplit(AwkExpression src, AwkExpression dest, AwkExpression delimiter) {
        this.src = src;
        this.dest = dest;
        this.delimiter = delimiter;
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles f) {
        StringBuffer b = null;
        AwkArray r = new AwkArray();
        boolean ws = true;
        String dl = this.delimiter.eval(ns, f).toString(ns);
        String s = this.src.eval(ns, f).toString(ns);
        int k = 1;
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (ws && dl.indexOf(c) < 0) {
                b = new StringBuffer().appendCodePoint(c);
                ws = false;
            } else if (!ws && dl.indexOf(c) >= 0) {
                r.putArray(AwkInteger.valueOf(k++).toString(ns), AwkString.valueOf(b.toString()));
                b = null;
                ws = true;
            } else if (!ws) {
                b.appendCodePoint(c);
            }
            i += c > 65535 ? 2 : 1;
        }
        if (b != null) {
            r.putArray(AwkInteger.valueOf(k).toString(ns), AwkString.valueOf(b.toString()));
        }
        this.dest.assign(ns, r, f);
        return AwkInteger.valueOf(r.size());
    }
}

