/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate.sh;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.nina.Quadro;
import net.morilib.nina.cmd.NinaInfo;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.sh.AbstractShFileSystem;
import net.morilib.sh.DefaultShVirtualDirectory;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShSecurityPolicy;
import net.morilib.sh.ShStat;

public class ShNinatFileSystem
extends AbstractShFileSystem {
    private static final String ROOT_D = "/" + NinaTranslator.class.getPackage().getName().replace('.', '/');
    private static final String LICENSE_D = String.valueOf(ROOT_D) + "/license";
    private static final Pattern PTN1 = Pattern.compile("/output/([^/]+)");
    private static final Pattern PTN2 = Pattern.compile("/license/([^/]+)");
    private DefaultShVirtualDirectory root;
    private DefaultShVirtualDirectory license;
    private ShFile outputDir;
    private ShFile fragmentFile;
    private ShFile definitionFile;
    private ShFile fieldFile;
    private ShFile headerFile;
    private ShFile readFile;
    private ShFile bufFile;
    private ShFile script1File;
    private ShFile script2File;
    private ShFile script3File;
    private ShFile yjavaFile;
    private ShFile ycsFile;
    private ShFile yjsFile;
    private ShFile ycFile;
    private ShFile njavaFile;
    private ShFile ncsFile;
    private ShFile njsFile;
    private ShFile ncFile;
    private ShFile sjavaFile;
    private ShFile scsFile;
    private ShFile sjsFile;
    private ShFile scFile;
    private ShFile descFile;
    private ShFile licFile;
    private ShFile pliFile;
    private NinaInfo info;

    private StR newr(String s) {
        return new StR(s, String.valueOf(LICENSE_D) + "/" + s + ".txt");
    }

    private StR newr0(String s) {
        return new StR(s, String.valueOf(ROOT_D) + "/" + s);
    }

    public ShNinatFileSystem(String f, Quadro q, NinaInfo info) {
        this.info = info;
        this.root = new DefaultShVirtualDirectory(null, null);
        this.fragmentFile = new StF("fragment", f);
        this.definitionFile = new StF("definition", q.getDefinition());
        this.fieldFile = new StF("field", q.getFragmentField());
        this.headerFile = new StF("header", q.getFragmentByName("header"));
        this.readFile = new StF("read", q.getFragmentByName("read"));
        this.descFile = new StF("description", q.getDescription());
        this.licFile = new StF("userlicense", q.getLicense().trim());
        this.bufFile = new StB("tmp1");
        this.script1File = this.newr0("nina_template.dfa.js.sub1.sh");
        this.script2File = this.newr0("nina_template.nfa.js.sub1.sh");
        this.script3File = this.newr0("nina_template.tm.js.sub1.sh");
        this.yjavaFile = this.newr0("y.tab.java.sh");
        this.ycsFile = this.newr0("y.tab.cs.sh");
        this.yjsFile = this.newr0("y.tab.js.sh");
        this.ycFile = this.newr0("y.tab.c.sh");
        this.njavaFile = this.newr0("nina_template.nfa.java.sh");
        this.ncsFile = this.newr0("nina_template.nfa.cs.sh");
        this.njsFile = this.newr0("nina_template.nfa.js.sh");
        this.ncFile = this.newr0("nina_template.nfa.c.sh");
        this.sjavaFile = this.newr0("nina_template.nfa.java.sub2.sh");
        this.scsFile = this.newr0("nina_template.nfa.cs.sub2.sh");
        this.sjsFile = this.newr0("nina_template.nfa.js.sub2.sh");
        this.scFile = this.newr0("nina_template.nfa.c.sub2.sh");
        this.pliFile = this.newr0("putlicense_cstyle.sh");
        this.license = new DefaultShVirtualDirectory(this.root, "license");
        this.root.addFile(this.fragmentFile);
        this.root.addFile(this.definitionFile);
        this.root.addFile(this.fieldFile);
        this.root.addFile(this.headerFile);
        this.root.addFile(this.readFile);
        this.root.addFile(this.descFile);
        this.root.addFile(this.licFile);
        this.root.addFile(this.bufFile);
        this.root.addFile(this.script1File);
        this.root.addFile(this.script2File);
        this.root.addFile(this.script3File);
        this.root.addFile(this.yjavaFile);
        this.root.addFile(this.ycsFile);
        this.root.addFile(this.yjsFile);
        this.root.addFile(this.ycFile);
        this.root.addFile(this.njavaFile);
        this.root.addFile(this.ncsFile);
        this.root.addFile(this.njsFile);
        this.root.addFile(this.ncFile);
        this.root.addFile(this.sjavaFile);
        this.root.addFile(this.scsFile);
        this.root.addFile(this.sjsFile);
        this.root.addFile(this.scFile);
        this.root.addFile(this.pliFile);
        this.root.addFile(this.license);
        this.root.addFile(info.getShOutputDir(this));
        this.license.addFile(this.newr("apache"));
        this.license.addFile(this.newr("bsd"));
        this.license.addFile(this.newr("bsd2"));
        this.license.addFile(this.newr("default"));
        this.license.addFile(this.newr("gpl"));
        this.license.addFile(this.newr("lgpl"));
        this.license.addFile(this.newr("mit"));
    }

    @Override
    public ShFile getRoot() {
        return this.root;
    }

    @Override
    public ShFile getFile(String s) {
        if (s.equals("/")) {
            return this.root;
        }
        if (s.equals("fragment")) {
            return this.fragmentFile;
        }
        if (s.equals("definition")) {
            return this.definitionFile;
        }
        if (s.equals("field")) {
            return this.fieldFile;
        }
        if (s.equals("header")) {
            return this.headerFile;
        }
        if (s.equals("read")) {
            return this.readFile;
        }
        if (s.equals("description")) {
            return this.descFile;
        }
        if (s.equals("userlicense")) {
            return this.licFile;
        }
        if (s.equals("tmp1")) {
            return this.bufFile;
        }
        if (s.equals("nina_template.dfa.js.sub1.sh")) {
            return this.script1File;
        }
        if (s.equals("nina_template.nfa.js.sub1.sh")) {
            return this.script2File;
        }
        if (s.equals("nina_template.tm.js.sub1.sh")) {
            return this.script3File;
        }
        if (s.equals("y.tab.java.sh")) {
            return this.yjavaFile;
        }
        if (s.equals("y.tab.cs.sh")) {
            return this.ycsFile;
        }
        if (s.equals("y.tab.js.sh")) {
            return this.yjsFile;
        }
        if (s.equals("y.tab.c.sh")) {
            return this.ycFile;
        }
        if (s.equals("nina_template.nfa.java.sh")) {
            return this.njavaFile;
        }
        if (s.equals("nina_template.nfa.cs.sh")) {
            return this.ncsFile;
        }
        if (s.equals("nina_template.nfa.js.sh")) {
            return this.njsFile;
        }
        if (s.equals("nina_template.nfa.c.sh")) {
            return this.ncFile;
        }
        if (s.equals("nina_template.nfa.java.sub2.sh")) {
            return this.sjavaFile;
        }
        if (s.equals("nina_template.nfa.cs.sub2.sh")) {
            return this.scsFile;
        }
        if (s.equals("nina_template.nfa.js.sub2.sh")) {
            return this.sjsFile;
        }
        if (s.equals("nina_template.nfa.c.sub2.sh")) {
            return this.scFile;
        }
        if (s.equals("putlicense_cstyle.sh")) {
            return this.pliFile;
        }
        if (s.equals("/output")) {
            return this.outputDir;
        }
        if (s.equals("/license")) {
            return this.license;
        }
        Matcher m = PTN1.matcher(s);
        if (m.matches()) {
            return this.info.getShOutputFile(this, s, m.group(1));
        }
        m = PTN2.matcher(s);
        if (m.matches()) {
            return this.license.getFile(m.group(1));
        }
        return null;
    }

    @Override
    public ShFile getFile(String dir, String name) {
        return this.getFile(this.getFile(dir), name);
    }

    @Override
    public ShFile getFile(ShFile dir, String name) {
        return null;
    }

    @Override
    public ShFile getNativeFile(String s) {
        return this.getFile(s);
    }

    @Override
    public ShSecurityPolicy getSecurityPolicy() {
        return ShSecurityPolicy.ALL_PERMITTED;
    }

    @Override
    public InputStream getProfile() {
        return null;
    }

    @Override
    public InputStream getRc() {
        return null;
    }

    @Override
    public ShFile getHome() {
        return this.getRoot();
    }

    @Override
    public ShFile searchPath(ShEnvironment env, String name) {
        return null;
    }

    private static class StB
    implements ShFile {
        private String name;
        private ByteArrayOutputStream ous = null;
        private PrintStream pr;

        StB(String name) {
            this.name = name;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isExist() {
            return true;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isZeroFile() {
            return this.ous.size() == 0;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Collection<ShFile> getFiles() {
            return Collections.emptySet();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.ous != null) {
                return new ByteArrayInputStream(this.ous.toByteArray()){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        StB.this.ous = null;
                    }
                };
            }
            return null;
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            if (append && this.ous != null) {
                return this.pr;
            }
            this.ous = new ByteArrayOutputStream();
            this.pr = new PrintStream(this.ous);
            return this.pr;
        }

        @Override
        public ShProcess getProcess() {
            return null;
        }

        @Override
        public ShFile toAbsolute() {
            return this;
        }

        @Override
        public ShFile toCanonical() {
            return this;
        }

        @Override
        public boolean mkdir() {
            return false;
        }

        @Override
        public boolean renameTo(ShFile f) {
            return false;
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public boolean rmdir() {
            return false;
        }

        @Override
        public boolean deleteFile() {
            return false;
        }

        @Override
        public ShStat getStat() {
            return new ShStat(this.toString(), 0L, this.ous.size(), 2);
        }

        public String toString() {
            return this.name;
        }
    }

    private static class StF
    implements ShFile {
        private byte[] buf;
        private String name;

        StF(String name, String f) {
            this.name = name;
            this.buf = f.getBytes();
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isExist() {
            return true;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isZeroFile() {
            return this.buf.length == 0;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Collection<ShFile> getFiles() {
            return Collections.emptySet();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.buf);
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            return null;
        }

        @Override
        public ShProcess getProcess() {
            return null;
        }

        @Override
        public ShFile toAbsolute() {
            return this;
        }

        @Override
        public ShFile toCanonical() {
            return this;
        }

        @Override
        public boolean mkdir() {
            return false;
        }

        @Override
        public boolean renameTo(ShFile f) {
            return false;
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public boolean rmdir() {
            return false;
        }

        @Override
        public boolean deleteFile() {
            return false;
        }

        @Override
        public ShStat getStat() {
            return new ShStat(this.toString(), 0L, this.buf.length, 1);
        }

        public String toString() {
            return this.name;
        }
    }

    private static class StR
    implements ShFile {
        private String name;
        private String resource;

        StR(String name, String r) {
            this.name = name;
            this.resource = r;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isExist() {
            return true;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isZeroFile() {
            return false;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Collection<ShFile> getFiles() {
            return Collections.emptySet();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return StR.class.getResourceAsStream(this.resource);
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            return null;
        }

        @Override
        public ShProcess getProcess() {
            return null;
        }

        @Override
        public ShFile toAbsolute() {
            return this;
        }

        @Override
        public ShFile toCanonical() {
            return this;
        }

        @Override
        public boolean mkdir() {
            return false;
        }

        @Override
        public boolean renameTo(ShFile f) {
            return false;
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public boolean rmdir() {
            return false;
        }

        @Override
        public boolean deleteFile() {
            return false;
        }

        @Override
        public ShStat getStat() {
            return new ShStat(this.toString(), 0L, 85L, 1);
        }

        public String toString() {
            return this.name;
        }
    }
}

