/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.range.CharSetException;
import net.morilib.range.Interval;
import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.range.Ranges;
import net.morilib.util.CharCodes;

public final class CharSets {
    public static final Range ALL_CHAR = IntervalsInt.newClosedInterval(0, Integer.MAX_VALUE);
    public static final Range NUMBERS = CharSets.newCharInterval('0', '9');
    public static final Range NOT_NUMBER = CharSets.complement(NUMBERS);
    public static final Range ASCII_CONTROLSPACE = CharSets.newCharInterval('\t', '\r');
    public static final Range ASCII_WHITESPACE = ASCII_CONTROLSPACE.join(Interval.newPoint(32));
    public static final Range NOT_ASCII_WHITESPACE = CharSets.complement(ASCII_WHITESPACE);
    public static final Range ASCII_WORD = CharSets.parse("a-zA-Z_0-9");
    public static final Range NOT_ASCII_WORD = CharSets.parse("^a-zA-Z_0-9");
    public static final Range ASCII_NUMBERS = CharSets.newCharInterval('0', '9');
    public static final Range CAPITAL_LETTERS = CharSets.newCharInterval('A', 'Z');
    public static final Range SMALL_LETTERS = CharSets.newCharInterval('a', 'z');
    public static final Range ENGLISH_ALPHABETS = Ranges.sum(CAPITAL_LETTERS, SMALL_LETTERS);
    public static final Range ENGLISH_ALPHABETS_NUMBERS = Ranges.sum(ENGLISH_ALPHABETS, ASCII_NUMBERS);
    public static final Range HIRAGANA = CharSets.newCharInterval('\u3041', '\u3094');
    public static final Range KATAKANA = CharSets.newCharInterval('\u30a1', '\u30fa');
    public static final Range SPACES = Ranges.sum(IntervalsInt.newPoint(32), IntervalsInt.newPoint(9));
    public static final Range TOKEN = Ranges.sum(IntervalsInt.newPoint(32), IntervalsInt.newPoint(9));
    private static final String PROPNAME = "/" + CharSets.class.getPackage().getName().replace('.', '/') + "/charset2.txt";
    private static final Map<String, Range> _RANGE;
    private static final String DEFCD = "UTF-8";

    static {
        InputStream ins = null;
        _RANGE = new HashMap<String, Range>();
        try {
            try {
                String s;
                ins = CharSets.class.getResourceAsStream(PROPNAME);
                BufferedReader rd = new BufferedReader(new InputStreamReader(ins));
                while ((s = rd.readLine()) != null) {
                    if (s.equals("") || s.charAt(0) == '#') continue;
                    int k = s.indexOf(61);
                    if (k < 0) {
                        _RANGE.put(s, Range.O);
                        continue;
                    }
                    String p = s.substring(0, k);
                    String q = s.substring(k + 1);
                    _RANGE.put(p, CharSets.parse(q, DEFCD));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private CharSets() {
    }

    public static final Range newCharInterval(char f, char t) {
        return IntervalsInt.newClosedInterval(f, t);
    }

    public static final Range newCharInterval(char c) {
        return IntervalsInt.newClosedInterval(c, c);
    }

    private static Interval getintv(int ch, int ch2) {
        return IntervalsInt.newClosedInterval(ch, ch2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parse(CharSequence s, int start, String cset, CharSetHandler h) {
        StringBuilder b = new StringBuilder();
        int cb = -1;
        int pt = start;
        int st = 1;
        block28: while (pt < s.length()) {
            int c;
            try {
                c = s.charAt(pt++);
                c = CharCodes.unicodeToOtherCode((char)c, cset);
            }
            catch (UnsupportedEncodingException e1) {
                throw new CharSetException();
            }
            if (st == 1) {
                if (c == 92) {
                    st = 2;
                    continue;
                }
                cb = c;
                st = 4;
                continue;
            }
            if (st == 2) {
                switch (c) {
                    case 117: 
                    case 120: {
                        st = 3;
                        break;
                    }
                    case 92: {
                        cb = c;
                        st = 4;
                        break;
                    }
                    case 116: {
                        cb = 9;
                        st = 4;
                        break;
                    }
                    case 110: {
                        cb = 10;
                        st = 4;
                        break;
                    }
                    case 114: {
                        cb = 13;
                        st = 4;
                        break;
                    }
                    case 102: {
                        cb = 12;
                        st = 4;
                        break;
                    }
                    case 100: {
                        h.addRange(NUMBERS);
                        st = 1;
                        break;
                    }
                    case 68: {
                        h.addRange(NOT_NUMBER);
                        st = 1;
                        break;
                    }
                    case 115: {
                        h.addRange(ASCII_WHITESPACE);
                        st = 1;
                        break;
                    }
                    case 83: {
                        h.addRange(NOT_ASCII_WHITESPACE);
                        st = 1;
                        break;
                    }
                    case 119: {
                        h.addRange(ASCII_WORD);
                        st = 1;
                        break;
                    }
                    case 87: {
                        h.addRange(NOT_ASCII_WORD);
                        st = 1;
                        break;
                    }
                    case 112: {
                        st = 8;
                        break;
                    }
                    default: {
                        cb = c;
                        st = 4;
                        break;
                    }
                }
                continue;
            }
            if (st == 3) {
                if (pt + 2 >= s.length()) {
                    throw new CharSetException();
                }
                b.append((char)c);
                b.append(s.charAt(pt));
                b.append(s.charAt(++pt));
                b.append(s.charAt(++pt));
                ++pt;
                try {
                    cb = Integer.parseInt(b.toString(), 16);
                    b.delete(0, b.length());
                    st = 4;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Illegal code");
                }
            }
            if (st == 4) {
                if (c == 92) {
                    h.singleChar(cb);
                    st = 2;
                    continue;
                }
                if (c == 45) {
                    st = 5;
                    continue;
                }
                h.singleChar(cb);
                cb = c;
                st = 4;
                continue;
            }
            if (st == 5) {
                if (c == 92) {
                    st = 6;
                    continue;
                }
                if (c < cb) {
                    throw new CharSetException();
                }
                h.rangedChar(cb, c);
                st = 1;
                continue;
            }
            if (st == 6) {
                switch (c) {
                    case 117: 
                    case 120: {
                        st = 7;
                        continue block28;
                    }
                    case 92: {
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                    }
                }
                if (c < cb) {
                    throw new CharSetException(String.valueOf(cb) + ">" + c);
                }
                h.rangedChar(cb, c);
                st = 1;
                continue;
            }
            if (st == 7) {
                if (pt + 2 >= s.length()) {
                    throw new CharSetException();
                }
                b.append((char)c);
                b.append(s.charAt(pt));
                b.append(s.charAt(++pt));
                b.append(s.charAt(++pt));
                ++pt;
                try {
                    int cz = Integer.parseInt(b.toString(), 16);
                    if (cz < cb) {
                        throw new CharSetException();
                    }
                    h.rangedChar(cb, cz);
                    b.delete(0, b.length());
                    st = 1;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Illegal code");
                }
            }
            if (st == 8) {
                if (c == 123) {
                    st = 9;
                    continue;
                }
                if (c == 92) {
                    st = 2;
                    continue;
                }
                cb = c;
                st = 4;
                continue;
            }
            if (st != 9) continue;
            if (c != 125) {
                b.append((char)c);
                continue;
            }
            Range r = _RANGE.get(b.toString());
            if (r == null) {
                throw new RuntimeException("Illagal group:" + b.toString());
            }
            h.addRange(r);
        }
        if (st == 4) {
            h.singleChar(cb);
        }
    }

    public static void parse(CharSequence s, int start, CharSetHandler h) {
        CharSets.parse(s, start, DEFCD, h);
    }

    public static List<Interval> complement(Iterable<Interval> ra) {
        ArrayList<Interval> rb = new ArrayList<Interval>();
        int l = 0;
        for (Interval v : ra) {
            int m = (Integer)v.getInfimumBound();
            if (l <= m - 1) {
                rb.add(IntervalsInt.newClosedInterval(l, m - 1));
            }
            l = (Integer)v.getSupremumBound() + 1;
        }
        if (l < 0x7FFFFFFE) {
            rb.add(IntervalsInt.newClosedInterval(l, Integer.MAX_VALUE));
        }
        return rb;
    }

    public static Range complement(Range ra) {
        RangeAdder rb = new RangeAdder();
        for (Interval v : CharSets.complement(ra.intervals())) {
            rb.addInterval(v);
        }
        return rb.toRange();
    }

    public static Range parse(CharSequence s, String cset) {
        final RangeAdder ra = new RangeAdder();
        int k = 0;
        if (s.length() == 0) {
            throw new CharSetException();
        }
        boolean c = s.charAt(0) == '^';
        if (c) {
            ++k;
        }
        CharSets.parse(s, k, cset, new CharSetHandler(){

            @Override
            public void singleChar(int ch) {
                ra.add(CharSets.getintv(ch, ch));
            }

            @Override
            public void rangedChar(int cb, int ce) {
                ra.add(CharSets.getintv(cb, ce));
            }

            @Override
            public void addRange(Range r) {
                ra.add(r);
            }
        });
        return c ? CharSets.complement(ra.toRange()) : ra.toRange();
    }

    public static Range parse(CharSequence s) {
        return CharSets.parse(s, DEFCD);
    }

    private static List<Interval> parseTr(CharSequence s, String cset) {
        final ArrayList<Interval> ra = new ArrayList<Interval>();
        int k = 0;
        if (s.length() == 0) {
            throw new CharSetException();
        }
        boolean c = s.charAt(0) == '^';
        if (c) {
            ++k;
        }
        CharSets.parse(s, k, cset, new CharSetHandler(){

            @Override
            public void singleChar(int ch) {
                ra.add(CharSets.getintv(ch, ch));
            }

            @Override
            public void rangedChar(int cb, int ce) {
                ra.add(CharSets.getintv(cb, ce));
            }

            @Override
            public void addRange(Range r) {
                RangeAdder b = new RangeAdder();
                for (Interval v : ra) {
                    b.addInterval(v);
                }
                b.add(r);
                ra.clear();
                for (Interval v : b.toRange().intervals()) {
                    ra.add(v);
                }
            }
        });
        return c ? CharSets.complement(ra) : ra;
    }

    private static int card(Interval r1) {
        return (int)IntervalsInt.cardinality(r1);
    }

    private static int card(List<Interval> r1) {
        int r = 0;
        int i = 0;
        while (i < r1.size()) {
            r += (int)IntervalsInt.cardinality(r1.get(i));
            ++i;
        }
        return r;
    }

    public static String tr(CharSequence s, CharSequence t1, CharSequence t2, String cset) {
        StringBuilder b = new StringBuilder();
        List<Interval> r1 = CharSets.parseTr(t1, cset);
        List<Interval> r2 = CharSets.parseTr(t2, cset);
        if (CharSets.card(r1) != CharSets.card(r2)) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < s.length()) {
            block6: {
                int ind = 0;
                char c = s.charAt(i);
                int j = 0;
                while (j < r1.size()) {
                    Interval i1 = r1.get(j);
                    if (i1.contains(c)) {
                        int in2 = 0;
                        int c1 = (int)IntervalsInt.indexOf(i1, c);
                        int k = 0;
                        while (k < r2.size()) {
                            int cd2 = CharSets.card(r2.get(k));
                            if (ind + c1 < in2 + cd2) {
                                b.append((char)IntervalsInt.intAt(r2.get(k), c1));
                                break block6;
                            }
                            in2 += cd2;
                            ++k;
                        }
                        throw new RuntimeException();
                    }
                    ind += CharSets.card(i1);
                    ++j;
                }
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    public static String tr(CharSequence s, CharSequence t1, CharSequence t2) {
        return CharSets.tr(s, t1, t2, DEFCD);
    }

    public static interface CharSetHandler {
        public void singleChar(int var1);

        public void rangedChar(int var1, int var2);

        public void addRange(Range var1);
    }
}

