/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.sed.SedPatternEngine;
import net.morilib.sed.SedSubstituteFlags;

public class JavaStandardSedPatternEngine
implements SedPatternEngine {
    private static final SedPatternEngine INSTANCE = new JavaStandardSedPatternEngine();

    private JavaStandardSedPatternEngine() {
    }

    public static SedPatternEngine getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean matches(String pattern, String s, boolean ci, boolean am) {
        int fl = ci ? 2 : 0;
        Pattern p = Pattern.compile(pattern, fl);
        if (am) {
            return p.matcher(s).matches();
        }
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (p.matcher(s.substring(i)).lookingAt()) {
                return true;
            }
            i += c > 65535 ? 2 : 1;
        }
        return false;
    }

    @Override
    public String replace(String pattern, String source, String replace, SedSubstituteFlags flags) {
        Pattern p;
        Matcher m;
        int fl = 0;
        if (flags.isCaseInsensitive()) {
            fl |= 2;
        }
        if ((m = (p = Pattern.compile(pattern, fl)).matcher(source)).matches()) {
            String s = flags.isGlobal() ? m.replaceAll(replace) : m.replaceFirst(replace);
            return s;
        }
        return null;
    }

    public String toString() {
        return "Java standard regular expression";
    }
}

