/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeBlock
implements ShTree {
    private List<ShTree> line;

    public ShTreeBlock(List<ShTree> line) {
        this.line = new ArrayList<ShTree>(line);
    }

    @Override
    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream stdin, PrintStream stdout, PrintStream stderr, XtraceStream p) throws IOException, ShSyntaxException {
        int r = 0;
        for (ShTree s : this.line) {
            r = s.eval(env, fs, cmds, run, stdin, stdout, stderr, p);
        }
        return r;
    }

    @Override
    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        for (ShTree e : this.line) {
            e.compileInternally(b, brk, cnt);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer("{\n");
        String d = "";
        for (ShTree l : this.line) {
            b.append(d).append(l);
            d = " ; ";
        }
        return b.append("\n}").toString();
    }
}

