/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.arith;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.morilib.sh.arith.ShExprIntegerToken;
import net.morilib.sh.arith.ShExprOp;
import net.morilib.sh.arith.ShExprRelop1;
import net.morilib.sh.arith.ShExprRelop2;
import net.morilib.sh.arith.ShExprSymbol;
import net.morilib.sh.arith.ShExprSyntaxException;
import net.morilib.sh.arith.ShExprToken;

public final class ShExprLexer {
    private static final Map<Integer, ShExprToken> OP1;
    static final String ERR001 = "more than two characters is not allowed";
    private ShExprToken token;
    private ShExprToken backed = null;
    private PushbackReader reader;
    private int headchr = 0;

    static {
        HashMap<Integer, ShExprOp> o = new HashMap<Integer, ShExprOp>();
        o.put(63, ShExprOp.TRI1);
        o.put(58, ShExprOp.TRI2);
        o.put(126, ShExprOp.B_NOT);
        o.put(40, ShExprOp.LPAREN);
        o.put(41, ShExprOp.RPAREN);
        o.put(44, ShExprOp.COMMA);
        OP1 = Collections.unmodifiableMap(o);
    }

    public ShExprLexer(Reader rd) throws IOException {
        this.reader = new PushbackReader(rd);
        this.headchr = this.reader.read();
        if (this.headchr >= 0) {
            this.reader.unread(this.headchr);
        }
        this.token = ShExprLexer.getToken(this.reader);
    }

    public ShExprToken getToken() {
        return this.backed != null ? this.backed : this.token;
    }

    public ShExprToken nextToken() throws IOException {
        if (this.backed != null) {
            this.backed = null;
        } else if (!this.token.equals(ShExprToken.ENDMARKER)) {
            this.headchr = this.reader.read();
            if (this.headchr >= 0) {
                this.reader.unread(this.headchr);
            }
            this.token = ShExprLexer.getToken(this.reader);
        }
        return this.token;
    }

    public void backToken(ShExprToken t) {
        this.backed = t;
    }

    public ShExprToken eatToken(ShExprToken t) throws IOException {
        if (!this.token.equals(t)) {
            throw new ShExprSyntaxException();
        }
        return this.nextToken();
    }

    public ShExprToken eatTokenOpt(ShExprToken t) throws IOException {
        if (this.token.equals(t)) {
            return this.nextToken();
        }
        return this.token;
    }

    private static int skipws(PushbackReader rd) throws IOException {
        int c;
        boolean cm = false;
        while ((c = rd.read()) >= 0) {
            if (cm) {
                cm = c != 10;
                continue;
            }
            if (c == 35) {
                cm = true;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return c;
        }
        if (c < 0) {
            throw new EndException();
        }
        return c;
    }

    static ShExprToken _getToken(PushbackReader rd) throws IOException {
        StringBuffer b1 = new StringBuffer();
        St1 stat = St1.INIT;
        block22: while (true) {
            switch (stat) {
                case INIT: {
                    int c = ShExprLexer.skipws(rd);
                    if (c == 60) {
                        stat = St1.LT;
                        continue block22;
                    }
                    if (c == 62) {
                        stat = St1.GT;
                        continue block22;
                    }
                    if (c == 61) {
                        stat = St1.EQ;
                        continue block22;
                    }
                    if (c == 33) {
                        stat = St1.EX;
                        continue block22;
                    }
                    if (c == 38) {
                        stat = St1.AND;
                        continue block22;
                    }
                    if (c == 124) {
                        stat = St1.OR;
                        continue block22;
                    }
                    if (c == 43) {
                        stat = St1.PLUS;
                        continue block22;
                    }
                    if (c == 45) {
                        stat = St1.MINUS;
                        continue block22;
                    }
                    if (c == 42) {
                        stat = St1.ASTERISK;
                        continue block22;
                    }
                    if (c == 47) {
                        stat = St1.SLASH;
                        continue block22;
                    }
                    if (c == 37) {
                        stat = St1.PERCENT;
                        continue block22;
                    }
                    if (c == 94) {
                        stat = St1.CARET;
                        continue block22;
                    }
                    if (OP1.containsKey(c)) {
                        return OP1.get(c);
                    }
                    if (c == 48) {
                        stat = St1.ZERO;
                        continue block22;
                    }
                    if (c >= 49 && c <= 57) {
                        b1 = new StringBuffer().append((char)c);
                        stat = St1.NUMBER;
                        continue block22;
                    }
                    if (!(c >= 97 && c <= 122 || c >= 65 && c <= 122) && c != 95) continue block22;
                    b1 = new StringBuffer().appendCodePoint(c);
                    stat = St1.SYMBOL;
                    continue block22;
                }
                case LT: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprRelop1.LT;
                    }
                    if (c == 61) {
                        return ShExprRelop1.LE;
                    }
                    if (c == 60) {
                        stat = St1.SHIFTL;
                        continue block22;
                    }
                    rd.unread(c);
                    return ShExprRelop1.LT;
                }
                case SHIFTL: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprRelop1.SHIFTL;
                    }
                    if (c == 61) {
                        return ShExprRelop1.A_SFL;
                    }
                    rd.unread(c);
                    return ShExprRelop1.SHIFTL;
                }
                case GT: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprRelop1.GT;
                    }
                    if (c == 61) {
                        return ShExprRelop1.GE;
                    }
                    if (c == 62) {
                        stat = St1.SHIFTR;
                        continue block22;
                    }
                    rd.unread(c);
                    return ShExprRelop1.GT;
                }
                case SHIFTR: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprRelop1.SHIFTR;
                    }
                    if (c == 61) {
                        return ShExprRelop1.A_SFR;
                    }
                    rd.unread(c);
                    return ShExprRelop1.SHIFTR;
                }
                case EQ: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.ASSIGN;
                    }
                    if (c == 61) {
                        return ShExprRelop2.EQ;
                    }
                    return ShExprOp.ASSIGN;
                }
                case EX: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.L_NOT;
                    }
                    if (c == 61) {
                        return ShExprRelop2.NE;
                    }
                    rd.unread(c);
                    return ShExprOp.L_NOT;
                }
                case AND: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.B_AND;
                    }
                    if (c == 38) {
                        return ShExprOp.L_AND;
                    }
                    if (c == 61) {
                        return ShExprOp.A_BAND;
                    }
                    rd.unread(c);
                    return ShExprOp.B_AND;
                }
                case OR: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.B_OR;
                    }
                    if (c == 124) {
                        return ShExprOp.L_OR;
                    }
                    if (c == 61) {
                        return ShExprOp.A_BOR;
                    }
                    rd.unread(c);
                    return ShExprOp.B_OR;
                }
                case PLUS: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.ADD;
                    }
                    if (c == 43) {
                        return ShExprOp.INC;
                    }
                    if (c == 61) {
                        return ShExprOp.A_ADD;
                    }
                    rd.unread(c);
                    return ShExprOp.ADD;
                }
                case MINUS: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.SUB;
                    }
                    if (c == 45) {
                        return ShExprOp.DEC;
                    }
                    if (c == 61) {
                        return ShExprOp.A_SUB;
                    }
                    rd.unread(c);
                    return ShExprOp.SUB;
                }
                case ASTERISK: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.MUL;
                    }
                    if (c == 42) {
                        return ShExprOp.POW;
                    }
                    if (c == 61) {
                        return ShExprOp.A_MUL;
                    }
                    rd.unread(c);
                    return ShExprOp.MUL;
                }
                case SLASH: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.DIV;
                    }
                    if (c == 61) {
                        return ShExprOp.A_DIV;
                    }
                    rd.unread(c);
                    return ShExprOp.DIV;
                }
                case PERCENT: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.MOD;
                    }
                    if (c == 61) {
                        return ShExprOp.A_MOD;
                    }
                    rd.unread(c);
                    return ShExprOp.MOD;
                }
                case CARET: {
                    int c = rd.read();
                    if (c < 0) {
                        return ShExprOp.B_XOR;
                    }
                    if (c == 61) {
                        return ShExprOp.A_BXOR;
                    }
                    rd.unread(c);
                    return ShExprOp.B_XOR;
                }
                case ZERO: {
                    int c = rd.read();
                    if (c < 0) {
                        return new ShExprIntegerToken("0", 10);
                    }
                    if (c == 120) {
                        stat = St1.NUMBER_HEX;
                        continue block22;
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.NUMBER_OCT;
                        continue block22;
                    }
                    rd.unread(c);
                    return new ShExprIntegerToken("0", 10);
                }
                case NUMBER: {
                    int c = rd.read();
                    if (c < 0) {
                        return new ShExprIntegerToken(b1.toString(), 10);
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block22;
                    }
                    rd.unread(c);
                    return new ShExprIntegerToken(b1.toString(), 10);
                }
                case NUMBER_OCT: {
                    int c = rd.read();
                    if (c < 0) {
                        return new ShExprIntegerToken(b1.toString(), 8);
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block22;
                    }
                    rd.unread(c);
                    return new ShExprIntegerToken(b1.toString(), 8);
                }
                case NUMBER_HEX: {
                    int c = rd.read();
                    if (c < 0) {
                        return new ShExprIntegerToken(b1.toString(), 16);
                    }
                    if (c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70) {
                        b1.append((char)c);
                        continue block22;
                    }
                    rd.unread(c);
                    return new ShExprIntegerToken(b1.toString(), 16);
                }
                case SYMBOL: {
                    int c = rd.read();
                    if (c >= 97 && c <= 122 || c >= 65 && c <= 122 || c >= 48 && c <= 57 || c == 95) {
                        b1.appendCodePoint(c);
                        continue block22;
                    }
                    rd.unread(c);
                    return ShExprSymbol.getInstance(b1.toString());
                }
            }
        }
    }

    public static ShExprToken getToken(PushbackReader rd) throws IOException {
        try {
            return ShExprLexer._getToken(rd);
        }
        catch (EndException e) {
            return ShExprToken.ENDMARKER;
        }
    }

    private static class EndException
    extends RuntimeException {
        private EndException() {
        }
    }

    private static enum St1 {
        INIT,
        LT,
        GT,
        EQ,
        EX,
        AND,
        OR,
        PLUS,
        MINUS,
        ASTERISK,
        SLASH,
        CARET,
        PERCENT,
        SHIFTL,
        SHIFTR,
        ZERO,
        NUMBER,
        NUMBER_OCT,
        NUMBER_HEX,
        SYMBOL;

    }
}

