/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.morilib.awk.nano.AwkExitException;
import net.morilib.awk.nano.AwkNextException;
import net.morilib.awk.nano.builtin.AwkBuiltInLoader;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.io.RecordReader;
import net.morilib.awk.nano.misc.FilesReader;
import net.morilib.awk.nano.misc.RecordInputStream;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.namespace.AwkRootNamespace;
import net.morilib.awk.nano.parser.AwkLexer;
import net.morilib.awk.nano.parser.AwkParser;
import net.morilib.awk.nano.statement.AwkProgram;
import net.morilib.awk.nano.value.AwkArray;
import net.morilib.awk.nano.value.AwkInteger;
import net.morilib.awk.nano.value.AwkString;
import net.morilib.awk.nano.value.AwkValue;
import net.morilib.c.pre.CPreprocessorReader;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileGetter;
import net.morilib.sh.ShFileSystem;

public final class Awk {
    private static final Awk _INS = new Awk();
    public static final String VERSION = "0.2.3";

    private Awk() {
    }

    public static Awk getInstance() {
        return _INS;
    }

    public static AwkNamespace newNamespace(String filename, String ... args) {
        AwkRootNamespace r = new AwkRootNamespace();
        AwkBuiltInLoader.load(r);
        r.assign("FILENAME", AwkString.valueOf(filename));
        r.assign("ARGC", AwkInteger.valueOf(args.length));
        r.assign("ARGV", new AwkArray(0, args));
        AwkArray a = new AwkArray();
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            ((AwkValue)a).putArray(e.getKey(), AwkString.valueOf(e.getValue()));
        }
        r.assign("ENVIRON", a);
        a = new AwkArray();
        for (Object o : System.getProperties().keySet()) {
            String s = o.toString();
            ((AwkValue)a).putArray(s, AwkString.valueOf(System.getProperty(s)));
        }
        r.assign("PROPERTIES", a);
        return r;
    }

    public AwkProgram compile(AwkNamespace namespace, Reader source) throws IOException {
        AwkLexer l = new AwkLexer(source);
        AwkProgram p = AwkParser.parse(namespace, l);
        return p;
    }

    public AwkValue execute(AwkNamespace namespace, AwkFiles f, AwkProgram program, String filename, InputStream stdin, Writer stdout, Writer stderr, Charset inputEncoding, String ... args) throws IOException {
        RecordInputStream rd = new RecordInputStream(stdin, inputEncoding, namespace);
        try {
            if (!program.isExecuteOnce()) {
                String s;
                while ((s = rd.readRecord()) != null) {
                    try {
                        program.execute(namespace, f, s);
                    }
                    catch (AwkNextException awkNextException) {
                        stdout.flush();
                        stderr.flush();
                        continue;
                    }
                    catch (AwkExitException e) {
                        try {
                            program.executeEnd(namespace, f);
                            AwkValue awkValue = e.getValue();
                            if (f != null) {
                                f.closeAll();
                            }
                            return awkValue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            stdout.flush();
                            stderr.flush();
                        }
                    }
                    stdout.flush();
                    stderr.flush();
                }
            }
            AwkInteger awkInteger = AwkInteger.ZERO;
            return awkInteger;
        }
        finally {
            if (f != null) {
                f.closeAll();
            }
        }
    }

    public AwkValue execute(AwkNamespace namespace, AwkFiles f, AwkProgram program, String ... args) throws IOException {
        String rs = namespace != null ? namespace.getRS() : "\n";
        RecordReader rd = f.getStdin();
        try {
            if (!program.isExecuteOnce()) {
                String s;
                while ((s = rd.readRecord(rs)) != null) {
                    try {
                        program.execute(namespace, f, s);
                    }
                    catch (AwkNextException awkNextException) {
                        f.getStdout().flush();
                        f.getStderr().flush();
                        continue;
                    }
                    catch (AwkExitException e) {
                        try {
                            program.executeEnd(namespace, f);
                            AwkValue awkValue = e.getValue();
                            if (f != null) {
                                f.closeAll();
                            }
                            return awkValue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            f.getStdout().flush();
                            f.getStderr().flush();
                        }
                    }
                    f.getStdout().flush();
                    f.getStderr().flush();
                }
            }
            AwkInteger awkInteger = AwkInteger.ZERO;
            return awkInteger;
        }
        finally {
            if (f != null) {
                f.closeAll();
            }
        }
    }

    private ShFile searchAwkPath(ShFileGetter g, ShFileSystem fs, String s) {
        if (g.get(fs, s).isFile()) {
            return g.get(fs, s);
        }
        return null;
    }

    private static void initvar(AwkNamespace r, Map<Object, Object> vars) {
        if (vars != null) {
            for (Map.Entry<Object, Object> o : vars.entrySet()) {
                String s = o.getValue().toString();
                s = AwkLexer.escape(s);
                r.assign(o.getKey().toString(), AwkString.valueOf(s));
            }
        }
    }

    public int invoke(ShFileSystem filesystem, ShFileGetter get, InputStream stdin, Writer stdout, Writer stderr, String ... args) throws IOException {
        String s;
        AwkFiles fs = new AwkFiles(stdin, stdout, stderr);
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<Object> f = new ArrayList<Object>();
        String pfn = "<command line>";
        InputStream ins = null;
        boolean pre = false;
        AwkValue z = null;
        Reader r = null;
        int i = 1;
        HashMap<Object, Object> v = new HashMap<Object, Object>();
        while (i < args.length) {
            s = args[i];
            if (s.equals("--with-cpp")) {
                pre = true;
            } else if (s.equals("-f") && i + 1 < args.length) {
                ShFile d;
                if ((d = this.searchAwkPath(get, filesystem, s = (pfn = args[++i]))) == null) {
                    throw new RuntimeException();
                }
                f.add(d);
            } else if (s.equals("-F") && i + 1 < args.length) {
                v.put("FS", args[++i]);
            } else if (s.startsWith("-F")) {
                v.put("FS", s.substring(2));
            } else if (s.equals("-v") && i + 1 < args.length) {
                int k;
                if ((k = (s = args[++i]).indexOf(61)) >= 0) {
                    v.put(s.substring(0, k), s.substring(k + 1));
                }
            } else if (s.equals("--source") && i + 1 < args.length) {
                s = args[++i];
                f.add(s);
            } else {
                if (r != null) break;
                r = new StringReader(s);
            }
            ++i;
        }
        if (f.size() > 0) {
            r = FilesReader.newFiles(f);
        }
        if (pre) {
            r = new CPreprocessorReader(pfn, r);
        }
        if (args.length == 0) {
            throw new IllegalArgumentException();
        }
        a.add(args[0]);
        while (i < args.length) {
            a.add(args[i]);
            ++i;
        }
        String[] a2 = a.toArray(new String[0]);
        AwkNamespace ns = Awk.newNamespace("<stdin>", a2);
        Awk.initvar(ns, v);
        if (r == null) {
            throw new RuntimeException();
        }
        AwkProgram p = this.compile(ns, r);
        p.executeBegin(ns, fs);
        stdout.flush();
        stderr.flush();
        if (p.isExecuteOnce()) {
            return 0;
        }
        int j = 1;
        while (j < a.size()) {
            s = (String)a.get(j);
            int x = s.indexOf(61);
            if (x > 0) {
                ns.assign(s.substring(0, x), AwkString.valueOf(s.substring(x + 1)));
            } else {
                try {
                    ns.assign("FILENAME", AwkString.valueOf(s));
                    ns.assign("ARGIND", AwkInteger.valueOf(j));
                    Charset ch = Charset.defaultCharset();
                    ins = get.get(filesystem, s).getInputStream();
                    z = this.execute(ns, fs, p, s, ins, stdout, stderr, ch, a2);
                }
                finally {
                    if (ins != null) {
                        ins.close();
                    }
                    ins = null;
                }
            }
            ++j;
        }
        if (z == null) {
            z = this.execute(ns, fs, p, "<stdin>", stdin, stdout, stderr, Charset.defaultCharset(), a2);
        }
        p.executeEnd(ns, fs);
        stdout.flush();
        stderr.flush();
        return z.toInteger().intValue();
    }
}

