/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.dfa.ConvertedDFA;
import net.morilib.automata.dfa.ConvertedRangeDFA;
import net.morilib.automata.dfa.MinimizedRangeDFA;
import net.morilib.nina.DFABuilder;
import net.morilib.nina.NFABuilder;
import net.morilib.nina.Nina;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaNFA;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaSubautomata;
import net.morilib.nina.Quadro;
import net.morilib.nina.TMBuilder;
import net.morilib.nina.cmd.NinaInfo;
import net.morilib.nina.cmd.NinatOptions;
import net.morilib.nina.metalang.NinaMetaLanguage;
import net.morilib.nina.translate.LRTranslator;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.sh.ShNinatBuiltInCommands;
import net.morilib.nina.translate.sh.ShNinatFileSystem;
import net.morilib.sh.DefaultShRuntime;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFacade;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShRootEnvironment;
import net.morilib.sh.ShRootShellEnvironment;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.misc.XtraceStream;

public abstract class AbstractNinaTranslator
implements NinaTranslator {
    private static final SimpleDateFormat YEAR = new SimpleDateFormat("yyyy");
    protected DFA<Object, ?, Void> dfa;
    protected Quadro quadro;
    protected NinaAction builder;
    protected NinaInfo options;
    protected AbstractNinaTranslator parent;
    private int stateNo = 0;
    private Map<DFAState<Object, ?, Void>, Integer> states = new IdentityHashMap();
    private Set<Integer> accepts = new HashSet<Integer>();
    private Stack<DFAState<Object, ?, Void>> trz = new Stack();
    private Map<String, AbstractNinaTranslator> subfas;
    private String fragment;
    private String machine;
    private String mainname;
    private String name;
    NinaMetaLanguage meta;

    public static AbstractNinaTranslator getTranslator(String lang) {
        try {
            String p = AbstractNinaTranslator.class.getPackage().getName();
            Class<?> c = Class.forName(String.valueOf(p) + ".NinaTranslator" + lang);
            return (AbstractNinaTranslator)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    String escapeprint(String s) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                default: {
                    b.append(s.charAt(i));
                }
            }
            ++i;
        }
        return b.toString();
    }

    protected int getStateNo(DFAState<Object, ?, Void> state) {
        if (this.states.containsKey(state)) {
            return this.states.get(state);
        }
        this.states.put(state, this.stateNo);
        if (state.isAccepted()) {
            this.accepts.add(this.stateNo);
        }
        this.trz.push(state);
        return this.stateNo++;
    }

    protected boolean isStackEmpty() {
        return this.trz.isEmpty();
    }

    protected DFAState<Object, ?, Void> popStack() {
        return this.trz.pop();
    }

    protected int acceptsSize() {
        return this.accepts.size();
    }

    protected Iterable<Integer> acceptsIterable() {
        return this.accepts;
    }

    protected boolean containsState(Object state) {
        return this.states.containsKey(state);
    }

    protected Integer stateNo(Object state) {
        return this.states.get(state);
    }

    protected Set<DFAState<Object, ?, Void>> stateKeys() {
        return this.states.keySet();
    }

    protected int stateSize() {
        return this.states.size();
    }

    protected NinaInfo getOptions() {
        return this.options;
    }

    protected String getMachine() {
        return this.machine;
    }

    protected String getName() {
        return this.name;
    }

    protected Object getAutomaton(String s) {
        return this.subfas.get(s);
    }

    protected Map<String, ?> getAutomata() {
        return this.subfas;
    }

    public abstract void printStates(PrintStream var1);

    public abstract void printObjectStates(PrintStream var1);

    public abstract void printClassStates(PrintStream var1);

    public abstract void printAcceptStates(PrintStream var1);

    public abstract void printAcceptToken(PrintStream var1);

    public abstract void printActions(PrintStream var1);

    public abstract void printImports(List<String> var1, PrintStream var2);

    public abstract void printIsEnd(PrintStream var1);

    protected abstract InputStream openScript() throws IOException;

    protected abstract PrintStream openOutput() throws IOException;

    protected abstract AbstractNinaTranslator newPrototype();

    protected abstract void printRecover(PrintStream var1);

    protected abstract void printDeadState(String var1, PrintStream var2);

    protected abstract void printAttrs(PrintStream var1);

    protected abstract void printFinallyState(PrintStream var1);

    protected abstract void printInitTrap(PrintStream var1);

    protected abstract void printNFADeadState(PrintStream var1);

    protected abstract void printConstants(PrintStream var1);

    protected abstract void appendValue(StringBuffer var1, StringBuffer var2);

    protected abstract void appendLvalue(StringBuffer var1, StringBuffer var2);

    protected abstract void appendMyPosition(StringBuffer var1, String var2, int var3);

    protected abstract void appendReturn(StringBuffer var1);

    protected abstract void appendYield(StringBuffer var1, String var2);

    protected abstract String getConstName(String var1);

    protected abstract LRTranslator getLRTranslator(Quadro var1);

    protected abstract void setLocalenv(Quadro var1, ShEnvironment var2);

    private void printStateSize(String n, PrintStream out) {
        out.printf("\t\t\treturn %d;\n", this.stateSize());
    }

    public AbstractNinaTranslator prototype(String name, Object o, String s) {
        AbstractNinaTranslator x = this.newPrototype();
        x.parent = this.parent;
        x.fragment = this.fragment;
        x.machine = this.machine;
        x.options = this.options;
        x.subfas = this.subfas;
        x.name = name;
        x.meta = this.meta;
        if (o instanceof DFABuilder) {
            x.builder = (DFABuilder)o;
            x.dfa = (DFA)x.builder.getMachine();
        } else if (o instanceof NFABuilder) {
            x.builder = (NFABuilder)o;
            x.dfa = s == null || s.equals("int") ? ConvertedRangeDFA.convertDFA((NinaNFA)x.builder.getMachine()) : (this.quadro.getType() == null ? ConvertedRangeDFA.convertDFA((NinaNFA)x.builder.getMachine()) : ConvertedDFA.convertDFA((NinaNFA)x.builder.getMachine()));
            x.dfa = MinimizedRangeDFA.newInstance(x.dfa);
        }
        return x;
    }

    String executeMeta(String s) {
        if (this.meta == null) {
            return s;
        }
        return this.meta.execute(s).toString();
    }

    private AbstractNinaTranslator getsubfa(String[] args) {
        if (args.length > 1) {
            return this.subfas.get(args[1]);
        }
        return this;
    }

    private void process(String p, Quadro q, ShNinatBuiltInCommands cmd, ShEnvironment env, PrintStream ot) throws IOException {
        PrintStream ous = null;
        InputStream ins = null;
        try {
            try {
                ins = this.openScript();
                ous = ot != null ? ot : this.openOutput();
                ShNinatFileSystem fs = new ShNinatFileSystem(this.fragment, q, this.options);
                DefaultShRuntime run = new DefaultShRuntime(cmd);
                XtraceStream qs = new XtraceStream(System.out);
                ShFacade.execute(env, (ShFileSystem)fs, (ShBuiltInCommands)cmd, (ShRuntime)run, ins, System.in, ous, System.err, qs);
                this.options.postprocess();
            }
            catch (ShSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (ous != null) {
                ous.close();
            }
        }
    }

    private ShEnvironment getenv(String p, Quadro q, NinaSubautomata sub) {
        ShRootEnvironment env = new ShRootEnvironment();
        env.bind("IFS", " \t");
        env.bind("CLASSNAME", this.options.getClassName());
        env.bind("PACKAGE", p);
        env.bind("FILENAME", this.options.getFilename());
        env.bind("OUTPUT_FILENAME", this.options.getOutputFilename());
        env.bind("BUFSIZE", this.options.getBufSize());
        env.bind("TEMPLATE", q.getOption("template"));
        env.bind("EXTENDS", q.getOption("extends"));
        env.bind("IMPLEMENTS", q.getOption("implements"));
        env.bind("ABSTRACT", q.isOptionDefined("abstract") ? "abstract" : "");
        env.bind("TOKENERROR", q.isOptionDefined("tokenerror") ? q.getOption("tokenerror") : "TokenException");
        env.bind("ITERATOR", q.getOptionBoolean("iterator") ? "true" : "");
        env.bind("MAINNAME", this.mainname);
        env.bind("DEFAULTAT", q.getOption("default"));
        env.bind("ENABLE_LOOKAHEAD", q.getOption("enableLookahead"));
        env.bind("ENABLE_BACKTRACK", q.getOption("enableBacktrack"));
        env.bind("ENABLE_MATCHER", q.getOption("enableMatcher"));
        env.bind("ENABLE_LOG", q.getOption("enableLog"));
        env.bind("API_ACCESS_MODIFIER", q.getOption("APIAccessModifier"));
        env.bind("READER", q.getOption("reader"));
        env.bind("OWNER", q.getOptionNvl("owner", ""));
        env.bind("YEAR", q.getOptionNvl("year", YEAR.format(new Date())));
        env.bind("ORGANIZATION", q.getOptionNvl("organization", q.getOptionNvl("owner", "")));
        env.bind("NEWLINEMODE", "binary".equals(q.getOption("streammode")) ? "on" : "");
        env.bind("READSLOW", q.getOptionBoolean("readSlow") ? "true" : "");
        env.bind("READSLEEP", String.valueOf(q.getOptionInt("readSleep", -1)));
        env.bind("EXEC_LOOKAHEAD", q.getLanguageOption().getLookahead());
        env.bind("EXEC_LOOKAHEAD_COMMIT", q.getLanguageOption().getLookaheadCommit());
        env.bind("TAPETYPE", q.getOption("tapetype"));
        String s = q.getLicense();
        if (s.trim().length() > 0) {
            env.bind("LICENSE", "userlicense");
        } else {
            s = q.getOptionNvl("license", "default").toLowerCase();
            env.bind("LICENSE", "/license/" + s);
        }
        s = q.getType();
        if (s == null || s.equals("char")) {
            env.bind("TYPE", "");
            env.bind("CTYPE", "int");
        } else if (s.equals("string")) {
            env.bind("TYPE", s);
            env.bind("CTYPE", "String");
        } else if (s.equals("class")) {
            env.bind("TYPE", s);
            env.bind("CTYPE", "Object");
        } else {
            env.bind("TYPE", s);
            env.bind("CTYPE", s);
        }
        s = q.getLexerType();
        if (s != null) {
            env.bind("LEXER", q.getLexer());
            if (s.equals("char")) {
                env.bind("LTYPE", "");
                env.bind("LCTYPE", "int");
            } else if (s.equals("string")) {
                env.bind("LTYPE", s);
                env.bind("LCTYPE", "String");
            } else if (s.equals("class")) {
                env.bind("LTYPE", s);
                env.bind("LCTYPE", "Object");
            } else {
                env.bind("LTYPE", s);
                env.bind("LCTYPE", s);
            }
        }
        StringBuffer b = new StringBuffer();
        String d = "";
        for (Map.Entry<String, Object> entry : sub.entrySet()) {
            if (!(entry.getValue() instanceof DFABuilder)) continue;
            b.append(d).append(entry.getKey());
            d = " ";
        }
        env.bind("SUBAUTOMATA", b.toString());
        b = new StringBuffer();
        d = "";
        for (String string : q.getLRObjects().keySet()) {
            b.append(d).append(string);
            d = " ";
        }
        env.bind("LRPARSERS", b.toString());
        this.setLocalenv(q, env);
        return new ShRootShellEnvironment(env);
    }

    private void setenv(ShEnvironment env, NinaAction builder) {
        StringBuffer b = new StringBuffer();
        String d = "";
        for (String x : builder.getDynamicTransitMap().keySet()) {
            b.append(d).append(x);
            d = " ";
        }
        env.bind("DYNAMICAUTOMATA", b.toString());
        if (b.length() > 0) {
            env.bind("ENABLE_LOOKAHEAD", "true");
        }
    }

    protected void translateQuadro(String name, Object o, NinaInfo opts, Map<String, String> prms, final NinaSubautomata sub, PrintStream ot) throws IOException {
        String q;
        this.mainname = name;
        this.subfas = new HashMap<String, AbstractNinaTranslator>();
        this.options = opts;
        String m = this.quadro.getOption("machine");
        if (m != null) {
            m = "unknown";
        }
        this.fragment = this.quadro.getFragment();
        String p = this.quadro.getRootPackage();
        if (p == null || p.equals("")) {
            p = "";
        }
        if ((q = this.quadro.getOption("metaLanguage")) != null && !q.equals("")) {
            this.meta = new NinaMetaLanguage(q);
        }
        if ((q = this.quadro.getFragmentByName("meta")) != null && !q.equals("") && this.meta != null) {
            this.meta.execute(q);
        }
        ShEnvironment env = this.getenv(p, this.quadro, sub);
        ShNinatBuiltInCommands cmd = new ShNinatBuiltInCommands();
        cmd.putCommand("print_states", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator t;
                String s;
                if (args.length > 1) {
                    s = args.length > 2 ? args[2] : null;
                    t = AbstractNinaTranslator.this.prototype(args[1], sub.get(args[1]), s);
                    AbstractNinaTranslator.this.subfas.put(args[1], t);
                } else {
                    t = AbstractNinaTranslator.this;
                }
                String string = s = args.length > 2 ? args[2] : AbstractNinaTranslator.this.quadro.getType();
                if (s == null || s.equals("") || s.equals("char") || s.equals("int")) {
                    t.printStates(stdout);
                } else if (s.equals("class")) {
                    t.printClassStates(stdout);
                } else {
                    t.printObjectStates(stdout);
                }
                return 0;
            }
        });
        cmd.putCommand("print_accepts", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printAcceptStates(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_imports", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printImports(AbstractNinaTranslator.this.quadro.getImports(), stdout);
                return 0;
            }
        });
        cmd.putCommand("print_isend", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printIsEnd(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_actions", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printActions(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_recover", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printRecover(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_deadstate", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printDeadState(args[1], stdout);
                return 0;
            }
        });
        cmd.putCommand("print_statesize", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printStateSize(args[1], stdout);
                return 0;
            }
        });
        cmd.putCommand("print_attrs", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printAttrs(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_finallystate", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printFinallyState(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_inittrap", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.printInitTrap(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_constants", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printConstants(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_token", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printAcceptToken(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_nfadead", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printNFADeadState(stdout);
                return 0;
            }
        });
        if (o instanceof NFABuilder) {
            this.machine = "nfa";
            this.builder = (NFABuilder)o;
            NinaNFA n = (NinaNFA)this.builder.getMachine();
            this.dfa = this.quadro.getType() == null ? ConvertedRangeDFA.convertDFA(n) : ConvertedDFA.convertDFA(n);
            this.dfa = MinimizedRangeDFA.newInstance(this.dfa);
            this.process(p, this.quadro, cmd, env, ot);
        } else if (o instanceof DFABuilder) {
            this.machine = "dfa";
            this.builder = (DFABuilder)o;
            this.setenv(env.getEnvironment(), this.builder);
            this.dfa = (DFA)this.builder.getMachine();
            this.getLRTranslator(this.quadro).setCommands(cmd);
            this.process(p, this.quadro, cmd, env, ot);
        } else if (o instanceof TMBuilder) {
            this.machine = "tm";
            this.builder = (TMBuilder)o;
            this.dfa = (DFA)this.builder.getMachine();
            this.process(p, this.quadro, cmd, env, ot);
        } else {
            opts.perror("machinenotsupport", m);
        }
    }

    @Override
    public void translate(String name, Reader rd, NinaInfo opts, List<String> libs, Map<String, String> prms, PrintStream ot) throws IOException {
        String n = Nina.getFAName(null, name);
        NinaSubautomata s = new NinaSubautomata(n);
        s.put(n, null);
        this.quadro = Quadro.read(n, rd, libs);
        NinaAction o = NinaParser.complie(this.quadro, libs, prms, s, opts.getConsole(), opts);
        this.translateQuadro(n, o, opts, prms, s, ot);
    }

    @Override
    public Object compile(String name, Reader rd, NinatOptions opts, List<String> libs, Map<String, String> prms) throws IOException {
        String n = Nina.getFAName(null, name);
        NinaSubautomata s = new NinaSubautomata(n);
        s.put(n, null);
        Quadro q = Quadro.read(n, rd, libs);
        return NinaParser.complie(q, opts.getLibraryList(), prms, s, opts.getConsole(), opts);
    }
}

