/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed;

import net.morilib.sed.SedLineMatcher;
import net.morilib.sed.SedPatternEngine;
import net.morilib.sed.line.SedLastLineMatcher;
import net.morilib.sed.line.SedNumberLineMatcher;
import net.morilib.sed.line.SedPatternLineMatcher;
import net.morilib.sed.line.SedStepLineMatcher;

public class SedLineOption {
    SedLineMatcher begin;
    SedLineMatcher end;
    SedPatternLineMatcher pattern;
    boolean negate;
    St matchstat = St.NO_MATCH;
    int rellineno = -1;

    SedLineOption() {
        this(null, null, null, false);
    }

    SedLineOption(SedLineMatcher matcher) {
        this(matcher, null, null, false);
    }

    SedLineOption(String pattern, boolean casein, boolean allm) {
        this(null, null, new SedPatternLineMatcher(pattern, casein, allm), false);
    }

    SedLineOption(String pattern, boolean neg) {
        this(null, null, new SedPatternLineMatcher(pattern), neg);
    }

    SedLineOption(String begin, String end) {
        this(new SedPatternLineMatcher(begin), new SedPatternLineMatcher(end), null, false);
    }

    SedLineOption(String begin, String end, boolean neg) {
        this(new SedPatternLineMatcher(begin), new SedPatternLineMatcher(end), null, neg);
    }

    SedLineOption(long begin, String end) {
        this(new SedNumberLineMatcher(begin), new SedPatternLineMatcher(end), null, false);
    }

    SedLineOption(String begin, long end) {
        this(new SedPatternLineMatcher(begin), new SedNumberLineMatcher(end), null, false);
    }

    SedLineOption(long begin, boolean dummy, boolean dummy2) {
        this(new SedNumberLineMatcher(begin), SedLastLineMatcher.INSTANCE, null, false);
    }

    SedLineOption(String begin, boolean dummy, int dummy2) {
        this(new SedPatternLineMatcher(begin), SedLastLineMatcher.INSTANCE, null, false);
    }

    SedLineOption(SedLineMatcher begin, SedLineMatcher end) {
        this(begin, end, null, false);
    }

    SedLineOption(long lineno) {
        this(new SedNumberLineMatcher(lineno), null, null, false);
    }

    SedLineOption(long begin, long end) {
        this(new SedNumberLineMatcher(begin), new SedNumberLineMatcher(end), null, false);
    }

    SedLineOption(long begin, long end, boolean neg) {
        this(new SedNumberLineMatcher(begin), new SedNumberLineMatcher(end), null, neg);
    }

    private SedLineOption(SedLineMatcher b, SedLineMatcher e, SedPatternLineMatcher p, boolean n) {
        this.begin = b;
        this.end = b == null || b.equals(e) ? null : e;
        this.pattern = p;
        this.negate = n;
    }

    public SedLineMatcher getBegin() {
        return this.begin;
    }

    public SedLineMatcher getEnd() {
        return this.end;
    }

    public String getPattern() {
        return this.pattern.getPattern();
    }

    public int options() {
        if (this.begin == null) {
            return 0;
        }
        if (this.end == null) {
            return 1;
        }
        return 2;
    }

    public boolean matches(SedPatternEngine e, String s, long l, boolean lastno) {
        if (this.pattern != null) {
            return this.negate ^ this.pattern.matches(e, s, l, -1L, lastno);
        }
        if (this.begin == null) {
            return true;
        }
        if (this.begin instanceof SedStepLineMatcher) {
            return this.negate ^ this.begin.matches(e, s, l, -1L, lastno);
        }
        if (this.matchstat.equals((Object)St.NO_MATCH)) {
            if (!this.begin.matches(e, s, l, -1L, lastno)) {
                return this.negate;
            }
            if (this.end == null) {
                this.matchstat = St.MATCHED;
                return !this.negate;
            }
            this.matchstat = St.MATCHING;
            this.rellineno = 1;
            return !this.negate;
        }
        if (this.matchstat.equals((Object)St.MATCHING)) {
            if (this.end.matches(e, s, l, this.rellineno++, lastno)) {
                this.matchstat = St.MATCHED;
                return !this.negate;
            }
            return !this.negate;
        }
        return this.negate;
    }

    public boolean hasMatched() {
        return !this.negate && this.matchstat.equals((Object)St.MATCHED);
    }

    public boolean isMatching() {
        return this.negate ^ this.matchstat.equals((Object)St.MATCHING);
    }

    public boolean hasNotMatched() {
        return !this.negate && this.matchstat.equals((Object)St.NO_MATCH);
    }

    public boolean isNegate() {
        return this.negate;
    }

    private static boolean eq(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean isEquivalent(SedLineOption p) {
        return SedLineOption.eq(this.begin, p.begin) && this.negate == p.negate && SedLineOption.eq(this.end, p.end) && SedLineOption.eq(this.pattern, p.pattern);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.pattern != null) {
            b.append("g/").append(this.pattern).append("/");
        } else if (this.begin != null) {
            b.append(this.begin).append(",").append(this.end);
        }
        if (this.negate) {
            b.append('!');
        }
        return b.toString();
    }

    private static enum St {
        NO_MATCH,
        MATCHING,
        MATCHED;

    }
}

