/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;

import net.morilib.sh.misc.XtraceStream;

public final class ShFacade {

	/**
	 * 
	 */
	public static final String NAME = "jsh";

	/**
	 * 
	 * @param env
	 * @param fs
	 * @param cmds
	 * @param run
	 * @param script
	 * @param in
	 * @param out
	 * @param err
	 * @param prompt
	 * @return
	 * @throws ShSyntaxException 
	 * @throws IOException 
	 */
	public static int execute(ShEnvironment env,
			ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run,
			InputStream script, InputStream in,
			PrintStream out, PrintStream err,
			XtraceStream pr) throws ShSyntaxException, IOException {
		PushbackReader f = null;
		ShTree x;
		int z = 0;

		try {
			if(script == null)  return 0;
			x = ShParser.parse(script, env.getCharset());
			z = x.eval(env, fs, cmds, run, in, out, err, pr);
		} finally {
			if(f != null) {
				try {
					f.close();
				} catch (IOException e1) {
					throw new RuntimeException(e1);
				}
			}
		}
		return z;
	}

	/**
	 * 
	 * @param env
	 * @param fs
	 * @param cmds
	 * @param run
	 * @param script
	 * @param in
	 * @param out
	 * @param err
	 * @param pr
	 * @return
	 * @throws ShSyntaxException
	 * @throws IOException
	 */
	public static int execute(ShEnvironment env,
			ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run,
			Reader script, InputStream in,
			PrintStream out, PrintStream err,
			XtraceStream pr) throws ShSyntaxException, IOException {
		PushbackReader f = null;
		ShTree x;
		int z = 0;

		try {
			if(script == null)  return 0;
			x = ShParser.parse(script);
			z = x.eval(env, fs, cmds, run, in, out, err, pr);
		} finally {
			if(f != null) {
				try {
					f.close();
				} catch (IOException e1) {
					throw new RuntimeException(e1);
				}
			}
		}
		return z;
	}

	/**
	 * 
	 * @param env
	 * @param fs
	 * @param cmds
	 * @param run
	 * @param script
	 * @param in
	 * @param out
	 * @param err
	 * @param prompt
	 * @return
	 */
	public static int executeScript(ShEnvironment env,
			ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run,
			InputStream script, InputStream in,
			PrintStream out, PrintStream err,
			XtraceStream prompt
			) throws IOException, ShSyntaxException {
		ShTree x;
		int z = 0;

		if(script == null)  return 0;
		x = ShParser.parse(script, env.getCharset());
		z = x.eval(env, fs, cmds, run, in, out, err, prompt);
		return z;
	}

}
