/*
 * Copyright 2013-2014 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.cmd;

import java.util.ResourceBundle;

import net.morilib.nina.NinaException;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/05/05
 */
public final class NinatMessages {

	private static final String CLSNAME =
			Ninat.class.getPackage().getName().replace('.', '/');
	private static ResourceBundle msgs =
			ResourceBundle.getBundle(CLSNAME + "/ninat_messages");

	/**
	 * 
	 * @param s
	 * @param os
	 * @return
	 */
	public static String getMessage(String s, Object... os) {
		if(msgs.containsKey(s)) {
			return String.format(msgs.getString(s), os);
		} else {
			return NinaException.getMessage(s, os);
		}
	}

}
