/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.misc.XtraceStream;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/05/26
 */
public class ShTreeType implements ShTree {

	private ShToken var;

	/**
	 * @param shToken
	 */
	public ShTreeType(ShToken var) {
		this.var = var;
	}

	public int eval(ShEnvironment env, ShFileSystem fs,
			ShBuiltInCommands cmds, ShRuntime run, InputStream in,
			PrintStream out,
			PrintStream err,
			XtraceStream p) throws IOException, ShSyntaxException {
		String s = ShTrees.substitute(env, run, fs, err, p, var);
		ShFile f;

		if(env.findFunction(s) != null) {
			out.print(s);
			out.println(" is a function");
		} else if(cmds.find(s) != null) {
			out.print(s);
			out.println(" is a shell builtin");
		} else if(s.equals("break") || s.equals("continue") ||
				s.equals("return")  || s.equals(".")        ||
				s.equals("source")  || s.equals("type")     ||
				s.equals("eval")    || s.equals("builtin")  ||
				s.equals("command") || s.equals("sh")) {
			out.print(s);
			out.println(" is a shell builtin");
		} else if((f = fs.searchPath(env, s)) != null) {
			out.print(s);
			out.print(" is ");
			out.println(f.toString());
		} else {
			out.print(s);
			out.println(" not found");
		}
		return 0;
	}

	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt) {
		b.add(this);
	}

}
