/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.printf;

import java.io.IOException;
import java.io.Writer;

/**
 * %sのアクションです。
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2013/05/11
 */
public class PrintfActionS implements PrintfAction {

	public void action(Writer b, int flags, int width,
			int precision, Object arg) throws IOException {
		String s = arg.toString();

		if(width < 0 && precision < 0) {
			b.append(s);
		} else if(width < 0 && precision >= 0) {
			if(precision <= s.length()) {
				b.append(s.substring(0, precision));
			} else {
				Printf.indent(b, s, ' ', flags, precision);
			}
		} else if(width >= 0 && precision < 0) {
			if(width <= s.length()) {
				b.append(s);
			} else {
				Printf.indent(b, s, ' ', flags, width);
			}
		} else if(width <= precision) {
			if(precision <= s.length()) {
				b.append(s.substring(0, precision));
			} else if(width <= s.length()) {
				b.append(s);
			} else {
				Printf.indent(b, s, ' ', flags, width);
			}
		} else {
			if(precision < s.length()) {
				s = s.substring(0, precision);
			}
			Printf.indent(b, s, ' ', flags, width);
		}
	}

}
