/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano.subr;

import net.morilib.lisp.nano.ConsIterator;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispNumber;
import net.morilib.lisp.nano.LispString;
import net.morilib.lisp.nano.LispUtils;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public class Add extends MathOperator1 {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.MathOperator1#calculate(net.morilib.lisp.math.algebra.ILispRing, net.morilib.lisp.math.algebra.ILispRing)
	 */
	@Override
	protected LispNumber calculate(LispNumber o1,
			LispNumber o2) {
		return (LispNumber)o1.add(o2);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.MathOperator1#initValue()
	 */
	@Override
	protected LispNumber initValue() {
		return LispInteger.ZERO;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.MathOperator1#eval(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	public Datum eval(Datum body, Environment env, LispMessage mesg) {
		ConsIterator itr = new ConsIterator(body);
		StringBuilder b;
		Datum s;

		if(itr.hasNext()) {
			if((s = itr.next()) instanceof LispString) {
				b = new StringBuilder(s.getString());
				while(itr.hasNext()) {
					b.append(LispUtils.toDisplay(itr.next()));
				}
				SubrUtils.checkTerminated(itr, body, mesg);
				return new LispString(b.toString());
			}
		}
		return super.eval(body, env, mesg);
	}

}
