/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.parser;

import java.io.IOException;
import java.io.PushbackReader;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedCommandParser;
import net.morilib.sed.SedLineOption;
import net.morilib.sed.SedSyntaxException;
import net.morilib.sed.cmd.SedYCommand;

/**
 * yコマンドをパースするパーサです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class SedYParser implements SedCommandParser {

	public SedCommand parse(SedCommandBundle b,
			PushbackReader rd, SedLineOption l) throws IOException {
		String pt, rp;
		int d;

		if((d = rd.read()) < 0)  throw new SedSyntaxException();
		pt = parseStr(rd, d);
		rp = parseStr(rd, d);
		return new SedYCommand(pt, rp);
	}

	String parseStr(PushbackReader rd, int d) throws IOException {
		StringBuffer pt = new StringBuffer();
		int c;

		while((c = rd.read()) != d) {
			if(c < 0) {
				throw new SedSyntaxException();
			} else {
				pt.appendCodePoint(c);
			}
		}
		return pt.toString();
	}

}
