/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import net.morilib.nina.lint.LintCells;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/01/11
 */
public class NinaCompoundException extends NinaException {

	//
	private Collection<NinaException> list;
	private LintCells cells;

	/**
	 * @param msgcode
	 * @param os
	 */
	public NinaCompoundException(Collection<NinaException> l,
			LintCells cells) {
		super("compoundexception");
		this.cells = cells;
		list = new ArrayList<NinaException>(l);
	}

	/**
	 * 
	 * @return
	 */
	public LintCells getCells() {
		return cells;
	}

	/**
	 * 
	 * @return
	 */
	public Collection<NinaException> getExceptions() {
		return Collections.unmodifiableCollection(list);
	}

}
