/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

import net.morilib.c.pre.CPreprocessorReader;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/17
 */
public final class JsCpp implements ShProcess {

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShProcess#main(net.morilib.sh.ShEnvironment, net.morilib.sh.ShFileSystem, java.io.InputStream, java.io.PrintStream, java.io.PrintStream, java.lang.String[])
	 */
	@Override
	public int main(ShEnvironment env, ShFileSystem fs,
			InputStream stdin, PrintStream stdout, PrintStream stderr,
			String... args) throws IOException {
		CPreprocessorReader rd = null;
		String s;

		try {
			rd = new CPreprocessorReader("<stdin>",
					new InputStreamReader(stdin));
			rd.define("UNGET",             "$this._f_UNGET");
			rd.define("LOOKAHEAD",         "$this._f_LOOKAHEAD");
			rd.define("LOOKAHEAD_COMMIT",  "$this._f_LOOKAHEAD_COMMIT");
			rd.define("LOOKAHEAD_RB",      "$this._f_LOOKAHEAD_RB");
			rd.define("LOOKAHEAD_MARK",    "$this._f_LOOKAHEAD_MARK");
			rd.define("SET_BACKTRACK",     "$this._f_SET_BACKTRACK");
			rd.define("BACKTRACK_COMMIT",  "$this._f_BACKTRACK_COMMIT");
			rd.define("BACKTRACK",         "$this._f_BACKTRACK");
			rd.define("GETCC",             "$this._f_GETCC");
			rd.define("SETCC",             "$this._f_SETCC");
			rd.define("STATE",             "$this.__state");
			rd.define("NINA_ACCEPT",       "-1");
			rd.define("NINA_FAIL",         "-9");
			rd.define("NINA_HALT_ACCEPT",  "-91");
			rd.define("NINA_HALT_REJECT",  "-72");
			rd.define("NINA_YIELD",        "-85");
			rd.define("NINA_BEGIN",        "-2");
			rd.define("NINA_STACKLEN",     "72");
			rd.define("INITIAL",           "0");
			rd.define("INDENT",            "1");
			rd.define("ACCEPTSTATE",       "0x40000001");
			rd.define("NINA_DISCARDSTATE", "0x40000000");
			rd.define("CONSOLE",           "java.lang.System['out']");
			rd.define("LRSTATEMASK",       "0x3fff0000");
			rd.define("LRSTATESHIFT",      "16");
			rd.define("FASTATEMASK",       "0x0000ffff");
			rd.define("INVALIDTOKEN",      "[undefined]");
			while((s = rd.readLine()) != null) {
				stdout.println(s);
			}
			return 0;
		} finally {
			if(rd != null)  rd.close();
		}
	}

}
