# -*- coding: UTF-8 -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#  Copyright (C) 2002-2005 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2003 by Shun-ichi TAHARA <jado@flowernet.gr.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: sakura.py,v 1.150 2006/08/26 16:01:18 shy Exp $
#

import os
import re
import socket
import select
import sys
import time
import random

if 'DISPLAY' in os.environ:
    import gtk ## FIXME

import ninix.main
import ninix.script
import ninix.version

# left mouse button
BUTTON1_CLOSE = 'close'
BUTTON1_RAISE = 'raise'
BUTTON1_LOWER = 'lower'

# right mouse button
BUTTON3_CLOSE = 'close'
BUTTON3_RAISE = 'raise'
BUTTON3_LOWER = 'lower'

# default browser
DEFAULT_BROWSER = "netscape -remote 'openURL(%s,new-window)'"

range_script_speed = [(_('None'), -1),
                      (''.join(('1 (', _('Fast'), ')')), 0),
                      ('2', 1),
                      ('3', 2),
                      ('4', 3),
                      ('5', 4),
                      ('6', 6),
                      (''.join(('7 (', _('Slow'), ')')), 8)]


class Sakura:

    BALLOON_LIFE   = 10  # sec (0: never closed automatically)
    SELECT_TIMEOUT = 15  # sec
    PAUSE_TIMEOUT  = 30  # sec
    SILENT_TIME    = 15  # sec
    # script modes
    BROWSE_MODE = 1
    SELECT_MODE = 2
    PAUSE_MODE  = 3
    # script origins
    FROM_SSTP_CLIENT = 1
    FROM_GHOST       = 2
    # HTML entity definitions
    try:
        from htmlentitydefs import name2codepoint
    except:
        name2codepoint = None

    def __init__(self, debug):
        self.debug = debug
        self.sstp_handle = None
        self.sstp_entry_db = None
        self.sstp_request_handler = None
        if self.debug & 16384: ## FIXME
            self.script_parser = ninix.script.Parser(error='strict')
        else:
            self.script_parser = ninix.script.Parser(error='loose')
        self.script_queue = []
        self.script_mode = self.BROWSE_MODE
        self.script_post_proc = []
        self.__balloon_life = 0
        self.__surface_life = 0
        self.__boot = [0, 0]
        self.surface_mouse_motion = None ## FIXME
        self.time_critical_session = 0
        self.user_interaction = 0
        self.lock_repaint = 0
        self.passivemode = 0
        self.running = 0
        self.event_queue = []
        self.anchor = None
        self.clock = (0, 0)
        self.script_speed = 3
        self.cantalk = 1
        self.synchronized_session = []
        self.__sink_after_talk = 0
        self.__raise_before_talk = 0
        ##
        self.set_event_kill_list([]) ## FIXME
        self.set_mouse_button1(BUTTON1_RAISE) ## FIXME
        self.set_mouse_button3(BUTTON3_CLOSE) ## FIXME
        self.set_browser(DEFAULT_BROWSER) ## FIXME
        self.set_helpers([]) ## FIXME
        self.keep_silence(0)
        self.old_otherghostname = None ## FIXME

    def set_ghost(self, ghost):
        self.ghost = ghost

    def set_surface(self, surface): ## FIXME: ghost
        self.surface = surface

    def set_balloon(self, balloon): ## FIXME: ghost
        self.balloon = balloon

    def is_URL(self, s):
        return s.startswith('http://') or \
               s.startswith('ftp://') or \
               s.startswith('file:/')

    def is_anchor(self, link_id):
        if len(link_id) == 2 and link_id[0] == 'anchor':
            return 1
        else:
            return 0

    def launch_browser(self, url): ## FIXME
        command = self.get_browser()
        self.execute_command(command, url)

    def execute_command(self, command, arg): ## FIXME
        if '%s' not in command:
            sys.stderr.write('cannot execute command (%s missing)\n')
            return
        os.system(' '.join((command.replace('%s', arg, 1), '&')))

    ###   CALLBACK   ###
    def reset_idle_time(self):
        self.idle_start = time.time()

    def notify_link_selection(self, link_id, text, number): ## FIXME
        if self.script_origin == self.FROM_SSTP_CLIENT and \
           self.sstp_request_handler is not None:
            self.sstp_request_handler.send_answer(text)
            self.sstp_request_handler = None
        if self.is_anchor(link_id):
            self.notify_event('OnAnchorSelect', link_id[1])
        elif self.is_URL(link_id):
            self.launch_browser(link_id)
            self.reset_script(1)
            self.stand_by(0)
        elif self.sstp_entry_db:
            # leave the previous sstp message as it is
            self.start_script(self.sstp_entry_db.get(link_id, r'\e'))
            self.sstp_entry_db = None
        elif not self.notify_event('OnChoiceSelect', link_id, text, number):
            self.reset_script(1)
            self.stand_by(0)

    def busy(self): ## FIXME: ghost
        return self.time_critical_session or \
               self.user_interaction or \
               self.ghost.updateman.is_active() or \
               self.event_queue or \
               self.passivemode

    def notify_surface_mouse_motion(self, side, x, y): ## FIXME: ghost
        if self.surface_mouse_motion is not None:
            return
        part = self.surface.get_touched_region(side, x, y)
        if part:
            self.surface_mouse_motion = (side, x, y, part)
        else:
            self.surface_mouse_motion = None

    def notify_balloon_click(self, button, click, side): ## FIXME: ghost
        if self.script_mode == self.PAUSE_MODE:
            self.script_mode = self.BROWSE_MODE
            self.balloon.redraw_arrow(self.script_side, 1)
        elif button == 1 and self.mouse_button1 == BUTTON1_RAISE or \
             button == 3 and self.mouse_button3 == BUTTON3_RAISE:
            self.ghost.raise_all()
        elif button == 1 and self.mouse_button1 == BUTTON1_LOWER or \
             button == 3 and self.mouse_button3 == BUTTON3_LOWER:
            self.ghost.lower_all()
        if self.vanished:
            return
        if self.ghost.updateman.is_active():
            if button == 1 and click == 2:
                self.ghost.updateman.interrupt()
            return
        if self.time_critical_session:
            self.time_critical_session = not self.time_critical_session
            return
        elif self.passivemode:
            return
        elif button == 1 and click == 2:
            if self.sstp_request_handler:
                self.sstp_request_handler.send_sstp_break()
                self.sstp_request_handler = None
            self.notify_event('OnMouseDoubleClick', '', '', '', side, '')
        elif button == 1 and self.mouse_button1 == BUTTON1_CLOSE or \
             button == 3 and self.mouse_button3 == BUTTON3_CLOSE:
            if self.sstp_request_handler:
                self.sstp_request_handler.send_sstp_break()
                self.sstp_request_handler = None
            self.reset_script(1)
            self.stand_by(0)

    def notify_file_drop(self, list, side): ## FIXME: ghost
        self.enqueue_event('OnFileDrop2', chr(1).join(list), side)

    def notify_user_communicate(self, data): ## FIXME: ghost
        if data is not None:
            self.notify_event('OnCommunicate', 'user', data)

    def notify_user_teach(self, data): ## FIXME: ghost
        if data is not None:
            script = self.ghost.teach(data)
            if script:
                self.start_script(script)
                self.balloon.hide_sstp_message()
        self.user_interaction = 0

    def notify_user_input(self, symbol, data): ## FIXME: ghost
        if data is None:
            data = ''
        ## CHECK: symbol
        if symbol == 'OnUserInput' and self.notify_event('OnUserInput', data):
            pass
        elif self.notify_event('OnUserInput', symbol, data):
            pass
        elif self.notify_event(symbol, data):
            pass
        self.user_interaction = 0

    month_names = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                   'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
    boot_event = ['OnBoot', 'OnFirstBoot', 'OnGhostChanged', 'OnShellChanged']

    def notify_event(self, event, *arglist, **argdict): ## FIXME: ghost&sakura
        #if self.time_critical_session:
        #    return 0
        if event in self.event_kill_list:
            return 0
        for key in argdict:
            assert key in ['event_type', 'default'] # trap typo, etc.
        event_type = argdict.get('event_type', 'GET')
        default = argdict.get('default', None)
        argdict = {'event_type': event_type} ## FIXME
        script, communication = self.ghost.get_event_response_with_communication(event, *arglist, **argdict) or (default, None)
        if self.debug & 1 and script or \
           self.debug & 2 and not script and event != 'OnSecondChange':
            t = time.localtime(time.time())
            m = self.month_names[t[1] - 1]
            print '\n[%02d/%s/%d:%02d:%02d:%02d %+05d]' % (
                t[2], m, t[0], t[3], t[4], t[5], - time.timezone / 36)
            print 'Event:', event
            for n in range(len(arglist)):
                value = arglist[n]
                if value is not None:
                    print 'Reference%d:' % n, '%s' % \
                          str(value).encode('utf-8', 'ignore')
        if not script: # an empty script is ignored
            if event in self.boot_event:
                self.surface_bootup()
            if event == 'OnMouseClick' and arglist[5] == 3:
                self.surface.open_popup_menu(arglist[5], arglist[3])
            return 0
        if self.debug & 1:
            print '=> "%s"' % script.encode('utf-8', 'ignore')
        if self.passivemode and \
           (event == 'OnSecondChange' or event == 'OnMinuteChange'):
            return 0
        self.start_script(script)
        self.balloon.hide_sstp_message()
        if event in self.boot_event:
            self.script_post_proc.append(self.surface_bootup)
        if communication is not None:
            self.script_post_proc.append(communication)
        return 1

    def surface_bootup(self):
        for side in [0, 1]:
            if not self.__boot[side]:
                self.ghost.set_surface_default(side)
                self.ghost.show_surface(side)

    def enqueue_script(self, script, sender, handle,
                       host, show_sstp_marker, use_translator,
                       db=None, request_handler=None):
        if not self.script_queue and \
           not self.time_critical_session and not self.passivemode:
            if self.sstp_request_handler:
                self.sstp_request_handler.send_sstp_break()
                self.sstp_request_handler = None
            self.reset_script(1)
        self.script_queue.append((script, sender, handle, host,
                                  show_sstp_marker, use_translator,
                                  db, request_handler))

    def enqueue_event(self, event, *arglist, **argdict): ## FIXME: ghost
        for key in argdict:
            assert key in ['proc'] # trap typo, etc.
        self.event_queue.append((event, arglist, argdict))

    EVENT_SCRIPTS = {
        'OnUpdateBegin': \
        ''.join((r'\t\h\s[0]',
                 unicode(_('Network Update has begun.'), 'utf-8'),
                 r'\e')),
        'OnUpdateComplete': \
        ''.join((r'\t\h\s[5]',
                 unicode(_('Network Update completed successfully.'), 'utf-8'),
                 r'\e')),
        'OnUpdateFailure': \
        ''.join((r'\t\h\s[4]',
                 unicode(_('Network Update failed.'), 'utf-8'),
                 r'\e')),
        }

    def handle_event(self): ## FIXME: ghost
        while self.event_queue:
            event, arglist, argdict = self.event_queue.pop(0)
            proc = argdict.get('proc', None)
            argdict = {'default': self.EVENT_SCRIPTS.get(event)}
            if self.notify_event(event, *arglist, **argdict):
                if proc is not None:
                    self.script_post_proc.append(proc)
                return 1
            elif proc is not None:
                proc()
                return 1
        return 0

    def set_cantalk(self, flag): ## FIXME: ghost
        if flag:
            self.cantalk = 1
        else:
            self.cantalk = 0
        self.ghost.app.select_current_sakura() ## FIXME

    def set_script_speed(self, speed):
        if self.script_speed == speed:
            return
        self.script_speed = speed  # ordinal (-1: no wait)

    def get_script_speed(self):
        return self.script_speed

    def set_event_kill_list(self, list): ## FIXME: ghost
        ##print 'Sakura.set_event_kill_list:', list
        self.event_kill_list = list

    def get_event_kill_list(self):  ## FIXME: ghost
        return self.event_kill_list

    def set_mouse_button1(self, name): ## FIXME: ghost
        ##print 'Sakura.set_mouse_button1:', name
        self.mouse_button1 = name

    def get_mouse_button1(self): ## FIXME: ghost
        return self.mouse_button1

    def set_mouse_button3(self, name): ## FIXME: ghost
        ##print 'Sakura.set_mouse_button3:', name
        self.mouse_button3 = name

    def get_mouse_button3(self): ## FIXME: ghost
        return self.mouse_button3

    def set_browser(self, command): ## FIXME: ghost
        self.browser = command

    def get_browser(self): ## FIXME: ghost
        return self.browser

    def set_helpers(self, list): ## FIXME: ghost
        ##print 'Sakura.set_helpers:', list
        self.helpers = []
        for pattern, command in list:
            try:
                regex = re.compile(pattern)
            except re.error:
                continue
            self.helpers.append((regex, command))

    def get_helpers(self):  ## FIXME: ghost
        buf = []
        for regex, command in self.helpers:
            buf.append((regex.pattern, command))
        return buf

    def set_sink_after_talk(self, flag):
        if flag:
            self.__sink_after_talk = 1
        else:
            self.__sink_after_talk = 0

    def set_raise_before_talk(self, flag):
        if flag:
            self.__raise_before_talk = 1
        else:
            self.__raise_before_talk = 0

    def get_username(self): ## FIXME: ghost
        return self.ghost.get_username()

    def get_selfname(self): ## FIXME: ghost
        return self.ghost.get_selfname()

    def get_selfname2(self): ## FIXME: ghost
        return self.ghost.get_selfname2()

    def get_keroname(self): ## FIXME: ghost
        return self.ghost.get_keroname()

    def get_friendname(self): ## FIXME: ghost
        return self.ghost.get_friendname()

    def keep_silence(self, quiet):
        if quiet:
            self.silent_time = time.time()
        else:
            self.silent_time = 0
            self.reset_idle_time()

    def get_uptime(self): ## FIXME: ghost
        uptime = int(time.time() - self.start_time) / 3600
        if uptime < 0:
            self.start_time = time.time()
            return 0
        return uptime

    ###   STARTER   ###
    def stand_by(self, reset_surface): ## FIXME: ghost
        self.balloon.hide_all()
        self.balloon.hide_sstp_message()
        if reset_surface:
            self.ghost.set_surface_default()
            self.notify_event('OnSurfaceChange',
                              self.ghost.get_surface_id(0),
                              self.ghost.get_surface_id(1))
            self.balloon.set_balloon_default()
        elif self.ghost.get_surface_id(0) != '0' or \
             self.ghost.get_surface_id(1) != '10':
            self.__surface_life = random.randint(20, 30)
            ##print 'surface_life =', self.__surface_life

    def start(self): ## FIXME: ghost
        self.start_time = time.time()

    def restart(self): ## FIXME: ghost&sakura
        self.vanished = 0
        self.old_otherghostname = None ## FIXME
        self.reset_script(1)
        self.surface.reset_alignment()
        self.stand_by(1)
        self.ghost.position_all()
        self.reset_idle_time()
        self.running = 1

    def stop(self):
        self.running = 0

    def notify_ghost_changing(self, name, method, proc): ## FIXME: ghost
        self.reset_script(1)
        self.enqueue_event('OnGhostChanging', name, method, proc=proc)

    def notify_shell_changing(self, name, path, proc): ## FIXME: ghost
        self.reset_script(1)
        self.enqueue_event('OnShellChanging', name, path, proc=proc)

    def notify_vanish_selecting(self): ## FIXME: ghost
        self.reset_script(1)
        self.notify_event('OnVanishSelecting')

    def notify_vanish_selected(self, proc): ## FIXME: ghost
        self.reset_script(1)
        self.enqueue_event('OnVanishSelected', proc=proc)
        self.vanished = 1

    def notify_vanish_cancel(self): ## FIXME: ghost
        self.reset_script(1)
        self.notify_event('OnVanishCancel')

    def notify_ghost_changed(self, name, vanished, default): ## FIXME: ghost
        if self.ghost.get_ghost_time() == 0:
            if self.notify_event('OnFirstBoot',
                                 self.ghost.get_vanished_count()):
                return 
        elif vanished:
            if self.notify_event('OnVanished', name):
                return
        else:
            if self.notify_event('OnGhostChanged', name):
                return
        self.notify_event('OnBoot', default=default)

    def notify_shell_changed(self, name, path): ## FIXME: ghost
        self.notify_event('OnShellChanged', name, name, path)

    def notify_ninix_reloading(self, proc): ## FIXME: ghost
        self.reset_script(1)
        self.enqueue_event('OnNinixReloading', proc=proc)

    def notify_ninix_reloaded(self): ## FIXME: ghost
        self.notify_event('OnNinixReloaded')
        self.notify_event('OnBoot', default=ninix.version.VERSION_INFO)

    def notify_about(self): ## FIXME: ghost
        self.start_script(ninix.version.VERSION_INFO)

    def process_script(self): ## FIXME: ghost&sakura
        now = time.time()
        idle = now - self.idle_start
        minute, second = time.localtime(now)[4:6]
        if self.clock[0] != second:
            self.ghost.increment_ghost_time()
            self.ghost.communicate.rebuild_ghostdb(
                self.ghost,
                self.get_selfname(),
                self.ghost.get_surface_id(0),
                self.ghost.get_surface_id(1))
            otherghostname = self.ghost.communicate.get_otherghostname(
                self.get_selfname())
            if otherghostname != self.old_otherghostname:
                args = []
                args.extend(otherghostname)
                args.insert(0, 'otherghostname')
                args = tuple(args)
                keyword = {'event_type': 'NOTIFY'}
                self.notify_event(*args, **keyword)
            self.old_otherghostname = otherghostname
        mikire, kasanari = self.surface.get_mikire_kasanari()
        if not self.running:
            pass
        elif self.script_mode == self.PAUSE_MODE:
            ##if idle > self.PAUSE_TIMEOUT:
            ##    self.script_mode = self.BROWSE_MODE
            pass
        elif self.processed_script or self.processed_text:
            self.interpret_script()
        elif self.script_post_proc:
            for proc in self.script_post_proc:
                proc()
            self.script_post_proc = []
        elif self.script_mode == self.SELECT_MODE:
            if self.passivemode:
                pass
            elif idle > self.SELECT_TIMEOUT:
                self.script_mode = self.BROWSE_MODE
                if self.sstp_request_handler:
                    self.sstp_request_handler.send_timeout()
                    self.sstp_request_handler = None
                if not self.notify_event('OnChoiceTimeout'):
                    self.stand_by(0)
        elif self.sstp_handle is not None:
            self.close_sstp_handle()
        elif self.user_interaction:
            pass
        elif idle > self.__balloon_life > 0 and not self.passivemode:
            self.__balloon_life = 0
            self.stand_by(0)
            if self.__sink_after_talk:
                self.surface.lower_all()
        elif self.event_queue and self.handle_event():
            pass
        elif self.script_queue and not self.passivemode:
            if self.silent_time > 0:
                self.keep_silence(1) # extend silent time
            script, sender, self.sstp_handle, \
                    host, show_sstp_marker, use_translator, \
                    self.sstp_entry_db, self.sstp_request_handler = \
                    self.script_queue.pop(0)
            if self.cantalk:
                if show_sstp_marker:
                    self.balloon.show_sstp_message(sender, host)
                else:
                    self.balloon.hide_sstp_message()
                # XXX: how about the use_translator flag?
                self.start_script(script, self.FROM_SSTP_CLIENT)
        elif self.silent_time > 0:
            if now - self.silent_time > self.SILENT_TIME:
                self.keep_silence(0)
        elif self.clock[0] != second and \
             self.notify_event('OnSecondChange', self.get_uptime(),
                               mikire, kasanari,
                               not self.passivemode and self.cantalk):
            pass
        elif self.clock[1] != minute and \
             self.notify_event('OnMinuteChange', self.get_uptime(),
                               mikire, kasanari,
                               not self.passivemode and self.cantalk):
            pass
        elif self.surface_mouse_motion is not None:
            side, x, y, part = self.surface_mouse_motion
            self.notify_event('OnMouseMove', x, y, '', side, part)
            self.surface_mouse_motion = None
        elif idle > self.__surface_life > 0 and not self.passivemode:
            self.__surface_life = 0
            self.notify_event('OnSurfaceRestore',
                              self.ghost.get_surface_id(0),
                              self.ghost.get_surface_id(1))
        self.clock = (second, minute)

    ###   SCRIPT PLAYER   ###
    def start_script(self, script, origin=None):
        if not script:
            return
        self.script_origin = origin or self.FROM_GHOST
        self.reset_script(1)
        if not script.rstrip().endswith(r'\e'):
            script = ''.join((script, r'\e'))
        self.processed_script = []
        while 1:
            try:
                self.processed_script.extend(self.script_parser.parse(script))
            except ninix.script.ParserError, e:
                sys.stderr.write(''.join(('-' * 50, '\n')))
                sys.stderr.write(('%s\n' % e).encode('utf-8', 'ignore'))
                done, script = e
                self.processed_script.extend(done)
            else:
                break
        self.script_mode = self.BROWSE_MODE
        self.script_wait = None
        self.script_side = 0
        self.time_critical_session = 0
        self.quick_session = 0
        self.set_synchronized_session(reset=1)
        self.balloon.hide_all()
        self.balloon.clear_text_all()
        self.balloon.set_balloon_default()
        self.current_time = time.localtime(time.time())
        self.reset_idle_time()
        if self.__raise_before_talk:
            self.ghost.raise_all()

    def __yen_e(self, args):
        surface_id = self.ghost.get_surface_id(self.script_side)
        self.surface.invoke_yen_e(self.script_side, surface_id)
        self.reset_script()
        self.__balloon_life = self.BALLOON_LIFE
    
    def __yen_0(self, args):
        ##self.balloon.show(0)
        self.script_side = 0

    def __yen_1(self, args):
        ##self.balloon.show(1)
        self.script_side = 1

    def __yen_p(self, args):
        try:
            chr_id = int(args[0])
        except:
            return
        if chr_id >= 0:
            self.script_side = chr_id

    def __yen_4(self, args): ## FIXME
        if self.script_side == 0:
            sw, sh = self.ghost.get_surface_size(1)
            sx, sy = self.ghost.get_surface_position(1)
        elif self.script_side == 1:
            sw, sh = self.ghost.get_surface_size(0)
            sx, sy = self.ghost.get_surface_position(0)
        else:
            return
        w, h = self.ghost.get_surface_size(self.script_side)
        x, y = self.ghost.get_surface_position(self.script_side)
        scrn_w = gtk.gdk.screen_width() ## FIXME
        if sx + sw / 2 > scrn_w / 2:
            new_x = sx - w - int(scrn_w / 20)
        else:
            new_x = sx + sw + int(scrn_w / 20)
        new_x = max(new_x, 0)
        new_x = min(new_x, scrn_w - w)
        if x > new_x:
            step = -10
        else:
            step = 10
        if abs(sx - new_x) < abs(sx - x):
            return
        for current_x in range(x, new_x, step):
            self.ghost.set_surface_position(self.script_side, current_x, y)
            self.balloon.reset_balloon_all()
        self.ghost.set_surface_position(self.script_side, new_x, y)
        self.balloon.reset_balloon_all()

    def __yen_5(self, args): ## FIXME
        if self.script_side == 0:
            sw, sh = self.ghost.get_surface_size(1)
            sx, sy = self.ghost.get_surface_position(1)
        elif self.script_side == 1:
            sw, sh = self.ghost.get_surface_size(0)
            sx, sy = self.ghost.get_surface_position(0)
        else:
            return
        w, h = self.ghost.get_surface_size(self.script_side)
        x, y = self.ghost.get_surface_position(self.script_side)
        scrn_w = gtk.gdk.screen_width() ## FIXME
        if x < sx + sw / 2 < x + w or sx < x + w / 2 < sx + sw:
            return
        if sx + sw / 2 > x + w / 2:
            new_x = sx - w / 2 + 1
        else:
            new_x = sx + sw - w / 2 - 1
        new_x = max(new_x, 0)
        new_x = min(new_x, scrn_w - w)
        if x > new_x:
            step = -10
        else:
            step = 10
        for current_x in range(x, new_x, step):
            self.ghost.set_surface_position(self.script_side, current_x, y)
            self.balloon.reset_balloon_all()
        self.ghost.set_surface_position(self.script_side, new_x, y)
        self.balloon.reset_balloon_all()

    def __yen_s(self, args):
        surface_id = args[0]
        if surface_id == '-1':
            self.ghost.hide_surface(self.script_side)
        else:
            self.ghost.set_surface_id(self.script_side, surface_id)
            self.ghost.show_surface(self.script_side)
            ## FIXME: self.script_side > 1
            self.notify_event('OnSurfaceChange',
                              self.ghost.get_surface_id(0),
                              self.ghost.get_surface_id(1))
            self.ghost.position_balloons() ## FIXME
        if self.script_side in [0, 1] and not self.__boot[self.script_side]:
            self.__boot[self.script_side] = 1

    def __yen_b(self, args):
        if args[0] == '-1':
            self.balloon.hide(self.script_side)
        else:
            try:
                balloon_id = int(args[0]) / 2
            except ValueError:
                balloon_id = 0
            else:
                self.balloon.set_balloon(self.script_side, balloon_id)

    def __yen__b(self, args):
        filename, x, y = self.expand_meta(args[0]).split(',')
        filename = filename.lower()
        path = os.path.join(self.ghost.get_prefix(), 'ghost/master',
                            filename.replace('\\', '/'))
        if os.path.isfile(path):
            self.balloon.append_image(self.script_side, path, x, y)

    def __yen_n(self, args):
        if args and self.expand_meta(args[0]) == 'half':
            self.balloon.append_text(self.script_side, u'\n[half]')
        else:
            self.balloon.append_text(self.script_side, u'\n')

    def __yen_c(self, args):
        self.balloon.clear_text(self.script_side)

    def __set_weight(self, value, unit):
        try:
            amount = int(value) * unit - 0.01
        except ValueError:
            amount = 0
        if amount > 0:
            self.script_wait = time.time() + amount

    def __yen_w(self, args):
        if not self.quick_session and self.script_speed >= 0:
            self.__set_weight(args[0], 0.05) # 50ms

    def __yen__w(self, args):
        if not self.quick_session and self.script_speed >= 0:
            self.__set_weight(args[0], 0.001) # 1ms

    def __yen_t(self, args):
        self.time_critical_session = not self.time_critical_session

    def __yen__q(self, args):
        self.quick_session = not self.quick_session

    def __yen__s(self, args):
        self.set_synchronized_session([int(arg) for arg in args])

    def __yen__e(self, args):
        self.balloon.hide(self.script_side)
        self.balloon.clear_text(self.script_side)

    def __yen_q(self, args):
        newline_required = 0
        if len(args) == 3: # traditional syntax
            num, link_id, text = args
            newline_required = 1
        else: # new syntax
            text, link_id = args
        text = self.expand_meta(text)
        self.balloon.append_link(self.script_side, link_id, text,
                                 newline_required)
        self.script_mode = self.SELECT_MODE

    def __yen_URL(self, args):
        text = self.expand_meta(args[0])
        if len(args) == 1:
            link = text
        else:
            link = '#cancel'
        self.balloon.append_link(self.script_side, link, text)
        for i in range(1, len(args), 2):
            link = self.expand_meta(args[i])
            text = self.expand_meta(args[i + 1])
            self.balloon.append_link(self.script_side, link, text)
        self.script_mode = self.SELECT_MODE

    def __yen__a(self, args):
        if self.anchor:
            anchor_id = self.anchor[0]
            text = self.anchor[1]
            self.balloon.append_link_out(self.script_side, anchor_id, text)
            self.anchor = None
        else:
            anchor_id = args[0]
            self.anchor = [('anchor', anchor_id), '']
            self.balloon.append_link_in(self.script_side, self.anchor[0])

    def __yen_x(self, args):
        if self.script_mode == self.BROWSE_MODE:
            self.script_mode = self.PAUSE_MODE
            self.balloon.redraw_arrow(self.script_side, 1)
            self.balloon.append_text(self.script_side, u'\n')

    def __yen_a(self, args):
        self.start_script(self.ghost.getaistringrandom())

    def __yen_i(self, args):
        try:
            actor_id = int(args[0])
        except ValueError:
            pass
        else:
            self.surface.invoke(self.script_side, actor_id)

    def __yen_j(self, args):
        jump_id = args[0]
        if self.is_URL(jump_id):
            self.launch_browser(jump_id)
        elif self.sstp_entry_db:
            self.start_script(self.sstp_entry_db.get(jump_id, r'\e'))

    def __yen_minus(self, args):
        self.ghost.quit()

    def __yen_plus(self, args):
        self.ghost.select_ghost(1)

    def __yen__plus(self, args):
        self.ghost.select_ghost(0)

    def __yen_m(self, args):
        self.write_sstp_handle(self.expand_meta(args[0]))

    def __yen_and(self, args):
        if self.name2codepoint is not None:
            text = unichr(self.name2codepoint.get(args[0]))
        else:
            text = None
        if text is None:
            text = '?'
        self.balloon.append_text(self.script_side, text)

    def __yen__m(self, args):
        try:
            num = int(args[0], 16)
        except ValueError:
            num = 0
        if 0x20 <= num <= 0x7e:
            text = chr(num)
        else:
            text = '?'
        self.balloon.append_text(self.script_side, text)

    def __yen__u(self, args):
        if re.match('0x[a-fA-F0-9]{4}', args[0]):
            text = eval(''.join(('u"\\u', args[0][2:], '"')))
            self.balloon.append_text(self.script_side, text)
        else:
            self.balloon.append_text(self.script_side, u'?')

    def __yen__v(self, args):
        filename = self.expand_meta(args[0])
        filename = filename.lower()
        path = os.path.join(self.ghost.get_prefix(), 'ghost/master', filename)
        if os.path.isfile(path):
            for regex, command in self.helpers:
                if regex.search(path):
                    self.execute_command(command, path)
                    break

    def __yen_exclamation(self, args): ## FIXME
        if not args:
            return
        argc = len(args)
        args = [self.expand_meta(s) for s in args]
        if args[0] == 'raise' and argc >= 2:
            self.notify_event(*args[1:10])
        elif args[0:2] == ['open', 'browser'] and argc > 2:
            self.launch_browser(args[2])
        elif args[0:2] == ['open', 'communicatebox']:
            if not self.passivemode:
                self.open_communicatebox()
        elif args[0:2] == ['open', 'teachbox']:
            if not self.passivemode:
                self.open_teachbox()
        elif args[0:2] == ['open', 'inputbox'] and argc > 2:
            if not self.passivemode:
                if argc > 4:
                    self.open_inputbox(args[2], args[3], args[4])
                elif argc == 4:
                    self.open_inputbox(args[2], args[3])
                else:
                    self.open_inputbox(args[2])
        elif args[0:2] == ['open', 'configurationdialog']:
            self.ghost.edit_preferences()
        elif args[0:2] == ['change', 'ghost'] and argc > 2:
            if args[2] == 'random':
                self.ghost.select_ghost(0, 0)
            else:
                self.ghost.select_ghost_by_name(args[2], 0)
        elif args[0:1] == ['updatebymyself']:
            if not self.busy():
                self.ghost.update()
        elif args[0:1] == ['vanishbymyself']: ## FIXME
            self.vanished = 1
            count = self.ghost.get_vanished_count()
            self.ghost.set_vanished_count(count + 1)
            self.ghost.set_ghost_time(0)
            self.ghost.app.stop_sakura(self.ghost.app.vanish_sakura)
        elif args[1:2] == ['repaint']:
            if args[0:1] == ['lock']:
                self.lock_repaint = 1
            elif args[0:1] == ['unlock']:
                self.lock_repaint = 0
        elif args[1:2] == ['passivemode']:
            if args[0:1] == ['enter']:
                self.passivemode = 1
            elif args[0:1] == ['leave']:
                self.passivemode = 0
        elif args[0:2] == ['set', 'alignmentondesktop']:
            if args[2] == 'bottom':
                if self.synchronized_session:
                    for chr_id in self.synchronized_session:
                        self.ghost.align_bottom(chr_id)
                else:
                    self.ghost.align_bottom(self.script_side)
            elif args[2] == 'top':
                if self.synchronized_session:
                    for chr_id in self.synchronized_session:
                        self.ghost.align_top(chr_id)
                else:
                    self.ghost.align_top(self.script_side)
        elif args[0:2] == ['set', 'alignmenttodesktop']:
            if args[2] == 'free':
                if self.synchronized_session:
                    for chr_id in self.synchronized_session:
                        self.surface.set_alignment(chr_id, 2)
                else:
                    self.surface.set_alignment(self.script_side, 2)
        elif args[0:2] == ['set', 'windowstate']:
            if args[2] == 'minimize':
                self.surface.window_iconify(True)
            ##elif args[2] == '!minimize':
            ##    self.surface.window_iconify(False)
            elif args[2] == 'stayontop':
                self.surface.window_stayontop(True)
            elif args[2] == '!stayontop':
                self.surface.window_stayontop(False)
        elif args[0] == '*':
            self.balloon.append_sstp_marker(self.script_side)
        else:
            pass ## FIXME

    def __yen___c(self, args):
        self.open_communicatebox()

    def __yen___t(self, args): 
        self.open_teachbox()

    def __yen_v(self, args):
        self.ghost.raise_surface(self.script_side)

    def __yen_f(self, args):
        if args[0] == 'sup':
            assert len(args) == 2
            if args[1] == 'true':
                self.balloon.append_meta(self.script_side, '<sup>')
            else:
                self.balloon.append_meta(self.script_side, '</sup>')
        elif args[0] == 'sub':
            assert len(args) == 2
            if args[1] == 'true':
                self.balloon.append_meta(self.script_side, '<sub>')
            else:
                self.balloon.append_meta(self.script_side, '</sub>')
        elif args[0] == 'strike':
            assert len(args) == 2
            if args[1] in ['true', '1', 1]:
                self.balloon.append_meta(self.script_side, '<s>')
            else:
                self.balloon.append_meta(self.script_side, '</s>')
        elif args[0] == 'underline':
            assert len(args) == 2
            if args[1] in ['true', '1', 1]:
                self.balloon.append_meta(self.script_side, '<u>')
            else:
                self.balloon.append_meta(self.script_side, '</u>')
        else:
            pass ## FIXME

    __script_tag = {
        r'\e': __yen_e,
        r'\0': __yen_0,
        r'\h': __yen_0,
        r'\1': __yen_1,
        r'\u': __yen_1,
        r'\p': __yen_p,
        r'\4': __yen_4,
        r'\5': __yen_5,
        r'\s': __yen_s,
        r'\b': __yen_b,
        r'\_b': __yen__b,
        r'\n': __yen_n,
        r'\c': __yen_c,
        r'\w': __yen_w,
        r'\_w': __yen__w,
        r'\t': __yen_t,
        r'\_q': __yen__q,
        r'\_s': __yen__s,
        r'\_e': __yen__e,
        r'\q': __yen_q,
        r'\URL': __yen_URL,
        r'\_a': __yen__a,
        r'\x': __yen_x,
        r'\a': __yen_a, # Obsolete: only for old SHIORI
        r'\i': __yen_i,
        r'\j': __yen_j,
        r'\-': __yen_minus,
        r'\+': __yen_plus,
        r'\_+': __yen__plus,
        r'\m': __yen_m,
        r'\&': __yen_and,
        r'\_m': __yen__m,
        r'\_u': __yen__u,
        r'\_v': __yen__v,
        r'\!': __yen_exclamation,
        r'\__c': __yen___c,
        r'\__t': __yen___t, 
        r'\v': __yen_v,
        r'\f': __yen_f,
        }

    def interpret_script(self):
        if self.script_wait is not None:
            if time.time() < self.script_wait:
                return
            self.script_wait = None
        if self.processed_text:
            self.balloon.show(self.script_side)
            self.balloon.append_text(self.script_side, self.processed_text[0])
            self.processed_text = self.processed_text[1:]
            surface_id = self.ghost.get_surface_id(self.script_side)
            count = self.balloon.get_text_count(self.script_side)
            if self.surface.invoke_talk(self.script_side, surface_id, count):
                self.balloon.reset_text_count(self.script_side)
            if self.script_speed > 0:
                self.script_wait = time.time() + self.script_speed * 0.02
            return
        node = self.processed_script.pop(0)
        if node[0] == ninix.script.SCRIPT_TAG:
            name, args = node[1], node[2:]
            if name in self.__script_tag:
                self.__script_tag[name](self, args)
            else:
                pass ## FIMXE
        elif node[0] == ninix.script.SCRIPT_TEXT:
            text = self.expand_meta(node[1])
            if self.anchor:
                self.anchor[1] = ''.join((self.anchor[1], text))
            if not self.quick_session and self.script_speed >= 0:
                self.processed_text = text
            else:
                self.balloon.append_text(self.script_side, text)

    def open_communicatebox(self): ## FIXME: ghost&sakura
        if self.user_interaction:
            return
        self.balloon.show_communicatebox()
        self.user_interaction = 1

    def open_teachbox(self): ## FIXME: ghost&sakura
        if self.user_interaction:
            return
        self.notify_event('OnTeachStart')
        self.balloon.show_teachbox()
        self.user_interaction = 1

    def open_inputbox(self, symbol, limittime=-1, default=None): ## FIXME: ghost&sakura
        if self.user_interaction:
            return
        self.balloon.show_inputbox(symbol, limittime, default)
        self.user_interaction = 1

    def reset_script(self, reset_all=0):
        if reset_all:
            self.script_mode = self.BROWSE_MODE
            self.script_post_proc = []
        self.processed_script = None
        self.processed_text = ''
        self.time_critical_session = 0
        self.quick_session = 0
        self.set_synchronized_session(reset=1)
        self.reset_idle_time()

    def set_synchronized_session(self, list=[], reset=0):
        if reset:
            self.synchronized_session = []
        elif not list:
            if self.synchronized_session:
                self.synchronized_session = []
            else:
                self.synchronized_session = [0, 1]
        else:
            self.synchronized_session = list
        self.balloon.synchronize(self.synchronized_session)

    def expand_meta(self, text_node):
        buf = []
        for chunk in text_node:
            if chunk[0] == ninix.script.TEXT_STRING:
                buf.append(chunk[1])
            elif chunk[1] == '%month':
                buf.append(str(self.current_time[1]))
            elif chunk[1] == '%day':
                buf.append(str(self.current_time[2]))
            elif chunk[1] == '%hour':
                buf.append(str(self.current_time[3]))
            elif chunk[1] == '%minute':
                buf.append(str(self.current_time[4]))
            elif chunk[1] == '%second':
                buf.append(str(self.current_time[5]))
            elif chunk[1] in ['%username', '%c']:
                buf.append(self.get_username())
            elif chunk[1] == '%selfname':
                buf.append(self.get_selfname())
            elif chunk[1] == '%selfname2':
                buf.append(self.get_selfname2())
            elif chunk[1] == '%keroname':
                buf.append(self.get_keroname())
            elif chunk[1] == '%friendname':
                buf.append(self.get_friendname())
            elif chunk[1] == '%screenwidth':
                buf.append(str(gtk.gdk.screen_width())) ## FIXME
            elif chunk[1] == '%screenheight':
                buf.append(str(gtk.gdk.screen_height())) ## FIXME
            elif chunk[1] == '%et':
                buf.append(
                    unicode('%d万年' % self.current_time[7], 'UTF-8'))
            elif chunk[1] == '%exh':
                buf.append(str(self.get_uptime()))
            elif chunk[1] in ['%ms', '%mz', '%ml', '%mc', '%mh', \
                              '%mt', '%me', '%mp', '%m?']:
                buf.append(
                    self.ghost.getword(''.join(('\\', chunk[1][1:]))))
            elif chunk[1] == '%dms':
                buf.append(self.ghost.getdms())
            else: # %c, %songname
                buf.append(chunk[1])
        return ''.join(buf)

    ###   SEND SSTP/1.3   ###
    def open_sstp_handle(self, path):
        handle = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        try:
            handle.connect(path)
        except socket.error:
            handle = None # discard socket object
            sys.stderr.write('cannot open Unix socket: %s\n' % path)
        return handle

    def _send_sstp_handle(self, data):
        r, w, e = select.select([], [self.sstp_handle], [], 0)
        if not w:
            return
        try:
            self.sstp_handle.send(''.join((data, '\n')))
        except socket.error:
            pass

    def write_sstp_handle(self, data):
        if self.sstp_handle is None:
            return
        self._send_sstp_handle(''.join(('+', data)))
        ##print 'write_sstp_handle(%s)' % repr(data)

    def close_sstp_handle(self):
        if self.sstp_handle is None:
            return
        self._send_sstp_handle('-')
        ##print 'close_sstp_handle()'
        try:
            self.sstp_handle.close()
        except socket.error:
            pass
        self.sstp_handle = None


def test():
    pass

if __name__ == '__main__':
    test()
