/* automatically generated by m68k-bus-auto.sh, do not edit! */
_TME_RCSID("$Id: m68k-bus-auto.sh,v 1.3 2007/02/12 23:47:11 fredette Exp $");

/* we use OP3, OP2, OP1, and OP0 to represent bytes of lesser
   significance to more significance, respectively, matching Table 5-5
   in the MC68020 User's Manual (linear page 56 in my .ps copy).

   the Motorola OPn convention numbers bytes by decreasing
   significance (OP2 is less significant than OP1), and since Motorola
   CPUs are big-endian, this means that a higher numbered byte is
   meant to go to a higher address, which is good, because we can then
   use this to easily form indexes for TME_BUS_LANE_ROUTE, which
   expects a higher numbered index to correspond to a higher address
   in memory.

   however, since the same Motorola OPn convention always calls the
   least significant byte of any value OP3, regardless of the total
   size of the value, we need to adjust each OPn given the total
   size of the value, so that OP3 in a 24-bit value means address + 2,
   but OP3 in a 32-bit value means address + 3: */
#define SIZ8_OP(n)	((n) - 3)
#define SIZ16_OP(n)	((n) - 2)
#define SIZ24_OP(n)	((n) - 1)
#define SIZ32_OP(n)	((n) - 0)

/* the 16-bit bus router used on the 68000 and 68010: */
const tme_bus_lane_t tme_m68k_router_16[TME_M68K_BUS_ROUTER_SIZE(TME_BUS16_LOG2)] = {

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A0: 0
     [gen]  responding port size: 8 bits
     [gen]  responding port least lane: 0 (lanes D7-D0 - incorrect for 16-bit m68k)
     (code 1.0.1.0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A0: 0
     [gen]  responding port size: 8 bits
     [gen]  responding port least lane: 1 (lanes D15-D8)
     (code 1.0.1.1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A0: 0
     [gen]  responding port size: 16 bits
     [gen]  responding port least lane: 0 (lanes D15-D8 D7-D0)
     (code 1.0.2.0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A0: 0
     [gen]  responding port size: 16 bits
     [gen]  responding port least lane: 1 (lanes D23-D16 D15-D8 - invalid, array placeholder)
     (code 1.0.2.1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A0: 1
     [gen]  responding port size: 8 bits
     [gen]  responding port least lane: 0 (lanes D7-D0)
     (code 1.1.1.0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A0: 1
     [gen]  responding port size: 8 bits
     [gen]  responding port least lane: 1 (lanes D15-D8 - incorrect for 16-bit m68k)
     (code 1.1.1.1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A0: 1
     [gen]  responding port size: 16 bits
     [gen]  responding port least lane: 0 (lanes D15-D8 D7-D0)
     (code 1.1.2.0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A0: 1
     [gen]  responding port size: 16 bits
     [gen]  responding port least lane: 1 (lanes D23-D16 D15-D8 - invalid, array placeholder)
     (code 1.1.2.1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A0: 0
     [gen]  responding port size: 8 bits
     [gen]  responding port least lane: 0 (lanes D7-D0)
     (code 2.0.1.0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A0: 0
     [gen]  responding port size: 8 bits
     [gen]  responding port least lane: 1 (lanes D15-D8)
     (code 2.0.1.1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A0: 0
     [gen]  responding port size: 16 bits
     [gen]  responding port least lane: 0 (lanes D15-D8 D7-D0)
     (code 2.0.2.0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A0: 0
     [gen]  responding port size: 16 bits
     [gen]  responding port least lane: 1 (lanes D23-D16 D15-D8 - invalid, array placeholder)
     (code 2.0.2.1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A0: 1
     [gen]  responding port size: 8 bits
     [gen]  responding port least lane: 0 (lanes D7-D0)
     (code 2.1.1.0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A0: 1
     [gen]  responding port size: 8 bits
     [gen]  responding port least lane: 1 (lanes D15-D8)
     (code 2.1.1.1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A0: 1
     [gen]  responding port size: 16 bits
     [gen]  responding port least lane: 0 (lanes D15-D8 D7-D0)
     (code 2.1.2.0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A0: 1
     [gen]  responding port size: 16 bits
     [gen]  responding port least lane: 1 (lanes D23-D16 D15-D8 - invalid, array placeholder)
     (code 2.1.2.1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
};

/* the 32-bit bus router used on the 68020 and 68030: */
const tme_bus_lane_t tme_m68k_router_32[TME_M68K_BUS_ROUTER_SIZE(TME_BUS32_LOG2)] = {

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 1.0.1.0, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 1.0.1.1, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 1.0.1.2, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 1.0.1.3, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 1.0.2.0, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 1.0.2.1, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 1.0.2.2, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 1.0.2.3, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 1.0.4.0, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 1.0.4.1, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 1.0.4.2, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 1.0.4.3, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 1.1.1.0, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 1.1.1.1, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 1.1.1.2, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 1.1.1.3, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 1.1.2.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 1.1.2.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 1.1.2.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 1.1.2.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 1.1.4.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 1.1.4.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 1.1.4.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 1.1.4.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 1.2.1.0, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 1.2.1.1, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 1.2.1.2, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 1.2.1.3, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 1.2.2.0, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 1.2.2.1, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 1.2.2.2, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 1.2.2.3, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 1.2.4.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 1.2.4.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 1.2.4.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 1.2.4.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 1.3.1.0, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 1.3.1.1, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 1.3.1.2, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 1.3.1.3, OP3 lane 3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 1.3.2.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 1.3.2.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 1.3.2.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 1.3.2.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 1.3.4.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ8_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 1.3.4.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 1.3.4.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 8 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 1.3.4.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 2.0.1.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 2.0.1.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 2.0.1.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 2.0.1.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 2.0.2.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 2.0.2.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 2.0.2.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 2.0.2.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 2.0.4.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 2.0.4.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 2.0.4.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 2.0.4.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 2.1.1.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 2.1.1.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 2.1.1.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 2.1.1.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 2.1.2.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 2.1.2.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 2.1.2.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 2.1.2.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 2.1.4.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 2.1.4.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 2.1.4.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 2.1.4.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 2.2.1.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 2.2.1.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 2.2.1.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 2.2.1.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 2.2.2.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 2.2.2.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 2.2.2.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 2.2.2.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 2.2.4.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 2.2.4.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 2.2.4.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 2.2.4.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 2.3.1.0, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 2.3.1.1, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 2.3.1.2, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 2.3.1.3, OP3 lane 2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 2.3.2.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 2.3.2.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 2.3.2.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 2.3.2.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 2.3.4.0, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ16_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ16_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 2.3.4.1, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 2.3.4.2, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 16 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 2.3.4.3, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 3.0.1.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 3.0.1.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 3.0.1.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 3.0.1.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 3.0.2.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 3.0.2.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 3.0.2.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 3.0.2.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 3.0.4.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 3.0.4.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 3.0.4.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 3.0.4.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 3.1.1.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 3.1.1.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 3.1.1.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 3.1.1.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 3.1.2.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 3.1.2.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 3.1.2.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 3.1.2.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 3.1.4.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 3.1.4.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 3.1.4.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 3.1.4.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 3.2.1.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 3.2.1.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 3.2.1.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 3.2.1.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 3.2.2.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 3.2.2.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 3.2.2.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 3.2.2.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 3.2.4.0, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 3.2.4.1, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 3.2.4.2, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 3.2.4.3, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 3.3.1.0, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 3.3.1.1, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 3.3.1.2, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 3.3.1.3, OP3 lane 1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 3.3.2.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 3.3.2.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 3.3.2.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 3.3.2.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 3.3.4.0, OP3 lane -2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ24_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ24_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 3.3.4.1, OP3 lane -2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 3.3.4.2, OP3 lane -2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 24 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 3.3.4.3, OP3 lane -2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 4.0.1.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 4.0.1.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 4.0.1.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 4.0.1.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 4.0.2.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 4.0.2.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 4.0.2.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(3)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 4.0.2.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 4.0.4.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(3)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 4.0.4.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 4.0.4.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 00
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 4.0.4.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 4.1.1.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 4.1.1.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 4.1.1.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 4.1.1.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 4.1.2.0, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 4.1.2.1, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 4.1.2.2, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 4.1.2.3, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 4.1.4.0, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(2)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 4.1.4.1, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 4.1.4.2, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 01
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 4.1.4.3, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 4.2.1.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 4.2.1.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 4.2.1.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 4.2.1.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 4.2.2.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 4.2.2.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 4.2.2.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 4.2.2.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 4.2.4.0, OP3 lane -2): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 4.2.4.1, OP3 lane -2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 4.2.4.2, OP3 lane -2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 10
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 4.2.4.3, OP3 lane -2): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 0 (lanes D7-D0 - incorrect for 32-bit m68k)
     (code 4.3.1.0, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 1 (lanes D15-D8 - incorrect for 32-bit m68k)
     (code 4.3.1.1, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 2 (lanes D23-D16 - incorrect for 32-bit m68k)
     (code 4.3.1.2, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 8 bits
     [gen]  responder port least lane: 3 (lanes D31-D24)
     (code 4.3.1.3, OP3 lane 0): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 0 (lanes D15-D8 D7-D0 - incorrect for 32-bit m68k)
     (code 4.3.2.0, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 1 (lanes D23-D16 D15-D8 - incorrect for 32-bit m68k)
     (code 4.3.2.1, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 2 (lanes D31-D24 D23-D16)
     (code 4.3.2.2, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 16 bits
     [gen]  responder port least lane: 3 (lanes D39-D32 D31-D24 - invalid, array placeholder)
     (code 4.3.2.3, OP3 lane -1): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 0 (lanes D31-D24 D23-D16 D15-D8 D7-D0)
     (code 4.3.4.0, OP3 lane -3): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(SIZ32_OP(1)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(SIZ32_OP(0)) | TME_BUS_LANE_ROUTE_WRITE_IGNORE,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 1 (lanes D39-D32 D31-D24 D23-D16 D15-D8 - invalid, array placeholder)
     (code 4.3.4.1, OP3 lane -3): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 2 (lanes D47-D40 D39-D32 D31-D24 D23-D16 - invalid, array placeholder)
     (code 4.3.4.2, OP3 lane -3): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* [m68k] initiator maximum cycle size: 32 bits
     [m68k] initiator A1,A0: 11
     [gen]  responder port size: 32 bits
     [gen]  responder port least lane: 3 (lanes D55-D48 D47-D40 D39-D32 D31-D24 - invalid, array placeholder)
     (code 4.3.4.3, OP3 lane -3): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,
};
#undef SIZ8_OP
#undef SIZ16_OP
#undef SIZ24_OP
#undef SIZ32_OP
