#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

/**/

#include "Common.h"

/**/

const unsigned long gSpeedOffset = 10;
const long gDefaultScrollLen = 2;
const unsigned long gDefaultScrollSpeed = 400 / gSpeedOffset;
const unsigned long gDefaultScrollWait = 4000 / gSpeedOffset;

/**/

#define CONF_FILE_NAME	".nnhl.conf"
#define URL_FILE_NAME	".nnhl_url"

#define STR_HEADER_CONF_0_1_0	"# Config file Version "
#define STR_HEADER_CONF_0_1_1	\
	"# nnhl - Net News HeadLine : Config file Version "
#define STR_HEADER_CONF	STR_HEADER_CONF_0_1_1

#define STR_HEADER_URL_0_1_0	"# URL list Version "
#define STR_HEADER_URL_0_1_1	\
	"# nnhl - Net News HeadLine : URL list Version "
#define STR_HEADER_URL	STR_HEADER_URL_0_1_1

#define STR_VERSION_CONF_0_1_0	"0.1.0"
#define STR_VERSION_CONF_0_1_1	"0.1.1"
#define STR_VERSION_CONF	STR_VERSION_CONF_0_1_1

#define STR_VERSION_URL_0_1_0	"0.1.0"
#define STR_VERSION_URL_0_1_1	"0.1.1"
#define STR_VERSION_URL	STR_VERSION_URL_0_1_1

/**/

struct TListUrl {
	NMes mes;
	char *url;
	bool flagDown;
	long encoding;
	long skipArt;
};

TListUrl gListUrl[] = {
	{ NMesUrlName_news2_2ch_net_news5plus_,
		"http://news2.2ch.net/news5plus/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_sports2_2ch_net_iraq_,
		"http://sports2.2ch.net/iraq/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_news2_2ch_net_news5_,
		"http://news2.2ch.net/news5/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_society_2ch_net_kokusai_,
		"http://society.2ch.net/kokusai/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_tmp2_2ch_net_bakanews_,
		"http://tmp2.2ch.net/bakanews/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_tmp2_2ch_net_asia_,
		"http://tmp2.2ch.net/asia/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_news2_2ch_net_news2_,
		"http://news2.2ch.net/news2/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_pc_2ch_net_pcnews_,
		"http://pc.2ch.net/pcnews/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_comic_2ch_net_comicnews_,
		"http://comic.2ch.net/comicnews/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_music3_2ch_net_musicnews_,
		"http://music3.2ch.net/musicnews/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_news6_2ch_net_trafficinfo_,
		"http://news6.2ch.net/trafficinfo/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_news4_2ch_net_news_,
		"http://news4.2ch.net/news/",
		true,
		WS_EN_SJIS,
		2,
	},
	{ NMesUrlName_news5_2ch_net_newsplus_,
		"http://news5.2ch.net/newsplus/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_bbq_2ch_net_bbynews_,
		"http://bbq.2ch.net/bbynews/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_news7_2ch_net_femnewsplus_,
		"http://news7.2ch.net/femnewsplus/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_news6_2ch_net_mnewsplus_,
		"http://news6.2ch.net/mnewsplus/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_book_2ch_net_bizplus_,
		"http://book.2ch.net/bizplus/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_news8_2ch_net_eqplus_,
		"http://news8.2ch.net/eqplus/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesUrlName_news8_2ch_net_eq_,
		"http://news8.2ch.net/eq/",
		true,
		WS_EN_SJIS,
		gSkipArtMaxN,
	},
	{ NMesNull,
		NULL,
		false,
		WS_EN_DEFAULT,
		0,
	},
};

/**/

void CHeadLine::Init( void )
{
#if 1
	SetMessage( LANG_KIND_JAPANESE );
#else
	SetMessage( LANG_KIND_ENGLISH );
#endif

	mHeadLineCurN = 0;
	mHeadLineMaxN = 0;
	mFlagDown = false;

	mFlagDump = false;

	mStrItem = "";

	mWordIdx = 0;
	mWordMaxIdx = 1;
	mSkipArtCount = 0;

	mStrWordSep = "\n";
	mStrThreadSepWord = "-- Thread separator --";
	mStrThreadSep.clear();
	mStrThreadSep << mStrThreadSepWord << mStrWordSep;

	SetScroll( gDefaultScrollLen,
		gDefaultScrollSpeed, gDefaultScrollWait );

	gUrl.Init();
	if( !Load() )
		ResetUrlList();

	Reset();

	InitSrvr();

	if( !NewsThreadCreate( BGDownLoad ) )
		PopupError( MesThreadCreateError );
}

/**/

void CHeadLine::Reset( void )
{
	Stop();
	Update( 0, true );
}

/**/

WSCstring CHeadLine::GetStr( long n )
{
	long maxN = mStrHeadLine.getNum();

	if( n < 0 )
		return "";
	if( n > maxN - 1 )
		return "";
	if( mStrHeadLine[n] == NULL )
		return "";

	return( *(WSCstring *)(mStrHeadLine[n]) );
}

/**/

WSCstring CHeadLine::SetStr( long n, WSCstring str )
{
	long maxN = mStrHeadLine.getNum();

	if( n < 0 )
		return "";
	if( n > maxN - 1 )
		return "";
	if( mStrHeadLine[n] == NULL )
		return "";

	*((WSCstring *)(mStrHeadLine[n])) = str;
	return( *((WSCstring *)(mStrHeadLine[n])) );
}

/**/

bool CHeadLine::GetDone( long n )
{
	long maxN = mFlagDone.getNum();

	if( n < 0 )
		return false;
	if( n > maxN - 1 )
		return false;
	if( mFlagDone[n] == NULL )
		return false;

	return( *(bool *)(mFlagDone[n]) );
}

/**/

bool CHeadLine::SetDone( long n, bool done )
{
	long maxN = mFlagDone.getNum();

	if( n < 0 )
		return false;
	if( n > maxN - 1 )
		return false;
	if( mFlagDone[n] == NULL )
		return false;

	*((bool *)(mFlagDone[n])) = done;
	return( *((bool *)(mFlagDone[n])) );
}

/**/

void CHeadLine::UpdateTimer( void )
{
	UpdateSub( +1, false, false );

	if( mSkipArtCount >= gUrl.GetSkipArt( mHeadLineCurN ) ){
		mSkipArtCount = 0;
		NextThread( +1 );
	}
}

/**/

void CHeadLine::Update( long nSkip, bool flagForce )
{
	UpdateSub( nSkip, flagForce, true );
}

/**/

void CHeadLine::UpdateSub(
	long nSkip, bool flagForce, bool flagResetSkip )
{
	unsigned long n = Maivscr_ScrollBar->getProperty( WSNvalue );
	unsigned long max_n = Maivscr_ScrollBar->getProperty( WSNmaximum );

	if( flagForce || ((n + mScrollLen) >= max_n) ){
		if( !flagResetSkip )
			mSkipArtCount++;

		mStrItem = GetText( nSkip );

		n = 0;
		max_n = mStrItem.getChars();
		if( max_n < 1 )
			max_n = 1;
		Maivscr_ScrollBar->setProperty( WSNvalue, n );
		Maivscr_ScrollBar->setProperty( WSNmaximum, max_n );
		Maivscr_ScrollBar->setProperty( WSNsliderSize, mScrollLen );
		Maivscr_ScrollBar->setProperty( WSNincrement, mScrollLen );
		Maivscr_ScrollBar->setProperty( WSNpageIncrement,
			mScrollLen * 10 );

		WaitTimer();
	} else {
		n += mScrollLen;
		Maivscr_ScrollBar->setProperty( WSNvalue, n );

	}

	if( flagResetSkip )
		mSkipArtCount = 0;

	Draw();
}

/**/

void CHeadLine::Draw( void )
{
	WSCstring strDraw = mStrItem;

	unsigned long n = Maivscr_ScrollBar->getProperty( WSNvalue );
	if( n > 0 )
		strDraw.deleteChars( 0, n );

	Maivksl_HeadLine->setProperty( WSNlabelString, strDraw );
	MainWin->setProperty( WSNtitleString, strDraw );
}

/**/

void CHeadLine::WaitTimer( void )
{
	WSCbool flagBegin = Maivtim_BeginTimer->getProperty( WSNrunning );
	WSCbool flagMain = Maivtim_MainTimer->getProperty( WSNrunning );

	if( flagBegin || flagMain ){
		Maivtim_BeginTimer->setProperty( WSNrunning, true );
		Maivtim_MainTimer->setProperty( WSNrunning, false );
	}

	SetStopBtn();
}

/**/

bool CHeadLine::PlayOrStop( void )
{
	WSCbool flagBegin = Maivtim_BeginTimer->getProperty( WSNrunning );
	WSCbool flagMain = Maivtim_MainTimer->getProperty( WSNrunning );

	if( flagBegin || flagMain ){
		return Stop();
	} else {
		return Play();
	}
}

/**/

bool CHeadLine::Play( void )
{
	Maivtim_BeginTimer->setProperty( WSNrunning, false );
	Maivtim_MainTimer->setProperty( WSNrunning, true );

	return SetStopBtn();
}

/**/

bool CHeadLine::Stop( void )
{
	Maivtim_BeginTimer->setProperty( WSNrunning, false );
	Maivtim_MainTimer->setProperty( WSNrunning, false );

	return SetStopBtn();
}

/**/

bool CHeadLine::SetStopBtn( void )
{
	WSCbool flagBegin = Maivtim_BeginTimer->getProperty( WSNrunning );
	WSCbool flagMain = Maivtim_MainTimer->getProperty( WSNrunning );

	if( flagBegin || flagMain ){
		/* It's playing. */
		Maivbtn_StopBtn->setProperty( WSNlabelString, "||" );
		return true;
	} else {
		/* It's stopping. */
		Maivbtn_StopBtn->setProperty( WSNlabelString, ">" );
		return false;
	}
}

/**/

void CHeadLine::PrevThread( long nSkip )
{
	long idx = PrevThreadSub( nSkip );
	if( idx > 0 ){
		Update( -idx, true );
	} else {
		Update( -1, true );

		idx = PrevThreadSub( 1 );
		if( idx > 0 ){
			Update( -idx, true );
			NextThread( 1 );
		}
	}
}

/**/

long CHeadLine::PrevThreadSub( long nSkip )
{
	if( nSkip <= -1 )
		nSkip = -nSkip;

	WSCstring str = GetStr( mHeadLineCurN );

	WSCstring head = str;
	long posEnd = head.getWordCharPos( mWordIdx, mStrWordSep );
	head.cutString( posEnd );

	long maxN = head.getWords( mStrThreadSep );
	long n = maxN - nSkip;
	if( n < 1 )
		n = 1;

	long posBgn = head.getWordCharPos( n - 1, mStrThreadSep );
	head.deleteChars( 0, posBgn );

	return( head.getWords( mStrWordSep ) - 1 );
}

/**/

void CHeadLine::NextThread( long nSkip )
{
	if( nSkip <= -1 )
		nSkip = -nSkip;

	WSCstring str = GetStr( mHeadLineCurN );

	long posHead = str.getWordCharPos( mWordIdx, mStrWordSep );
	WSCstring head = str;
	head.deleteChars( 0, posHead );

	long posTmp = head.getWordCharPos( nSkip, mStrThreadSep );
	WSCstring tmp = head;
	tmp.cutString( posTmp );
	long idx = tmp.getWords( mStrWordSep ) - 1;

	if( idx < 1 )
		idx = 1;
	Update( +idx, true );
}

/**/

long CHeadLine::PrevUrl( void )
{
	IncHeadLineCurN( -1 );
	Update( 0, true );

	return mHeadLineCurN;
}

/**/

long CHeadLine::NextUrl( void )
{
	IncHeadLineCurN( +1 );
	Update( 0, true );

	return mHeadLineCurN;
}

/**/

long CHeadLine::SelectUrl( void )
{
	WSCstring name = Maicomb_NameList->getProperty( WSNlabelString );
	long n = gUrl.GetN( name );

	if( n > -1 ){
		Update( 0, true );
	}
	if( mHeadLineCurN != n ){
		mHeadLineCurN = n;
		Update( 0, true );
	}

	return mHeadLineCurN;
}

/**/

void CHeadLine::ResetUrlList( void )
{
	DeleteUrlListAll();

	for( long i = 0; gListUrl[i].url != NULL; i++ ){
		if( gListUrl[i].mes == NMesNull )
			break;

		AddUrlList( Mes( gListUrl[i].mes ),
			gListUrl[i].url,
			gListUrl[i].flagDown,
			gListUrl[i].encoding,
			gListUrl[i].skipArt
		);
	}
}

/**/

void CHeadLine::AddUrlList(
	WSCstring name,
	WSCstring url, bool flagDown, long encoding, long skipArt )
{
	if( !gUrl.Add( name, url, flagDown, encoding, skipArt ) )
		return;

	Maicomb_NameList->setProperty( WSNmenuItems, gUrl.GetList() );
	Maicomb_NameList->setProperty( WSNlabelString, name );

	mHeadLineCurN = 0;
	mHeadLineMaxN = gUrl.GetMaxN();

	if( mHeadLineMaxN <= 0 )
		return;

	long n = gUrl.GetN( name );

	WSCstring *newStr = new WSCstring;
	*newStr = MesHeadLineDefault;
	mStrHeadLine.add( newStr, n );

	bool *newFlag = new bool;
	*newFlag = false;
	mFlagDone.add( newFlag, n );
}

/**/

void CHeadLine::UpdateUrlList(
	WSCstring oldName, WSCstring name,
	WSCstring url, bool flagDown, long encoding, long skipArt )
{
	if( !gUrl.Update( oldName, name, url, flagDown, encoding, skipArt ) )
		return;

	long n = gUrl.GetN( name );
	if( n <= -1 )
		return;

	SetStr( n, MesHeadLineDefault );
	SetDone( n, false );

	mHeadLineMaxN = gUrl.GetMaxN();
	Maicomb_NameList->setProperty( WSNmenuItems, gUrl.GetList() );
	IncHeadLineCurN( +-0 );
}

/**/

void CHeadLine::DeleteUrlList( WSCstring name )
{
	long n = gUrl.GetN( name );
	if( n <= -1 )
		return;

	if( !gUrl.Delete( name ) )
		return;

	mStrHeadLine.delPos( n );
	mFlagDone.delPos( n );

	mHeadLineMaxN = gUrl.GetMaxN();
	Maicomb_NameList->setProperty( WSNmenuItems, gUrl.GetList() );
	IncHeadLineCurN( +-0 );
}

/**/

void CHeadLine::DeleteUrlListAll( void )
{
	for( long i = gUrl.GetMaxN() - 1; i >= 0; i-- )
		DeleteUrlList( gUrl.GetName( i ) );
}

/**/

bool CHeadLine::Swap( long n1, long n2 )
{
	if( !gUrl.Swap( n1, n2 ) )
		return false;

	mFlagDump = true;

	WSCstring *tmpStr = (WSCstring *)mStrHeadLine[n1];
	mStrHeadLine[n1] = mStrHeadLine[n2];
	mStrHeadLine[n2] = tmpStr;

	bool *tmpFlag = (bool *)mFlagDone[n1];
	mFlagDone[n1] = mFlagDone[n2];
	mFlagDone[n2] = tmpFlag;

	Maicomb_NameList->setProperty( WSNmenuItems, gUrl.GetList() );

	IncHeadLineCurN( +-0 );

	return true;
}

/**/

void CHeadLine::ResetConfigMisc( void )
{
	SetScroll( gDefaultScrollLen,
		gDefaultScrollSpeed, gDefaultScrollWait );
}

/**/

WSCstring CHeadLine::PickUp2ch( WSCstring html )
{
	WSCstring text;
	WSCstring strThreadBgn = "</a></div><b>";
	WSCstring strThreadEnd = "</font></b>";
	WSCstring strThread;
	WSCstring strBgn = "<dd>";
	WSCstring strEnd = "<dt>";
	WSCstring strBgnSkip = "<dd><";
	long lenBgn = strBgn.getChars();

	while( 1 ){
		if( html.getChars() <= 0 )
			break;

		/* I search tokens. */

		WSCstring tmp = html;
		tmp.to_lower();

		long idxThreadBgn = tmp.isExist( strThreadBgn );
		long idxBgn = tmp.isExist( strBgn );
		long idxEnd = tmp.isExist( strEnd );
		long idxBgnSkip = tmp.isExist( strBgnSkip );

		tmp.deleteChars( 0, lenBgn );
		long idxEnd2 = tmp.isExist( strBgn );
		if( idxEnd2 > -1 )
			idxEnd2 += lenBgn;

		if( idxBgn <= -1 )
			break;
		if( idxEnd > -1 ){
			if( idxEnd2 > -1 ){
				if( idxEnd2 < idxEnd ){
					/* There are beginning token */
					/* after beginning token. */

					idxEnd = idxEnd2;
				}
			}
		} else {
			if( idxEnd2 > -1 ){
				idxEnd = idxEnd2;
			} else {
				/* I can't find beginning token */
				/* and ending token. */

				break;
			}
		}

		if( (idxThreadBgn > -1) && (idxThreadBgn < idxBgn) ){
			strThread = html;
			long len = idxThreadBgn + strThreadBgn.getChars();
			strThread.deleteChars( 0, len );

			WSCstring tmp = strThread;
			tmp.to_lower();
			long idxThreadEnd = tmp.isExist( strThreadEnd );
			if( idxThreadEnd > -1){
				strThread.cutString( idxThreadEnd );
			} else {
				strThread.clear();
			}

			DelHtmlTag( &strThread, "<font", ">" );
		}

		if( idxEnd < idxBgn ){
			/* There are ending token */
			/* before beginning token. */

			html.deleteChars( 0, idxBgn );
			continue;
		}
		if( idxBgn == idxBgnSkip ){
			/* There are skipping token */

			html.deleteChars( 0, idxBgn + lenBgn );
			continue;
		}

		/* I cut HTML text from beginning token */
		/* to ending token. */

		WSCstring str = html;

		idxBgn += lenBgn;
		str.cutString( idxEnd );
		str.deleteChars( 0, idxBgn );

		if( strThread.getChars() > 0 ){
			if( text.getChars() > 0 ){
				text << mStrThreadSep;
			}
			text << strThread << mStrWordSep;

			strThread.clear();
		}

		text << str << mStrWordSep;

		/* I set HTML text to next position. */

		html.deleteChars( 0, idxEnd );
	}

	SleepSec( 2 );

	DelHtmlHref( &text );

	DelHtmlTag( &text, "<font", "</font>" );

	DelHtmlStr( &text, " <br> " );
	DelHtmlStr( &text, " <br>" );
	DelHtmlStr( &text, "<br> " );
	DelHtmlStr( &text, "<br>" );

	ConvHtmlMetaChar( &text );

	return text;
}

/**/

WSCstring CHeadLine::GetText( long nSkip )
{
	/* I skip articles */

	WSCstring str;
	for( long i = 0; i < 128; i++ ){
		mWordIdx += nSkip;

		if( mWordIdx >= mWordMaxIdx ){
			IncHeadLineCurN( +1 );
			mWordIdx = 0;
		}
		if( mWordIdx < 0 ){
			IncHeadLineCurN( -1 );
			mWordIdx = mWordMaxIdx - 1;
		}

		str = GetStr( mHeadLineCurN )
			.getWord( mWordIdx, mStrWordSep );

		if( str.getChars() <= -1 )
			continue;
		if( str == mStrThreadSepWord )
			continue;

		break;
	}

	str << "    ";

	return str;
}

/**/

WSCstring CHeadLine::SetText( long n, WSCstring str )
{
	if( (n < 0) || (n >= mHeadLineMaxN) )
		return "";

	SetStr( n, str );

	if( n == mHeadLineCurN )
		Update( 0, true );

	return str;
}

/**/

long CHeadLine::IncHeadLineCurN( long n )
{
	mWordIdx = 0;
	mWordMaxIdx = 1;

	if( mHeadLineMaxN <= 0 ){
		mHeadLineCurN = 0;

		return mHeadLineCurN;
	}

	mHeadLineCurN += n;
	mHeadLineCurN %= mHeadLineMaxN;
	mHeadLineCurN += mHeadLineMaxN;
	mHeadLineCurN %= mHeadLineMaxN;

	mWordMaxIdx = GetStr( mHeadLineCurN ).getWords( mStrWordSep );
	if( mWordMaxIdx <= 0 )
		mWordMaxIdx = 1;

	/* I Select URL list */

	WSCstring name = gUrl.GetName( mHeadLineCurN );
	Maicomb_NameList->setProperty( WSNlabelString, name );

	return mHeadLineCurN;
}

/**/

WSCstring CHeadLine::DelHtmlHref( WSCstring *html )
{
	if( html == NULL )
		return "";

	WSCstring strBgn1 = "<a href";
	WSCstring strEnd1 = "\"";
	WSCstring strBgn2 = "\"";
	WSCstring strEnd2 = "</a>";
	long lenBgn1 = strBgn1.getChars();
	long lenEnd1 = strEnd1.getChars();
	long lenBgn2 = strBgn2.getChars();
	long lenEnd2 = strEnd2.getChars();
	WSCstring strHead = "[";
	WSCstring strFoot = "]";

	while( 1 ){
		WSCstring tmp;

		/* Begin 1 */

		tmp = *html;
		tmp.to_lower();

		long idxBgn1 = tmp.isExist( strBgn1 );
		if( idxBgn1 <= -1 )
			break;

		/* End 1 */

		tmp = *html;
		tmp.to_lower();
		tmp.deleteChars( 0, idxBgn1 + lenBgn1 );

		long idxEnd1 = tmp.isExist( strEnd1 );
		if( idxEnd1 <= -1 )
			break;
		idxEnd1 += idxBgn1 + lenBgn1;

		/* Begin 2 */

		tmp = *html;
		tmp.to_lower();
		tmp.deleteChars( 0, idxEnd1 + lenEnd1 );

		long idxBgn2 = tmp.isExist( strBgn2 );
		if( idxBgn2 <= -1 )
			break;
		idxBgn2 += idxEnd1 + lenEnd1;

		/* End 2 */

		tmp = *html;
		tmp.to_lower();
		tmp.deleteChars( 0, idxBgn2 + lenBgn2 );

		long idxEnd2 = tmp.isExist( strEnd2 );
		if( idxEnd2 <= -1 )
			break;
		idxEnd2 += idxBgn2 + lenBgn2;

		/*  */

		if( idxBgn2 < idxBgn1 )
			continue;

		html->deleteChars( idxBgn2, (idxEnd2 - idxBgn2) + lenEnd2 );
		html->insertString( idxBgn2, strFoot );
		html->deleteChars( idxBgn1, (idxEnd1 - idxBgn1) + lenEnd1 );
		html->insertString( idxBgn1, strHead );
	}

	return *html;
}

/**/

WSCstring CHeadLine::DelHtmlTag(
	WSCstring *html,
	WSCstring strBgn, WSCstring strEnd )
{
	if( html == NULL )
		return "";

	strBgn.to_lower();
	strEnd.to_lower();

	long lenEnd = strEnd.getChars();

	while( 1 ){
		WSCstring tmp = *html;
		tmp.to_lower();

		long idxBgn = tmp.isExist( strBgn );
		if( idxBgn <= -1 )
			break;

		tmp = *html;
		tmp.to_lower();
		tmp.deleteChars( 0, idxBgn );

		long idxEnd = tmp.isExist( strEnd );
		if( idxEnd <= -1 )
			break;
		idxEnd += idxBgn;

		if( idxEnd < idxBgn )
			break;

		idxEnd += lenEnd;
		html->deleteChars( idxBgn, idxEnd - idxBgn );
	}

	return *html;
}

/**/

WSCstring CHeadLine::DelHtmlStr( WSCstring *html, WSCstring str )
{
	if( html == NULL )
		return "";

	str.to_lower();
	WSCstring tmp = *html;
	tmp.to_lower();

	while( 1 ){
		long idx = tmp.isExist( str );
		if( idx <= -1 )
			break;

		html->deleteChars( idx, str.getChars() );
		tmp.deleteChars( idx, str.getChars() );
	}

	return *html;
}

/**/

WSCstring CHeadLine::ConvHtmlMetaChar( WSCstring *html )
{
	if( html == NULL )
		return "";

	WSCstring listMeta[][2] = {
		{
			"&gt;",
			">",
		},
		{
			"&lt;",
			"<",
		},
		{
			"",
			"",
		},
	};

	for( long i = 0; i < 128; i++ ){
		if( listMeta[i][0].getChars() <= 0 ){
			break;
		}

		html->replaceString( listMeta[i][0], listMeta[i][1], 0 );
	}

	return *html;
}

/**/

void CHeadLine::UpdateDownText( void )
{
	if( mFlagDown ){
		SetText( mDownN, mStrDown );

		mFlagDown = false;
	}
}

/**/

void CHeadLine::SetDownText( long n, WSCstring str )
{
	while( mFlagDown ){
		SleepSec( 1 );
	}

	mDownN = n;
	mStrDown = str;
	mFlagDown = true;
}

/**/

void CHeadLine::SetScroll( long len, long speed, long wait )
{
	if( len > 0 )
		mScrollLen = len;

	if( speed > 0 ){
		mScrollSpeed = speed;

		Maivtim_MainTimer->setProperty(
			WSNinterval, speed * gSpeedOffset );
	}

	if( wait > 0 ){
		mScrollWait = wait;

		Maivtim_BeginTimer->setProperty(
			WSNinterval, wait * gSpeedOffset );
	}
}

/**/

long CHeadLine::GetScrollLen( void )
{
	return mScrollLen;
}

/**/

long CHeadLine::GetScrollSpeed( void )
{
	return mScrollSpeed;
}

/**/

long CHeadLine::GetScrollWait( void )
{
	return mScrollWait;
}

/**/

bool CHeadLine::Save( void )
{
	bool ret = true;

	if( !SaveMisc() )
		ret = false;
	if( !SaveUrl() )
		ret = false;

	return ret;
}

/**/

bool CHeadLine::SaveMisc( void )
{
	WSCstring str;
	str << STR_HEADER_CONF STR_VERSION_CONF << "\n";

	str << "scroll_chars = " << GetScrollLen() << "\n";
	str << "scroll_speed = " << GetScrollSpeed() << "\n";
	str << "scroll_wait = " << GetScrollWait() << "\n";
	str << "\n";

	str << "language = " << ::GetLangKind() << "\n";
	str << "\n";

	short left, top, width, height;

	left = MainWin->getProperty( WSNx );
	top = MainWin->getProperty( WSNy );
	width = MainWin->getProperty( WSNwidth );
	height = MainWin->getProperty( WSNheight );
	str << "main_win_left = " << left << "\n";
	str << "main_win_top = " << top << "\n";
	str << "main_win_width = " << width << "\n";
	str << "main_win_height = " << height << "\n";
	str << "\n";

	left = Misdial_ConfigMisc->getProperty( WSNx );
	top = Misdial_ConfigMisc->getProperty( WSNy );
	width = Misdial_ConfigMisc->getProperty( WSNwidth );
	height = Misdial_ConfigMisc->getProperty( WSNheight );
	str << "misc_win_left = " << left << "\n";
	str << "misc_win_top = " << top << "\n";
	str << "misc_win_width = " << width << "\n";
	str << "misc_win_height = " << height << "\n";
	str << "\n";

	left = Cnfdial_ConfigUrl->getProperty( WSNx );
	top = Cnfdial_ConfigUrl->getProperty( WSNy );
	width = Cnfdial_ConfigUrl->getProperty( WSNwidth );
	height = Cnfdial_ConfigUrl->getProperty( WSNheight );
	str << "url_win_left = " << left << "\n";
	str << "url_win_top = " << top << "\n";
	str << "url_win_width = " << width << "\n";
	str << "url_win_height = " << height << "\n";
	str << "\n";

	WSCstring fileName = ConvHomeFileName( CONF_FILE_NAME );

	long res = WSGFreplaceTextFile( fileName, str, false );
	if( res != WS_NO_ERR ){
		WSCstring mes;
		mes << MesSaveError << "\n(" << fileName << ")";

		PopupError( mes );
		return false;
	}

	return true;
}

/**/

bool CHeadLine::SaveUrl( void )
{
	WSCstring str;
	str << "\"\",\""
		<< "\",\""
		<< STR_HEADER_URL STR_VERSION_URL << "\",\""
		<< "\",\""
		<< "\",\""
		<< "\",\""
		<< "\"\n";

	for( long i = 0; i < gUrl.GetMaxN(); i++ ){
		long en = gUrl.GetEncoding( i );
		str << "\"\",\""
			<< gUrl.GetFlagDownload( i ) << "\",\""
			<< gUrl.GetName( i ) << "\",\""
			<< gUrl.GetUrl( i ) << "\",\""
			<< ConvEncodingToStr( en ) << "\",\""
			<< gUrl.GetSkipArt( i ) << "\",\""
			<< "\"\n";
	}

	WSCstring fileName = ConvHomeFileName( URL_FILE_NAME );

	long res = WSGFreplaceTextFile( fileName, str, false );
	if( res != WS_NO_ERR ){
		WSCstring mes;
		mes << MesSaveError << "\n(" << fileName << ")";

		PopupError( mes );
		return false;
	}

	return true;
}

/**/

bool CHeadLine::Load( void )
{
	bool ret = true;

	if( !LoadMisc() )
		ret = false;
	if( !LoadUrl() )
		ret = false;

	return ret;
}

/**/

bool CHeadLine::LoadMisc( void )
{
	WSCstring fileName = ConvHomeFileName( CONF_FILE_NAME );

	if( !WSGFcheckExistFile( fileName ) )
		return false;

	WSCstring *str = WSGFreadTextFile( fileName );
	WSCstring ver = str->getWord( 0, "\n" );

	if( ver.isExist(
		STR_HEADER_CONF_0_1_0
		STR_VERSION_CONF_0_1_0 )
		> -1 )
	{
		;
	} else if( CompareString( ver,
		STR_HEADER_CONF_0_1_1
		STR_VERSION_CONF_0_1_1 ) )
	{
		LoadMisc_0_1( fileName, str );
	} else {
		WSCstring mes;
		mes << MesLoadVerError << "\n(" << fileName << ")";

		PopupError( mes );
		return false;
	}

	return true;
}

/**/

bool CHeadLine::LoadMisc_0_1( WSCstring fileName, WSCstring *str )
{
	long strMaxLine = str->getWords( "\n" ) - 1;

	for( long i = 1; i < strMaxLine; i++ ){
		/* I split to lines. */

		WSCstring line = str->getWord( i, "\n" );

		line.delHeadSpace();
		line.delTailSpace();

		if( line[0] == '#' )
			continue;
		if( line.getChars() <= 0 )
			continue;

		/* I split to tokens. */

		WSCstring id = line.getWord( 0, "=" );
		WSCstring val = line.getWord( 1, "=" );

		id.delHeadSpace();
		id.delTailSpace();
		val.delHeadSpace();
		val.delTailSpace();

		if( id.getChars() <= 0 ){
			WSCstring mes;
			mes << MesLoadMiscError << "\n";
			mes << fileName << ": " << i << "\n";
			mes << "\"" << line << "\"";

			PopupError( mes );

			return false;
		}

		long n = strtol( val, NULL, 10 );
		if( CompareString( id, "language" ) ){
			SetMessage( (ELangKind)n );

		} else if( CompareString( id, "scroll_chars" ) ){
			SetScroll( n, 0, 0 );
		} else if( CompareString( id, "scroll_speed" ) ){
			SetScroll( 0, n, 0 );
		} else if( CompareString( id, "scroll_wait" ) ){
			SetScroll( 0, 0, n );

		} else if( CompareString( id, "main_win_left" ) ){
			MainWin->setProperty( WSNx, n );
		} else if( CompareString( id, "main_win_top" ) ){
			MainWin->setProperty( WSNy, n );
		} else if( CompareString( id, "main_win_width" ) ){
			MainWin->setProperty( WSNwidth, n );
		} else if( CompareString( id, "main_win_height" ) ){
			MainWin->setProperty( WSNheight, n );

		} else if( CompareString( id, "misc_win_left" ) ){
			Misdial_ConfigMisc->setProperty( WSNx, n );
		} else if( CompareString( id, "misc_win_top" ) ){
			Misdial_ConfigMisc->setProperty( WSNy, n );
		} else if( CompareString( id, "misc_win_width" ) ){
			Misdial_ConfigMisc->setProperty( WSNwidth, n );
		} else if( CompareString( id, "misc_win_height" ) ){
			Misdial_ConfigMisc->setProperty( WSNheight, n );

		} else if( CompareString( id, "url_win_left" ) ){
			Cnfdial_ConfigUrl->setProperty( WSNx, n );
		} else if( CompareString( id, "url_win_top" ) ){
			Cnfdial_ConfigUrl->setProperty( WSNy, n );
		} else if( CompareString( id, "url_win_width" ) ){
			Cnfdial_ConfigUrl->setProperty( WSNwidth, n );
		} else if( CompareString( id, "url_win_height" ) ){
			Cnfdial_ConfigUrl->setProperty( WSNheight, n );

		} else {
			WSCstring mes;
			mes << MesLoadMiscError << "\n";
			mes << fileName << ": " << i << "\n";
			mes << "ID: \"" << id << "\"" << "\n";
			mes << "N: \"" << val << "\"" << "\n";

			PopupError( mes );

			return false;
		}
	}

	return true;
}

/**/

bool CHeadLine::LoadUrl( void )
{
	WSCstring fileName = ConvHomeFileName( URL_FILE_NAME );

	if( !WSGFcheckExistFile( fileName ) )
		return false;

	WSCstring *str = WSGFreadTextFile( fileName );
	WSCstring header = str->getWord( 0, "\n" );
	WSCstring ver = header.getWord( 2, "\",\"" );

	DeleteUrlListAll();

	if( CompareString( ver,
		STR_HEADER_URL_0_1_0
		STR_VERSION_URL_0_1_0 ) )
	{
		LoadUrl_0_1( fileName, str );
	} else if( CompareString( ver,
		STR_HEADER_URL_0_1_1
		STR_VERSION_URL_0_1_1 ) )
	{
		LoadUrl_0_1( fileName, str );
	} else {
		WSCstring mes;
		mes << MesLoadVerError << "\n";
		mes << fileName << "\n";
		mes << "\"" << ver << "\"";

		PopupError( mes );
		return false;
	}

	return true;
}

/**/

bool CHeadLine::LoadUrl_0_1( WSCstring fileName, WSCstring *str )
{
	long strMaxLine = str->getWords( "\n" ) - 1;

	for( long i = strMaxLine - 1; i >= 1; i-- ){
		/* I split lines. */

		WSCstring line = str->getWord( i, "\n" );

		/* I split CSV data. */

		WSCstring tmpFlag = line.getWord( 1, "\",\"" );
		WSCstring name = line.getWord( 2, "\",\"" );
		WSCstring url = line.getWord( 3, "\",\"" );
		WSCstring tmpEn = line.getWord( 4, "\",\"" );
		WSCstring tmpSkipArt = line.getWord( 5, "\",\"" );

		if( name.getChars() < 1 )
			continue;

		/* Flag download */

		bool flagDown;
		if( CompareString( tmpFlag, "0" ) )
			flagDown = false;
		else
			flagDown = true;

		/* Encoding */

		long en = ConvStrToEncoding( tmpEn );

		/* Skip articles No. */

		long skipArt = strtol( tmpSkipArt, NULL, 10 );

		/* I add URL list. */

		AddUrlList( name, url, flagDown, en, skipArt );
	}

	delete str;

	return true;
}

/**/

void *BGDownLoad( void *arg )
{
	CHeadLine &hl = gHeadLine;

	while( 1 ){
		if( hl.mFlagDown ){
			SleepSec( 1 );
			continue;
		}

		WSCstring text;

		long curN = -1;
		long hlCurN = hl.mHeadLineCurN;
		long hlMaxN = hl.mHeadLineMaxN;
		long flagFirst = true;
		for( long i = hlMaxN - 1; i >= 0; i-- ){
			long j = (hlCurN + i) % hlMaxN;
			if( hlMaxN != hl.mHeadLineMaxN ){
				curN = -1;
				break;
			}
			if( hl.GetDone( j ) ){
				flagFirst = false;
			} else if( gUrl.GetFlagDownload( j ) ){
				curN = j;
			}
		}
		if( curN <= -1 ){
			SleepSec( 10 );
			continue;
		} else {
			hl.mDownN = curN;
		}

		WSCstring url = gUrl.GetUrl( curN );
		long encoding = gUrl.GetEncoding( curN );

		/* I am connecting a server. */

		text = MesDownLoadOpen;
		hl.SetDownText( curN, text );

		int sock = OpenSrvr( url, "http", 80 );
		if( sock <= -1 ){
			text = MesDownLoadOpenError;
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 2 );

		/* I am downloading from a server. */

		text = MesDownLoadRecv;
		hl.SetDownText( curN, text );

		WSCstring strHtml;
		if( !RecvSrvr( sock, url, &strHtml, encoding ) ){
			text = strHtml;
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 2 );

		/* I am disconnecting a server. */

		text = MesDownLoadClose;
		hl.SetDownText( curN, text );

		if( CloseSrvr( sock ) <= -1 ){
			text = MesDownLoadCloseError;
			hl.SetDownText( curN, text );

			continue;
		}

		SleepSec( 2 );

		/* I am converting data from HTML to text. */

		text = MesDownLoadPickUp;
		hl.SetDownText( curN, text );

		text = hl.PickUp2ch( strHtml );
		hl.SetDownText( curN, text );
		if( text.getChars() <= 0 ){
			text = MesDownLoadPickUpError;
			hl.SetDownText( curN, text );

			gUrl.SetFlagDownload( curN, false );

			continue;
		}

		SleepSec( 2 );

		/* Finish. */

		if( hl.mFlagDump ){
			hl.mFlagDump = false;
			continue;
		}

		hl.SetDone( curN, true );
		hl.mFlagDown = true;

		if( curN == hl.mHeadLineCurN ){
			hl.IncHeadLineCurN( +-0 );
			hl.Update( 0, true );
		}
		if( flagFirst ){
			hl.Play();
		}

		SleepSec( 10 );
	}

	return NULL;
}

/**/

CHeadLine gHeadLine;
