#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

/**/

#include "Common.h"

/**/

#include <WSCmessageDialog.h>

/**/

char	*gArrayMes[NMesMaxN];

typedef struct {
	NMes	n;
	char	*s;
} TMes;

static TMes	gAllLangMes[LANG_KIND_MAX_N][NMesMaxN] = {
	{
#include "MesEng.h"
	},
	{
#include "MesJpn.h"
	},
};

static bool gFlagMesDef[NMesMaxN];
ELangKind gLangKind;

/**/

void SetMessage( ELangKind nLang )
{
	gLangKind = nLang;

	for( NMes m = 0; m < NMesMaxN; m++ )
		gFlagMesDef[m] = false;

	for( NMes i = 0; i < NMesMaxN; i++ ){
		if( gAllLangMes[nLang][i].s == NULL )
			break;

		NMes m = gAllLangMes[nLang][i].n;
		if( gFlagMesDef[m] ){
			/* åƤ */
			WSCstring str;
			str << "Redefined message data:"
				<< " LANG=" << nLang
				<< " No.=" << m
				<< " `" << gAllLangMes[nLang][i].s << "'"
				;

			PopupError( str );
			exit( 1 );
		}
		gArrayMes[m] = gAllLangMes[nLang][i].s;
		gFlagMesDef[m] = true;
	}

	for( NMes m = 0; m < NMesMaxN; m++ ){
		if( !gFlagMesDef[m] ){
			/* åƤʤ */
			WSCstring str;
			str << "Don't defined message data:"
				<< " LANG=" << nLang
				<< " No.=" << m
				;

			PopupError( str );
			exit( 1 );
		}
	}

	SetLabel();
}

/**/

void SetMessage( WSCstring strLang )
{
	if( CompareString( strLang, MesLanguageEnglish ) ){
		SetMessage( LANG_KIND_ENGLISH );
	} else if( CompareString( strLang, MesLanguageJapanese ) ){
		SetMessage( LANG_KIND_JAPANESE );
	} else {
		;
	}
}

/**/

ELangKind GetLangKind( void )
{
	return gLangKind;
}

/**/

void SetLabel( void )
{
	Maivlab_Art->setProperty( WSNlabelString, MesLabelArt );
	Maivlab_Thr->setProperty( WSNlabelString, MesLabelThr );
	Maivlab_Site->setProperty( WSNlabelString, MesLabelSite );
	Maivbtn_PrevUrlBtn->setProperty( WSNlabelString, MesLabelSitePrev );
	Maivbtn_NextUrlBtn->setProperty( WSNlabelString, MesLabelSiteNext );
	Maivbtn_BarBtn->setProperty( WSNlabelString, MesLabelBar );

	Misvlab_Chars->setProperty( WSNlabelString, MesLabelChars );
	Misvlab_Speed->setProperty( WSNlabelString, MesLabelSpeed );
	Misvlab_Wait->setProperty( WSNlabelString, MesLabelWait );
	Misvlab_Language->setProperty( WSNlabelString, MesLabelLanguage );

	Cnfvlab_Name->setProperty( WSNlabelString, MesLabelName );
	Cnfvlab_Url->setProperty( WSNlabelString, MesLabelUrl );
	Cnfvtog_Download->setProperty( WSNlabelString, MesLabelDownload );
	Cnfvlab_Encoding->setProperty( WSNlabelString, MesLabelEncoding );
	Cnfvlab_SkipArt->setProperty( WSNlabelString, MesLabelSkipArt );

	Cnfvbtn_DeleteBtn->setProperty( WSNlabelString, MesLabelDelete );
	Cnfvbtn_UpdateBtn->setProperty( WSNlabelString, MesLabelUpdate );
	Cnfvbtn_NewBtn->setProperty( WSNlabelString, MesLabelNew );

	Cnfvlab_OrderTitle->setProperty( WSNlabelString, MesLabelOrder );
	Cnfvbtn_UpBtn->setProperty( WSNlabelString, MesLabelUp );
	Cnfvbtn_DownBtn->setProperty( WSNlabelString, MesLabelDown );
	Cnfvbtn_TopBtn->setProperty( WSNlabelString, MesLabelTop );
	Cnfvbtn_BottomBtn->setProperty( WSNlabelString, MesLabelBottom );
}

/**/

void PopupError( WSCstring str )
{
	PopupMesCommon( "ERROR: ", str );
}

/**/

void PopupWarning( WSCstring str )
{
	PopupMesCommon( "WARNING: ", str );
}

/**/

void PopupMessage( WSCstring str )
{
	PopupMesCommon( "", str );
}

/**/

void PopupMesCommon( WSCstring strMesType, WSCstring str )
{
	WSCstring mes;
	mes << strMesType << str;

	WSCmessageDialog *dlg = WSGIappMessageDialog();
	dlg->setProperty( WSNlabelString, mes );
	dlg->popup();
}

/**/

