#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

/**/

#include "Common.h"

/**/

void CUrl::Init( void )
{
}

/**/

bool CUrl::Add(
	WSCstring name,
	WSCstring url, bool flagDown, long encoding, long skipArt )
{
	/* If new name is exist already then it's error */
	if( GetN( name ) > -1 ){
		WSCstring strErr;
		strErr << MesUrlExistNameError
			<< "\n\"" << name << "\"";
		PopupError( strErr );

		return false;
	}

	WSCstring *newName = new WSCstring;
	WSCstring *newUrl = new WSCstring;
	bool *newFlagDown = new bool;
	long *newEncoding = new long;
	long *newSkipArt = new long;

	*newName = name;
	*newUrl = url;
	*newFlagDown = flagDown;
	*newEncoding = encoding;
	*newSkipArt = skipArt;

	mStrName.add( newName, 0 );
	mStrUrl.add( newUrl, 0 );
	mFlagDownload.add( newFlagDown, 0 );
	mEncoding.add( newEncoding, 0 );
	mSkipArt.add( newSkipArt, 0 );

	return true;
}

/**/

bool CUrl::Update(
	WSCstring oldName, WSCstring name,
	WSCstring url, bool flagDown, long encoding, long skipArt )
{
	if( !CompareString( name, oldName ) ){
		/* If new name is exist already then it's error */
		if( GetN( name ) > -1 ){
			WSCstring strErr;
			strErr << MesUrlExistNameError
				<< "\n\"" << oldName
				<< "\" -> \"" << name << "\"";
			PopupError( strErr );

			return false;
		}
	}

	/* If old name isn't exist then it's error */
	long n = GetN( oldName );
	if( n <= -1 ){
		WSCstring strErr;
		strErr << MesUrlNotExistNameError
			<< "\n\"" << oldName << "\"";
		PopupError( strErr );

		return false;
	}

	SetName( n, name );
	SetUrl( n, url );
	SetFlagDownload( n, flagDown );
	SetEncoding( n, encoding );
	SetSkipArt( n, skipArt );

	return true;
}

/**/

bool CUrl::Delete( WSCstring name )
{
	/* If name isn't exist then it's error */
	long n = GetN( name );
	if( n <= -1 ){
		WSCstring strErr;
		strErr << MesUrlNotExistNameError
			<< "\n\"" << name << "\"";
		PopupError( strErr );

		return false;
	}

	mStrName.delPos( n );
	mStrUrl.delPos( n );
	mFlagDownload.delPos( n );
	mEncoding.delPos( n );
	mSkipArt.delPos( n );

	return true;
}

/**/

bool CUrl::Swap( long n1, long n2 )
{
	if( n1 < 0 )
		return false;
	if( n2 < 0 )
		return false;
	if( n1 >= GetMaxN() )
		return false;
	if( n2 >= GetMaxN() )
		return false;

	WSCstring *tmpName = (WSCstring *)mStrName[n1];
	WSCstring *tmpUrl = (WSCstring *)mStrUrl[n1];
	bool *tmpFlag = (bool *)mFlagDownload[n1];
	long *tmpEncoding = (long *)mEncoding[n1];
	long *tmpSkipArt = (long *)mSkipArt[n1];

	mStrName[n1] = mStrName[n2];
	mStrUrl[n1] = mStrUrl[n2];
	mFlagDownload[n1] = mFlagDownload[n2];
	mEncoding[n1] = mEncoding[n2];
	mSkipArt[n1] = mSkipArt[n2];

	mStrName[n2] = tmpName;
	mStrUrl[n2] = tmpUrl;
	mFlagDownload[n2] = tmpFlag;
	mEncoding[n2] = tmpEncoding;
	mSkipArt[n2] = tmpSkipArt;

	return true;
}

/**/

long CUrl::GetN( WSCstring name )
{
	for( long i = 0; i < GetMaxN(); i++ )
		if( CompareString( GetName( i ), name ) )
			return i;

	return -1;
}

/**/

WSCstring CUrl::GetList( void )
{
	WSCstring list;
	for( long i = 0; i < GetMaxN(); i++ ){
		list << GetName( i );

		if( (i + 1) < GetMaxN() ){
			list << ",";
		}
	}

	return list;
}

/**/

WSCstring CUrl::GetName( long n )
{
	if( n < 0 )
		return "";
	if( n >= GetMaxN() )
		return "";

	if( mStrName[n] == NULL )
		return "";

	return( *((WSCstring *)(mStrName[n])) );
}

/**/

WSCstring CUrl::SetName( long n, WSCstring name )
{
	if( n < 0 )
		return "";
	if( n >= GetMaxN() )
		return "";

	if( mStrName[n] == NULL )
		return "";

	*((WSCstring *)(mStrName[n])) = name;

	return( *((WSCstring *)(mStrName[n])) );
}

/**/

WSCstring CUrl::GetUrl( WSCstring name )
{
	return GetUrl( GetN( name ) );
}

/**/

WSCstring CUrl::GetUrl( long n )
{
	if( n < 0 )
		return( "" );
	if( n >= GetMaxN() )
		return( "" );

	if( mStrUrl[n] == NULL )
		return( "" );

	return( *((WSCstring *)(mStrUrl[n])) );
}

/**/

WSCstring CUrl::SetUrl( WSCstring name, WSCstring url )
{
	return( SetUrl( GetN( name ), url ) );
}

/**/

WSCstring CUrl::SetUrl( long n, WSCstring url )
{
	if( n < 0 )
		return false;
	if( n >= GetMaxN() )
		return false;

	if( mStrUrl[n] == NULL )
		return false;

	*((WSCstring *)(mStrUrl[n])) = url;
	return( *((WSCstring *)(mStrUrl[n])) );
}

/**/

bool CUrl::GetFlagDownload( WSCstring name )
{
	return GetFlagDownload( GetN( name ) );
}

/**/

bool CUrl::GetFlagDownload( long n )
{
	if( n < 0 )
		return false;
	if( n >= GetMaxN() )
		return false;

	if( mFlagDownload[n] == NULL )
		return( "" );

	return( *((bool *)(mFlagDownload[n])) );
}

/**/

bool CUrl::SetFlagDownload( WSCstring name, bool flag )
{
	return( SetFlagDownload( GetN( name ), flag ) );
}

/**/

bool CUrl::SetFlagDownload( long n, bool flag )
{
	if( n < 0 )
		return false;
	if( n >= GetMaxN() )
		return false;

	if( mFlagDownload[n] == NULL )
		return false;

	*((bool *)(mFlagDownload[n])) = flag;
	return( *((bool *)(mFlagDownload[n])) );
}

/**/

long CUrl::GetEncoding( WSCstring name )
{
	return GetEncoding( GetN( name ) );
}

/**/

long CUrl::GetEncoding( long n )
{
	if( n < 0 )
		return WS_EN_DEFAULT;
	if( n >= GetMaxN() )
		return WS_EN_DEFAULT;

	if( mEncoding[n] == NULL )
		return WS_EN_DEFAULT;

	return( *((long *)(mEncoding[n])) );
}

/**/

long CUrl::SetEncoding( WSCstring name, long en )
{
	return( SetEncoding( GetN( name ), en ) );
}

/**/

long CUrl::SetEncoding( long n, long en )
{
	if( n < 0 )
		return WS_EN_DEFAULT;
	if( n >= GetMaxN() )
		return WS_EN_DEFAULT;

	if( mEncoding[n] == NULL )
		return WS_EN_DEFAULT;

	*((long *)(mEncoding[n])) = en;
	return( *((long *)(mEncoding[n])) );
}

/**/

long CUrl::GetSkipArt( WSCstring name )
{
	return GetSkipArt( GetN( name ) );
}

/**/

long CUrl::GetSkipArt( long n )
{
	if( n < 0 )
		return gSkipArtMaxN;
	if( n >= GetMaxN() )
		return gSkipArtMaxN;

	if( mSkipArt[n] == NULL )
		return gSkipArtMaxN;

	return( *((long *)(mSkipArt[n])) );
}

/**/

long CUrl::SetSkipArt( WSCstring name, long artN )
{
	return( SetSkipArt( GetN( name ), artN ) );
}

/**/

long CUrl::SetSkipArt( long n, long artN )
{
	if( n < 0 )
		return gSkipArtMaxN;
	if( n >= GetMaxN() )
		return gSkipArtMaxN;

	if( mSkipArt[n] == NULL )
		return gSkipArtMaxN;

	*((long *)(mSkipArt[n])) = artN;
	return( *((long *)(mSkipArt[n])) );
}

/**/

CUrl gUrl;

/**/

