/*============================================================================*
 *  $Id: damain.c,v 1.10 2004/08/01 09:21:15 mrsa Exp $
 *
 *  FILE: 
 *     damain.c
 *
 *  Description: 
 *     DAAvP[V
 *
 *===========================================================================*/
/********** Include Files **********/
#include "local.h"

void DAmain(void);
Err  SendToLocalMemopad(Char *title, Char *data);

#ifdef DEBUG_LOCALHOST_ADDRESS
#define  DEBUG_ADDRESS  "localhost"
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS
 
/*=========================================================================*/
/*   Function : startDA  (DAX^[gAbv)                                */
/*                                                                         */
/*=========================================================================*/
void startDA(void)
{
    FormType *frm;

    frm = FrmGetActiveForm();
    DAmain();
    FrmSetActiveForm(frm);

    return;
}

/*=========================================================================*/
/*   Function : DAmain  (DAC)                                     */
/*                                                                         */
/*=========================================================================*/
void DAmain(void)
{
    UInt16            size;
    NNshSavedPref    *NNshParam;
    NNshWorkingInfo  *NNshGlobal;

    //////////////////////////////////////////////////////////////////////////
    /////     Niݒ̕ۑj
    //////////////////////////////////////////////////////////////////////////
    // NNsiݒpi[̈̊m
    size      = sizeof(NNshSavedPref) + DBSIZE_SETTING;
    NNshParam = (NNshSavedPref *) MemPtrNew(size);
    if (NNshParam == NULL)
    {
        // ̈mۂɎsI(NȂ)
        FrmCustomAlert(ALTID_INFO, "Cannot Launch ",  "(DA)", " param");
        return;
    }        
    MemSet(NNshParam, size, 0x00);

    // NNsiO[öpi[̈̊m
    size       = sizeof(NNshWorkingInfo) + MARGIN;
    NNshGlobal = (NNshWorkingInfo *) MemPtrNew(size);
    if (NNshGlobal == NULL)
    {
        // ̈mۂɎsI(NȂ)
        FrmCustomAlert(ALTID_INFO, "Cannot Launch ",  "(DA)", " global");
        MEMFREE_PTR(NNshParam);
        return;
    }        
    MemSet(NNshGlobal, size, 0x00);

    // OSo[W̊mF
    FtrGet(sysFtrCreator, sysFtrNumROMVersion, &(NNshGlobal->palmOSVersion));

    // PalmOS v5.20ꍇɂ͋NȂ
    if (NNshGlobal->palmOSVersion < 0x05200000)
    {
        FrmCustomAlert(ALTID_INFO, "USE a PalmOS 5.2(or later)."," ","[mlDA]");
        return;
    }

    // NNsiݒ𕜋
    RestoreSetting_NNsh(sizeof(NNshSavedPref), NNshParam);

    //////////////////////////////////////////////////////////////////////////
    /////     ʃI[vic`̃Cj
    //////////////////////////////////////////////////////////////////////////

    //   Auto Exec.(s)Ƀ`FbNĂȂꍇɂ́AݒEBhE
    // \
    if (NNshParam->confirmationDisable == 0)
    {
        if (FrmGetActiveFormID() != 0)
        {
            NNshGlobal->previousForm = FrmGetActiveForm();
        }
        else
        {
            NNshGlobal->previousForm = NULL;
        }
        NNshGlobal->currentForm  = FrmInitForm(FRMID_MAIN);
        // FrmSetActiveForm(NNshGlobal->currentForm);

        if (StrLen(NNshParam->password) == 0)
        {
            CtlSetLabel(FrmGetObjectPtr(NNshGlobal->currentForm, 
                                   FrmGetObjectIndex(NNshGlobal->currentForm, 
                                                           SELTRID_PASSWORD)), 
                        "(Empty)");
        }
        else
        {
            CtlSetLabel(FrmGetObjectPtr(NNshGlobal->currentForm, 
                                    FrmGetObjectIndex(NNshGlobal->currentForm,
                                                           SELTRID_PASSWORD)),
                        "* * *");
        }
        NNshWinSetPopItems (NNshGlobal->currentForm,
                            POPTRID_PROTOCOL, LSTID_PROTOCOL,
                            NNshParam->protocol);
        NNshWinSetFieldText(NNshGlobal->currentForm,
                            FLDID_USER,     NNshParam->userName, BUFSIZE);
        NNshWinSetFieldText(NNshGlobal->currentForm,
                            FLDID_PASSWORD, NNshParam->password, BUFSIZE);

        // ؒf̐ݒ
        CtlSetValue(FrmGetObjectPtr(NNshGlobal->currentForm,
                                  FrmGetObjectIndex(NNshGlobal->currentForm,
                                                           CHKID_DISCONNECT)),
                    (UInt16) (NNshParam->disconnect));

        // Cxgnh̐ݒ
        FrmSetEventHandler(NNshGlobal->currentForm, Handler_MainForm);
        NNshGlobal->btnId = FrmDoDialog(NNshGlobal->currentForm);
        if (NNshGlobal->btnId == BTNID_DIALOG_OK)
        {
            NNshWinGetFieldText(NNshGlobal->currentForm, FLDID_USER,
                                NNshParam->userName, BUFSIZE);
            NNshWinGetFieldText(NNshGlobal->currentForm, FLDID_PASSWORD,
                                NNshParam->password, BUFSIZE);

            // s̃`FbN
            NNshParam->confirmationDisable = (UInt8)
                 CtlGetValue(FrmGetObjectPtr(NNshGlobal->currentForm,
                                    FrmGetObjectIndex(NNshGlobal->currentForm,
                                                              CHKID_CONFIRM)));
            // ؒf
            NNshParam->disconnect =
                 CtlGetValue(FrmGetObjectPtr(NNshGlobal->currentForm,
                                    FrmGetObjectIndex(NNshGlobal->currentForm,
                                                           CHKID_DISCONNECT)));
            // ʐMvgR̔f
            NNshParam->protocol = 
                 LstGetSelection(FrmGetObjectPtr(NNshGlobal->currentForm,
                                    FrmGetObjectIndex(NNshGlobal->currentForm,
                                                             LSTID_PROTOCOL)));
        }
        // tH[̍폜
        if (NNshGlobal->previousForm != NULL)
        {
            FrmSetActiveForm(NNshGlobal->previousForm);
        }
        FrmDeleteForm(NNshGlobal->currentForm);
    }
    else
    {
        // sɂ́AOCs
        NNshGlobal->btnId = BTNID_DIALOG_OK;
    }

    //////////////////////////////////////////////////////////////////////////
    // OC̎s
    //////////////////////////////////////////////////////////////////////////
    if (NNshGlobal->btnId == BTNID_DIALOG_OK)
    {
        // Mobt@̊m
        NNshGlobal->sendBuf = MemPtrNew(NNshParam->bufferSize);
        if (NNshGlobal->sendBuf == NULL)
        {
            // ̈mێsAI
            goto FUNC_END;
        }
        MemSet(NNshGlobal->sendBuf, NNshParam->bufferSize, 0x00);
        NNshGlobal->recvBuf = MemPtrNew(NNshParam->bufferSize);
        if (NNshGlobal->recvBuf == NULL)
        {
            // ̈mێsAI
            MEMFREE_PTR(NNshGlobal->sendBuf);
            goto FUNC_END;
        }
        MemSet(NNshGlobal->recvBuf, NNshParam->bufferSize, 0x00);

        NNshGlobal->workBuf = MemPtrNew(((NNshParam->bufferSize) / 2));
        if (NNshGlobal->workBuf == NULL)
        {
            // ̈mێsAI
            MEMFREE_PTR(NNshGlobal->sendBuf);
            MEMFREE_PTR(NNshGlobal->recvBuf);
            goto FUNC_END;
        }
        MemSet(NNshGlobal->workBuf, ((NNshParam->bufferSize) / 2), 0x00);

        // BUSYEBhE\
        Show_BusyForm(NNshParam->hostName, NNshGlobal);    

        MemSet (NNshGlobal->tempBuf, BUFSIZE, 0x00);

        // HotSpotɃOC鏈{
        doLogin_HotSpot(NNshParam, NNshGlobal);

        // ؒf(w莞)
        if (NNshParam->disconnect != 0)
        {
            // BUSYEBhE̕\ύX
            SetMsg_BusyForm(MSG_DISCONNECT);
            NNshNet_LineHangup();
        }
        // BUSYEBhEB
        Hide_BusyForm(NNshGlobal);

        // obt@NA
        MemSet(NNshGlobal->sendBuf, NNshParam->bufferSize, 0x00);

        // R[h̕\
        if (NNshGlobal->err == errNone)
        {
            // OCɐ
            StrCopy(NNshGlobal->sendBuf, MSG_SUCCESSLOGIN);
        }
        else
        {
            // G[
            StrCopy(NNshGlobal->sendBuf, MSG_ERROR);
        }

        // ʃ_CAO\
        if (FrmGetActiveFormID() != 0)
        {
            NNshGlobal->previousForm = FrmGetActiveForm();
        }
        else
        {
            NNshGlobal->previousForm = NULL;
        }
        NNshGlobal->currentForm  = FrmInitForm(FRMID_RESULT);
        // FrmSetActiveForm   (NNshGlobal->currentForm);

	// (OCʂt)
        NNshGlobal->tempPtr = StrStr(NNshGlobal->recvBuf, "\r\n\r\n");
        if (NNshGlobal->tempPtr == NULL)
        {
            // Mobt@̐擪\
            NNshGlobal->tempPtr = NNshGlobal->recvBuf;
        }
        else
        {
            // sR[h("\r\n\r\n")|C^i߂
            NNshGlobal->tempPtr = NNshGlobal->tempPtr + 4;
        }
        // tB[hɎMʂ\
        if ((StrLen(NNshGlobal->tempPtr) + StrLen(NNshGlobal->sendBuf)) <
            (NNshParam->bufferSize - 1))
        {
            NNshGlobal->err = StrLen(NNshGlobal->tempPtr);
        }
        else
        {
            NNshGlobal->err =
                     NNshParam->bufferSize - (StrLen(NNshGlobal->sendBuf) - 2);
        }
        StrNCopy(&NNshGlobal->sendBuf[StrLen(NNshGlobal->sendBuf)],
                 NNshGlobal->tempPtr, NNshGlobal->err);
        NNshWinSetFieldText(NNshGlobal->currentForm, FLDID_INFOFIELD,
                            NNshGlobal->sendBuf, StrLen(NNshGlobal->sendBuf));

        FrmSetEventHandler(NNshGlobal->currentForm, Handler_MainForm);
        (void) FrmDoDialog(NNshGlobal->currentForm);

        // tH[̍폜
        if (NNshGlobal->previousForm != NULL)
        {
            FrmSetActiveForm(NNshGlobal->previousForm);
        }
        FrmDeleteForm(NNshGlobal->currentForm);

        // Mobt@̉
        MEMFREE_PTR(NNshGlobal->recvBuf);
        MEMFREE_PTR(NNshGlobal->sendBuf);
        MEMFREE_PTR(NNshGlobal->workBuf);

    }
FUNC_END:
    //////////////////////////////////////////////////////////////////////////
    /////     Iiݒ̕ۑj
    //////////////////////////////////////////////////////////////////////////

    // ݒ̕ۑ
    SaveSetting_NNsh(sizeof(NNshSavedPref), NNshParam);

    // ̈J
    MEMFREE_PTR(NNshParam);    
    MEMFREE_PTR(NNshGlobal);

    return;
}

/*=========================================================================*/
/*   Function : Handler_EditAction                                         */
/*                                        ҏWj[Iꂽ̏ */
/*=========================================================================*/
Boolean Handler_EditAction(EventType *event)
{
    FormType  *frm;
    FieldType *fldP;
    UInt16     frmId;
    
    // IĂtB[hǂ`FbN
    frm   = FrmGetActiveForm();
    frmId = FrmGetFocus(frm);
    if (frmId == noFocus)
    { 
        // tH[JXIĂȂ̂ŁAԂ
        return (false);
    }
    if (FrmGetObjectType(frm, frmId) != frmFieldObj)
    {
        // ItB[hł͂Ȃ̂ŁAԂ
        return (false);
    }
    fldP = FrmGetObjectPtr(frm, frmId);

    // ҏWj[{
    switch (event->data.menu.itemID)
    {
      case MNUID_EDIT_UNDO:
        FldUndo(fldP);
        break;
      case MNUID_EDIT_CUT:
        FldCut(fldP);
        break;
      case MNUID_EDIT_COPY:
        FldCopy(fldP);
        break;
      case MNUID_EDIT_PASTE:
        FldPaste(fldP);
        break;
      case MNUID_SELECT_ALL:
        FldSetSelection(fldP, 0, FldGetTextLength(fldP));
        break;
      default:
        // ȂɂȂAƂRRɂ͗Ȃ
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   Hander_MainForm                                          */
/*                                       Cxgnh(ݒtH[p)  */
/*=========================================================================*/
Boolean Handler_MainForm(EventType *event)
{
    FieldType *fldP;
    UInt16    itemId;
    Char     *area;

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        itemId = event->data.menu.itemID;
        break;

      // L[
      case keyDownEvent:
        itemId = event->data.keyDown.chr;
        break;

      // ʃ^bv
      case ctlSelectEvent:
        itemId = event->data.ctlSelect.controlID;
        break;

     case penDownEvent:
     default: 
        return (false);
        break;
    }
    switch (itemId)
    {
      case MNUID_VERSION:
        // o[W\
        ShowVersion_NNsh();
        break;

      case SELTRID_PASSWORD:
        // pX[h
        area = MemPtrNew(BUFSIZE * 2);
        if (area == NULL)
        {
            return (true);
        }
        MemSet(area, (BUFSIZE * 2), 0x00);
        NNshWinGetFieldText(FrmGetActiveForm(), FLDID_PASSWORD,
                                                          area, (BUFSIZE * 2));
        if (InputDialog("Input Password", area, (BUFSIZE * 2)) == true)
        {
            NNshWinSetFieldText(FrmGetActiveForm(), FLDID_PASSWORD, area,
                                                                (BUFSIZE * 2));

        }
        if (StrLen(area) == 0)
        {
            CtlSetLabel(FrmGetObjectPtr(FrmGetActiveForm(), 
                                        FrmGetObjectIndex(FrmGetActiveForm(),
                                                          SELTRID_PASSWORD)), 
                        "(Empty)");
        }
        else
        {
            CtlSetLabel(FrmGetObjectPtr(FrmGetActiveForm(), 
                                        FrmGetObjectIndex(FrmGetActiveForm(),
                                                          SELTRID_PASSWORD)), 
                        "* * *");
        }
        MEMFREE_PTR(area);
        break;

      case vchrPageDown:
      case chrDownArrow:
      case vchrJogDown:
        // XN[
        if (FrmGetActiveFormID() == FRMID_RESULT)
        {
          fldP = FrmGetObjectPtr(FrmGetActiveForm(), 
                                 FrmGetObjectIndex(FrmGetActiveForm(),
                                                   FLDID_INFOFIELD));
          FldScrollField(fldP, 5, winDown);
        }
        break;

      case vchrPageUp:
      case chrUpArrow:
      case vchrJogUp:
        // XN[
        if (FrmGetActiveFormID() == FRMID_RESULT)
        {
          fldP = FrmGetObjectPtr(FrmGetActiveForm(), 
                                 FrmGetObjectIndex(FrmGetActiveForm(),
                                                   FLDID_INFOFIELD));
          FldScrollField(fldP, 5, winUp);
        }
        break;

      case BTNID_DIALOG_OK:
      case BTNID_DIALOG_CANCEL:
      default:
        return (false);
        break;
    }
    return (true);
}

/*=========================================================================*/
/*   Function :   NNshRestoreNNsiSetting                                   */
/*                                                     NNsiݒ̓ǂݍ  */
/*=========================================================================*/
void RestoreSetting_NNsh(UInt16 size, NNshSavedPref *prm)
{
    Err           ret;
    UInt32        offset;
    UInt16        cnt, nofRec;
    DmOpenRef     dbRef;
    Char         *ptr;

    // NNsiݒ̗̈
    nofRec = 0;

    if (size == sizeof(NNshSavedPref))
    {
        //  ݒ肳ꂽo[WƍNꂽo[Wэ\̃TCY
        // ꍇ̂݁ANNsiݒ𕜋B

        // ϐ 
        offset = 0;
        ptr    = (Char *) prm;

        // caANNsiݒǂݏo(R[h̓o^̌ˍŁAAA)
        OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
        GetDBCount_NNsh(dbRef, &nofRec);
        cnt = nofRec;
        while ((cnt != 0)&&(offset < sizeof(NNshSavedPref)))
        {
            ret = GetRecord_NNsh(dbRef,(cnt - 1),DBSIZE_SETTING, &ptr[offset]);
            if (ret != errNone)
            {
                // f[^ǂݏoɎs(̏ꍇANNsiݒ͏)
                nofRec = 0;
                break;
            }
            cnt--;
            offset = offset + DBSIZE_SETTING;
        }
        CloseDatabase_NNsh(dbRef);
    }
    if (nofRec == 0)
    {
        // ݒ
        prm->useKey.key1      = vchrHard1;
        prm->useKey.key2      = vchrHard2;
        prm->useKey.key3      = vchrHard3;
        prm->useKey.key4      = vchrHard4;
        prm->bufferSize       = WORKBUF_DEFAULT;
        prm->portNum          = 110;     // POP3|[gԍ
        prm->timeout          = SysTicksPerSecond() * NNSH_GETMAIL_TIMEOUT;
    }
    return;
}
/*-------------------------------------------------------------------------*/
/*   Function :   NNshSaveNNsiSetting                                      */
/*                                                         NNsiݒ̋L  */
/*-------------------------------------------------------------------------*/
void SaveSetting_NNsh(UInt16 size, NNshSavedPref *param)
{
    Err       ret;
    UInt32    offset;
    UInt16    nofRec;
    DmOpenRef dbRef;
    Char      *ptr;

    OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
    GetDBCount_NNsh(dbRef, &nofRec);
    while (nofRec != 0)
    {
        //  łNNsiݒ肪L^ĂꍇASR[h폜
        (void) DeleteRecordIDX_NNsh(dbRef, (nofRec - 1));
        nofRec--;
    }

    // NNsiݒDBɓo^(R[ho^̌ˍɒӁI)
    offset = 0;
    ptr    = (Char *) param;
    while (offset < sizeof(NNshSavedPref))
    {
        ret = EntryRecord_NNsh(dbRef, DBSIZE_SETTING, &ptr[offset]);
        if (ret != errNone)
        {
            break;
        }
        offset = offset + DBSIZE_SETTING;
    }
    CloseDatabase_NNsh(dbRef);

    return;
}


/*-------------------------------------------------------------------------*/
/*   Function : aplCompareF                                                */
/*                                                (\[eBOpr֐) */
/*                         DBotheroCgڂɁuŁvkey  */
/*                                                         ̂ƂB*/
/*-------------------------------------------------------------------------*/
static Int16 aplCompareF_Char(void *rec1, void *rec2, Int16 other,
                              SortRecordInfoPtr       rec1SortInfo,
                              SortRecordInfoPtr       rec2SortInfo, 
                              MemHandle               appInfoH)
{
    Char *str1, *str2;

    str1 = ((Char *) rec1) + other;
    str2 = ((Char *) rec2) + other;
    return (StrCompare(str1, str2));
}

/*-------------------------------------------------------------------------*/
/*   Function : aplCompareF_UInt32                                         */
/*                                                (\[eBOpr֐) */
/*                         DBotheroCgڂɁuUInt32Łvkey  */
/*                                                         ̂ƂB*/
/*-------------------------------------------------------------------------*/
static Int16 aplCompareF_UInt32(void *rec1, void *rec2, Int16 other,
                                SortRecordInfoPtr       rec1SortInfo,
                                SortRecordInfoPtr       rec2SortInfo, 
                                MemHandle               appInfoH)
{
    Char   *loc1,  *loc2;
    UInt32 *data1, *data2;

    loc1  = ((Char *) rec1) + other;
    loc2  = ((Char *) rec2) + other;

    data1 = (UInt32 *) loc1;
    data2 = (UInt32 *) loc2;

    return (*data1 - *data2);
}

/*-------------------------------------------------------------------------*/
/*   Function : aplCompareF_UInt16                                         */
/*                                                (\[eBOpr֐) */
/*                     key擪otheroCgڂuUInt16Łv  */
/*                                                         ̂ƂB*/
/*-------------------------------------------------------------------------*/
static Int16 aplCompareF_UInt16(void *rec1, void *rec2, Int16 other,
                                SortRecordInfoPtr       rec1SortInfo,
                                SortRecordInfoPtr       rec2SortInfo, 
                                MemHandle               appInfoH)
{
    Char   *loc1,  *loc2;
    UInt16 *data1, *data2;

    loc1  = ((Char *) rec1) + other;
    loc2  = ((Char *) rec2) + other;

    data1 = (UInt16 *) loc1;
    data2 = (UInt16 *) loc2;

    return (*data1 - *data2);
}

/*-------------------------------------------------------------------------*/
/*   Function : searchRecordSub                                            */
/*                                                        (R[h) */
/*-------------------------------------------------------------------------*/
static Err searchRecordSub(DmOpenRef dbRef, void *target, UInt16 keyType, 
                           UInt16   offset, UInt16 *idx,  MemHandle *hnd)
{
    UInt16     nofData, start, end, mid;
    Int16      chk;
    MemHandle  dataH;
    Char      *data;

    // 镶LXg
    data = (Char *)target;
    data = data + offset;

    // f[^[猟s
    nofData = DmNumRecords(dbRef);
    if (nofData == 0)
    {
        return (~errNone - 5);
    }

    // QŎw肳ꂽf[^o^Ă邩`FbN
    mid   = 0;
    start = 0;
    end   = nofData;
    while (start <= end)
    {
        mid = start + (end - start) / 2;
        dataH = DmQueryRecord(dbRef, mid);
        if (dataH == 0)
        {
            // ȂI (Ŕ͗l)
            return (~errNone);
        }

        // w肳ꂽL[ɂāA`FbN@ς
        data = (Char *) MemHandleLock(dataH);
        switch (keyType)
        {
          case NNSH_KEYTYPE_UINT32:
            chk  = *((UInt32 *) data) - *((UInt32 *) target);
            break;

          case NNSH_KEYTYPE_UINT16:
            chk  = *((UInt16 *) data) - *((UInt16 *) target);
            break;

          case NNSH_KEYTYPE_CHAR:
          default:
            chk  = StrCompare(data, (Char *) target);
            break;
        }
        if (chk == 0)
        {
            // I(f[^܂邲ƃRs[)
            MemHandleUnlock(dataH);
            *idx  = mid;
            *hnd  = dataH;
            return (errNone);
        }
        MemHandleUnlock(dataH);
        if (chk < 0)
        {
            start = mid + 1;
        }
        else
        {
            end   = mid - 1;
        }
    }
    return (~errNone - 4);
}

/*==========================================================================*/
/*  OpenDatabase_NNsh : f[^x[XANZX̏                        */
/*                                                                          */
/*==========================================================================*/
void OpenDatabase_NNsh(Char *dbName, UInt16 chkVersion, DmOpenRef *dbRef)
{
    LocalID dbId;
    UInt16  dbVersion;

    // f[^x[X݂邩mFB
    *dbRef    = 0;
    dbVersion = 0;
    dbId      = DmFindDatabase(0, dbName);
    if (dbId != 0)
    {
        // f[^x[X̃o[Wԍ擾
        (void) DmDatabaseInfo(0, dbId, NULL, NULL, &dbVersion, NULL, 
                              NULL, NULL, NULL, NULL, NULL, NULL, NULL);
        if (dbVersion < chkVersion)
        {
            // f[^x[X̃o[WÂƂ́Af[^x[X폜
            (void) DmDeleteDatabase(0, dbId);
            dbId = 0;
        }
    }

    // f[^x[X݂ȂƂ
    if (dbId == 0)
    {
        // f[^x[XVK쐬
        (void) DmCreateDatabase(0, dbName, 
                                SOFT_CREATOR_ID, SOFT_DBTYPE_ID, false);

        dbId      = DmFindDatabase(0, dbName);
        if (dbId != 0)
        {
            // DBɃo[Wԍݒ
            dbVersion = chkVersion;
            (void) DmSetDatabaseInfo(0, dbId, NULL,NULL, &dbVersion, NULL,
                                     NULL,NULL,NULL,NULL,NULL,NULL,NULL);
        }
    }

    // f[^x[X̃I[v
    *dbRef = DmOpenDatabase(0 , dbId, dmModeReadWrite);

    return;
}

/*==========================================================================*/
/*  closeDatabase_NNsh() : f[^x[XN[Y                       */
/*                                                                          */
/*==========================================================================*/
void CloseDatabase_NNsh(DmOpenRef dbRef)
{
    // DBI[vłĂCLOSEB
    if (dbRef != 0)
    {
        (void) DmCloseDatabase(dbRef);
        dbRef = 0;
    }
    return;
}

/*=========================================================================*/
/*   Function : QsortRecord_NNsh                                           */
/*                                                (R[h̃\[eBO) */
/*=========================================================================*/
void QsortRecord_NNsh(DmOpenRef dbRef, UInt16 keyType, UInt16 offset)
{

    // NCbN\[gd|
    switch (keyType)
    {

      case NNSH_KEYTYPE_UINT32:
        (void) DmQuickSort(dbRef, (DmComparF *) aplCompareF_UInt32, offset);
        break;

      case NNSH_KEYTYPE_UINT16:
        (void) DmQuickSort(dbRef, (DmComparF *) aplCompareF_UInt16, offset);
        break;

      case NNSH_KEYTYPE_CHAR:
      default:
        (void) DmQuickSort(dbRef, (DmComparF *) aplCompareF_Char, offset);
        break;
    }
    return;
}

/*=========================================================================*/
/*   Function : IsortRecord_NNsh                                           */
/*                                                (R[h̃\[eBO) */
/*=========================================================================*/
void IsortRecord_NNsh(DmOpenRef dbRef, UInt16 keyType, UInt16 offset)
{

    // }\[gd|
    switch (keyType)
    {
      case NNSH_KEYTYPE_UINT32:
        (void) DmInsertionSort(dbRef, (DmComparF *)aplCompareF_UInt32, offset);
        break;

      case NNSH_KEYTYPE_UINT16:
        (void) DmInsertionSort(dbRef, (DmComparF *)aplCompareF_UInt16, offset);
        break;

      case NNSH_KEYTYPE_CHAR:
      default:
        (void) DmInsertionSort(dbRef, (DmComparF *)aplCompareF_Char, offset);
        break;
    }
    return;
}

/*=========================================================================*/
/*   Function : EntryRecord_NNsh                                           */
/*                                               (ca̐擪Ƀf[^o^)  */
/*=========================================================================*/
Err EntryRecord_NNsh(DmOpenRef dbRef, UInt16 size, void *recordData)
{
    MemHandle  newRecH;
    UInt16     index;
    void      *dbP;

    // R[h̐VKǉ
    index   = 0;
    newRecH = DmNewRecord(dbRef, &index, size + sizeof(UInt32));
    if (newRecH == 0)
    {
        // R[hǉG[
        return (DmGetLastErr());
    }

    // R[hɃf[^
    dbP = MemHandleLock(newRecH);
    DmWrite(dbP, 0, recordData, size);
    MemHandleUnlock(newRecH);

    // R[hiύXIj
    DmReleaseRecord(dbRef, index, true);

    return (errNone);
}

/*=========================================================================*/
/*   Function : IsExistRecord_NNsh                                         */
/*                                                (R[h̑݃`FbN) */
/*=========================================================================*/
Err IsExistRecord_NNsh(DmOpenRef dbRef, void   *target,  UInt16 keyType,
                       UInt16 offset,   UInt16 *index)
{
    MemHandle  dataH;

    *index  = 0;
    dataH   = 0;
    return (searchRecordSub(dbRef, target, keyType, offset, index, &dataH));
}

/*=========================================================================*/
/*   Function : SearchRecord_NNsh                                          */
/*                                                        (R[h) */
/*=========================================================================*/
Err SearchRecord_NNsh(DmOpenRef dbRef, void *target, UInt16 keyType,
                      UInt16 offset, UInt16 size, void *matchedData,
                      UInt16 *index)
{
    Err        ret;
    UInt16     start;
    MemHandle  dataH;
    Char      *sc,  *ds;
    UInt32    *src, *dest;

    *index = 0;
    dataH  = 0;

    ret    = searchRecordSub(dbRef, target, keyType, offset, index, &dataH);
    if (ret != errNone)
    {
        // f[^炸
        return (ret);
    }
    if (dataH == 0)
    {
        // nhُ
        return ((~errNone) - 2);
    }

    src = (UInt32 *) MemHandleLock(dataH);
    if (src == NULL)
    {
        // |C^ُ
        return ((~errNone) - 3);
    }

    // f[^܂邲ƃRs[ĉ
    MemSet(matchedData, size, 0x00);
    dest   = (UInt32 *) matchedData;
    for (start = 0; start < (size - sizeof(UInt32));
         start = start + sizeof(UInt32))
    {
        *dest++ = *src++;
    }
    for (sc = (Char *) src, ds = (Char *) dest;start < size;
         start = start + sizeof(Char))
    {
         *ds++ = *sc++;
    }

    MemHandleUnlock(dataH);
    return (errNone);
}

/*=========================================================================*/
/*   Function : DeleteRecord_NNsh                                          */
/*                                                    (YR[h폜) */
/*=========================================================================*/
Err DeleteRecord_NNsh(DmOpenRef dbRef, void  *target,
                      UInt16 keyType,  UInt16 offset)
{
    Err       ret;
    UInt16    index;
    MemHandle dataH;

    index = 0;
    dataH = 0;
    ret = searchRecordSub(dbRef, target, keyType, offset, &index, &dataH);
    if (ret != errNone)
    {
        return (errNone + 1);
    }

    return (DmRemoveRecord(dbRef, index));
}

/*=========================================================================*/
/*   Function : DeleteRecordIDX_NNsh                                       */
/*                                                    (YR[h폜) */
/*=========================================================================*/
Err DeleteRecordIDX_NNsh(DmOpenRef dbRef, UInt16 index)
{
    // f[^I[oĂ邩mF
    if (index >= DmNumRecords(dbRef))
    {
        return (~errNone);
    }
    return (DmRemoveRecord(dbRef, index));
}

/*=========================================================================*/
/*   Function : GetRecord_NNsh                                             */
/*                                          (R[hCfbNXŊl) */
/*=========================================================================*/
Err GetRecord_NNsh(DmOpenRef dbRef, UInt16 index,
                   UInt16 size, void *matchedData)
{
    MemHandle  dataH;
    UInt16     start;
    UInt32    *src, *dest;
    Char      *sc,  *ds;

    // f[^I[oĂ邩mF
    if (index >= DmNumRecords(dbRef))
    {
        return (~errNone - 6);
    }

    dataH = DmQueryRecord(dbRef, index);
    if (dataH == 0)
    {
        // ȂI
        return (~errNone);
    }
    src = (UInt32 *) MemHandleLock(dataH);
    if (src == NULL)
    {
        // |C^ُ
        return ((~errNone) - 3);
    }

    // f[^܂邲ƃRs[ĉ
    MemSet(matchedData, size, 0x00);
    dest   = (UInt32 *) matchedData;
    for (start = 0; start < (size - sizeof(UInt32));
         start = start + sizeof(UInt32))
    {
        *dest++ = *src++;
    }
    for (sc = (Char *) src, ds = (Char *) dest;start < size;
         start = start + sizeof(Char))
    {
         *ds++ = *sc++;
    }
    MemHandleUnlock(dataH);
    return (errNone);
}

/*=========================================================================*/
/*   Function : GetRecordReadOnly_NNsh                                     */
/*                                          (R[hCfbNXŊl) */
/*=========================================================================*/
Err GetRecordReadOnly_NNsh(DmOpenRef dbRef, UInt16 index,
                           MemHandle *dataH, void **record)
{
    // f[^I[oĂ邩mF
    if (index >= DmNumRecords(dbRef))
    {
        return (~errNone - 6);
    }

    *dataH = DmQueryRecord(dbRef, index);
    if (*dataH == 0)
    {
        // ȂI
        return (~errNone);
    }

    // ̈bN
    *record = MemHandleLock(*dataH);
    if (record == NULL)
    {
        // |C^ُ
        return ((~errNone) - 3);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : ReleaseRecordReadOnly_NNsh                                 */
/*                                                (R[hǂݏoI) */
/*=========================================================================*/
Err ReleaseRecordReadOnly_NNsh(DmOpenRef dbRef, MemHandle dataH)
{
    if (dataH != 0)
    {
        MemHandleUnlock(dataH);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : UpdateRecord_NNsh                                          */
/*                                          (R[hCfbNXōXV) */
/*=========================================================================*/
Err UpdateRecord_NNsh(DmOpenRef dbRef, UInt16 index, 
                      UInt16 size, void *updateData)
{
    MemHandle recH;
    void     *dbP;

    recH = DmGetRecord(dbRef, index);
    if (recH == 0)
    {
        // R[hQƃG[
        return (DmGetLastErr());
    }

    // R[hɃf[^
    dbP = MemHandleLock(recH);
    DmWrite(dbP, 0, updateData, size);
    MemHandleUnlock(recH);

    // R[hiύXIj
    DmReleaseRecord(dbRef, index, true);

    return (errNone);
}

/*==========================================================================*/
/*  GetDBCount_NNsh : f[^x[Xɓo^Ăf[^      */
/*                                                                          */
/*==========================================================================*/
void GetDBCount_NNsh(DmOpenRef dbRef, UInt16 *count)
{
    *count = DmNumRecords(dbRef);
    return;
}

/*==========================================================================*/
/*  GetDBInfo_NNsh : f[^x[X̏̎擾                               */
/*                                                                          */
/*==========================================================================*/
Err GetDBInfo_NNsh(Char *dbName, NNshDBInfo *info)
{
    LocalID dbId;
    
    dbId = DmFindDatabase(0, dbName);

    // f[^x[X݂ȂƂ
    if (dbId == 0)
        return(~errNone);

    return(DmDatabaseInfo(0, dbId,
                          info->nameP, info->attributesP,
                          info->versionP, info->crDateP,
                          info->modDateP, info->bckUpDateP,
                          info->modNumP, info->appInfoIDP,
                          info->sortInfoIDP, info->typeP,
                          info->creatorP));
}


/*==========================================================================*/
/*  net_open() : lbg̃I[v                                           */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_open(UInt16 *netRef)
{
    UInt16 ifErr;
    Err    ret;

    // ϐ̏
    ifErr = 0;

    // lbgCũI[v
    (void) SysLibFind("Net.lib", netRef);

    // lbg[Nnodm
    ret   = NetLibOpen(*netRef, &ifErr);
    if ((ret == errNone)||(ret == netErrAlreadyOpen))
    {
        if (ifErr == 0)
        {
            // open
            return (errNone);
        }
        (void) NetLibClose(*netRef, false);
        *netRef = 0;
        ret = ~errNone;
    }
    return (ret);
}

/*==========================================================================*/
/*  net_close() : lbg̃N[Y                                          */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_close(UInt16 netRef)
{
    return (NetLibClose(netRef, false));
}

/*==========================================================================*/
/*  net_write() : f[^𑗐M                                          */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_write(UInt16 netRef, NetSocketRef socketRef, UInt16 size, void *data, Int32 timeout)
{
    Err    err;
    Int16  ret;

    ret = NetLibSend(netRef, socketRef, data, size, 0, NULL, 0, timeout, &err);
    if (ret == -1)
    {
        return (err);
    }
    return (errNone);
}

/*==========================================================================*/
/*  net_read() : f[^M                                           */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_read(UInt16 netRef, NetSocketRef socketRef, UInt16 size, void *data, UInt16 *readSize, Int32 timeout)
{
    Err    err;
    Int16  ret;
    UInt8 *ptr;

    *readSize = 0;
    ptr       = data;
    while (*readSize < size)
    {
        ret = NetLibReceive(netRef, socketRef, ptr, (size - *readSize),
                            0, NULL, 0, timeout, &err);
        if (ret == -1)
        {
            return (err);
        }
        if (ret == 0)
        {
            break;
        }

        *readSize = *readSize + ret;
        ptr = ptr + *readSize;
    }
    return (errNone);
}

/*==========================================================================*/
/*  net_disconnect() : zXg؂藣                                   */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_disconnect(UInt16 netRef, NetSocketRef socketRef, Int32 timeout)
{
    Err    err;

    (void) NetLibSocketShutdown(netRef, socketRef, netSocketDirBoth, timeout, &err);
    (void) NetLibSocketClose(netRef, socketRef, timeout, &err);
    if (err == errNone)
    {
        socketRef = 0;
    }
    return (errNone);
}

/*==========================================================================*/
/*  net_connect() : zXgɐڑ                                            */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_connect(NetSocketRef *socketRef, UInt16 netRef, Char *hostName,
                    UInt16 port, Int32 timeout)
{
    Err                  err;
    UInt8                openFlag;
    Int16                ret, addrLen;
    NetHostInfoPtr       hostIP;
    NetSocketAddrINType *addrType;
    NetSocketAddrType    addrBuf;
    NetHostInfoBufType  *infoBuff;

    // ڑXV(ǉ...)
    NetLibConnectionRefresh(netRef, true,  &openFlag, &ret);

    // obt@̈m
    infoBuff = MemPtrNew(sizeof(NetHostInfoBufType));
    if (infoBuff == NULL)
    {
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "MemPtrNew", "");
        return (~errNone);
    }

    // zXgIPAhX擾
    hostIP = NetLibGetHostByName(netRef, hostName, infoBuff, timeout, &err);
    if (hostIP == 0)
    {
        // zXgIP̎擾s
        err = NNSH_ERRORCODE_FAILURECONNECT;
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "NetLibGetHostByName :",  hostName);
        goto FUNC_END;
    }

    // \PbgOPEN
    *socketRef = NetLibSocketOpen(netRef, netSocketAddrINET, 
                                  netSocketTypeStream, netSocketProtoIPTCP,
                                  timeout, &err);
    if (*socketRef == -1)
    {
        // \PbgOPENُ
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "NetLibSocketOpen", "");
        *socketRef = 0;
        err = NNSH_ERRORCODE_FAILURECONNECT;
        goto FUNC_END;
    }

    // \PbgRlNg
    MemSet(&addrBuf, sizeof(NetSocketAddrType), 0x00);
    addrType = (NetSocketAddrINType *) &addrBuf;
    addrType->family = netSocketAddrINET;
    addrType->port   = NetHToNS(port);
    //addrType->addr   = infoBuff->address[0];
    MemMove(&(addrType->addr), *(hostIP->addrListP), hostIP->addrLen); 
    addrLen         = sizeof(NetSocketAddrType);
    err             = errNone;
    ret = NetLibSocketConnect(netRef, *socketRef,
                              (NetSocketAddrType *) &addrBuf,
                              addrLen, timeout, &err);
    if (ret == -1)
    {
        // \PbgRlNgُ
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "NetLibSocketConnect", "");
        (void) NetLibSocketClose(netRef, *socketRef, timeout, &err);
        err = NNSH_ERRORCODE_FAILURECONNECT;
        goto FUNC_END;
    }
    err = errNone;

FUNC_END:
    // obt@̈J
    (void) MemPtrFree(infoBuff);

    return (err);
}

/*==========================================================================*/
/*  NNshNet_LineHangup() : ؒf                                         */
/*                                                                          */
/*==========================================================================*/
void NNshNet_LineHangup(void)
{
   UInt16 netRef;

   (void) SysLibFind("Net.lib", &(netRef));

    // ؒf̊mF
    if (netRef != 0)
    {
        (void) NetLibClose(netRef, true);
        (void) NetLibFinishCloseWait(netRef);
    }
    return;
}

/*==========================================================================*/
/*  NNshSSL_callbackFunc() : SSL̃R[obN֐                          */
/*                                                                          */
/*==========================================================================*/
Int32 NNshSSL_callbackFunc(SslCallback *callbackStruct, Int32 command,
                           Int32 flavor, void *info)
{
  //  Ƃ肠AȂBBB
#if 0
    SslVerify *verifyData;

    switch (command)
    {
      case sslCmdVerify:
        // 'verify callback'
        verifyData = (SslVerify *) info;
        // ̊֐̌ŋᖡ
        break;

      case sslCmdInfo:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," Info:","sslCmdInfo");
        return (errNone);
        break;
      case sslCmdNew:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," New:","sslCmdNew");
        return (errNone);
        break;
      case sslCmdReset:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," Reset:","sslCmdReset");
        return (errNone);
        break;

      case sslCmdFree:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," Free:","sslCmdFree");
        return (errNone);
        break;

      default:
        // FrmCustomAlert(ALTID_INFO, "SSL_callback", " cmd:", "???");
        return (errNone);
        break;
    }

    // Verify(certificate)
    // FrmCustomAlert(ALTID_INFO, "SSL_callback", " code:", "flavor");
    switch (flavor)
    {
      case sslErrBadDecode:
        // ܂ؖfR[hłȂ
      case sslErrCert:
        // ʓIȏؖG[
      case sslErrCertDecodeError:
        // ؖ̃fR[hɎs
      case sslErrUnsupportedCertType:
        // T[o킯̂킩iT|[gĂȂjؖ𑗂Ă
      case sslErrUnsupportedSignatureType:
        // T[o킯̂킩VOl`𑗂Ă
      case sslErrVerifyBadSignature:
        // ؖ̃VOl`
      case sslErrVerifyNoTrustedRoot:
        // ؖȂ
      case sslErrVerifyNotAfter:
        // ̗ؖL؂Ă
      case sslErrVerifyNotBefore:
        // ؖ̓tɂȂĂ
      case sslErrVerifyConstraintViolation:
        // ؖX509̊gɈᔽĂ
      case sslErrVerifyUnknownCriticalExtension:
        // X509gؖ`FbN[`ŉ߂łȂ
      case sslErrOk:
      default:
        // NULL
        break;
    }
#endif
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_open() : SSLCũI[v                                */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_open(UInt16 sslMode, UInt16 *netRef,
                 UInt16 *sslRef, SslLib **template, SslContext **context)
{
    Err ret;

    // ϐ̏
    *netRef   = 0;
    *sslRef   = 0;
    *template = NULL;
    *context  = NULL;

    // NetCũI[v
    ret = NNshNet_open(netRef);
    if (ret != errNone)
    {
        *netRef = 0;
        return (ret);
    }

    if (sslMode == NNSH_SSLMODE_NOTSSL)
    {
        // SSL[hłȂA܂Ԃ
        return (ret);
    }

    // SSLCũI[v
    if (SysLibFind(kSslDBName, sslRef) != 0)
    {
        if (SysLibLoad(kSslLibType, kSslLibCreator, sslRef) != 0)
        {
            // [hsAG[
            *sslRef = 0;
            return (~errNone);
        }
    }
    ret = SslLibOpen(*sslRef);
    if (ret != errNone)
    {
        // SSLCuI[vsAAA
        (void) SslLibClose(*sslRef);
        *sslRef = 0;
        return (ret);
    }

    // generic SSL context̍쐬
    ret = SslLibCreate (*sslRef, template);
    if (ret != errNone)
    {
        (void) SslLibClose(*sslRef);
        *sslRef = 0;
        return (ret);
    }

    // Rp`tÕZbg
    // SslLibSet_Compat(*sslRef, *template, sslCompatAll);

    // SSL context̍쐬
    ret = SslContextCreate(*sslRef, *template, context);
    if (ret != errNone)
    {
        // generic SSL context̔p
        (void) SslLibDestroy(*sslRef, *template);
        (void) SslLibClose(*sslRef);
        *sslRef = 0;
        *template = NULL;
        return (ret);
    }
    return (ret);
}

/*==========================================================================*/
/*  NNshSSL_close() : SSLCũN[Y                               */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_close(UInt16 sslMode, UInt16 netRef,
                         UInt16 sslRef, SslLib *template, SslContext *context)
{
    if ((sslRef == 0)||(sslMode == NNSH_SSLMODE_NOTSSL))
    {
        NNshNet_close(netRef);
        return (errNone);
    }

    if (context != NULL)
    {
        (void) SslContextDestroy(sslRef, context);
    }

    if (template != NULL)
    {
        (void) SslLibDestroy(sslRef, template);
    }
    (void) SslLibClose(sslRef);

    (void) NNshNet_close(netRef);
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_connect() : SSLڑ                                             */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_connect(UInt16 sslMode, UInt16 sslRef, SslContext *context,
                    NetSocketRef *socketRef, UInt16 netRef,
                    Char *hostName, UInt16 port, Int32 timeout)
{
    Err ret;
    SslCallback verifyCallback;

    // TCP/IPŃzXgɐڑ
    ret = NNshNet_connect(socketRef, netRef, hostName, port, timeout);
    if ((ret != errNone)||(sslMode == NNSH_SSLMODE_NOTSSL))
    {
        return (ret);
    }

    // // VerifyR[obN֐ݒ肷
    MemSet(&verifyCallback, sizeof(SslCallback), 0x00);
    verifyCallback.callback = NNshSSL_callbackFunc;
    SslContextSet_VerifyCallback(sslRef, context, &verifyCallback);

    // \PbgContextɐݒAzXgɐڑ
    //SslContextSet_Compat(sslRef, context, sslCompatAll);
    SslContextSet_Socket(sslRef, context, *socketRef);
    ret = SslOpen(sslRef, context,
                  ((sslOpenModeSsl)|(sslOpenUseDefaultTimeout)), 0);
    return (ret);
}

/*==========================================================================*/
/*  NNshSSL_disconnect() : SSLؒf                                          */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_disconnect(UInt16 sslMode, UInt16 sslRef, SslContext *context,
                       NetSocketRef socketRef, UInt16 netRef, Int32 timeout)
{
    Err ret;
    if (sslMode != NNSH_SSLMODE_NOTSSL)
    {
        ret = SslClose(sslRef, context, sslCloseUseDefaultTimeout, timeout);
    }
    ret = NNshNet_disconnect(netRef, socketRef, timeout);

    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_write() : f[^M(SSL)                                       */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_write(UInt16 sslMode, UInt16  netRef, NetSocketRef socketRef,
                  UInt16 sslRef, SslContext *context, UInt16 size, void *data,
                  Int32  timeout)
{
    Err   err;
    Int16 ret;

    // SSL[hłȂ΁Aʏ̏ݏs
    if (sslMode == NNSH_SSLMODE_NOTSSL)
    {
        return (NNshNet_write(netRef, socketRef, size, data, timeout));
    }

    // f[^
    ret = SslWrite(sslRef, context, data, size, &err);
    if (ret  == -1)
    {
        return (err);
    }
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_read() : f[^M(SSL)                                        */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_read(UInt16 sslMode, UInt16  netRef, NetSocketRef socketRef,
                 UInt16 sslRef, SslContext *context,
                 UInt16 size, void *data, UInt16 *readSize, Int32 timeout)
{
    Err    err;
    Int16  ret;

    // SSL[hłȂ΁Aʏ̓ǂݏos
    if (sslMode == NNSH_SSLMODE_NOTSSL)
    {
        return (NNshNet_read(netRef, socketRef, size, data, readSize, timeout));
    }
    
    // f[^ǂݍ
    ret = SslRead(sslRef, context, data, size, &err);
    if (ret == -1)
    {
        return (err);
    }
    *readSize = ret;
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_flush() : f[^obt@̃NA(SSL)                       */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_flush(UInt16 sslMode, UInt16  sslRef, SslContext *context)
{
    if (sslMode != NNSH_SSLMODE_NOTSSL)
    {
        // f[^obt@̃NAw
        SslContextSet_Mode(sslRef, context, (sslModeFlush));
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : SendToLocalMemopad                                         */
/*                    Exchange}l[WgpăɃf[^] */
/*                    (http://www.palmos.com/dev/support/docs/recipes/     */
/*                                    recipe_exg_mgr_send_local.html ) */
/*=========================================================================*/
Err SendToLocalMemopad(Char *title, Char *data)
{
    ExgSocketType *exgSocket;
    UInt32        size;
    Err           err;

    // f[^̏
    exgSocket = MemPtrNew(sizeof(ExgSocketType));
    if (exgSocket == NULL)
    {
        // ̈mێs
        return (~errNone);
    }
    MemSet(exgSocket, sizeof(ExgSocketType), 0x00);
    err  = errNone;
    size = StrLen(data) + 1;

    // X]ANȂ悤ɂ
    exgSocket->noGoTo      = 1;

    // X]\sȂ
    exgSocket->noStatus    = true;

    // will comm. with memopad app
    exgSocket->description = title;
    exgSocket->name        = "Message.txt";

    // set to comm. with local machine (PIM) only
    exgSocket->localMode = 1;

    err = ExgPut(exgSocket);
    if (err == errNone)
    {
        ExgSend(exgSocket, data, size, &err);
        ExgDisconnect(exgSocket, err);
    }

    // mۗ̈̉
    MEMFREE_PTR(exgSocket);

    return (err);
}

/*=========================================================================*/
/*   Function : ShowVersion_NNsh                                           */
/*                                                    o[W̕\ */
/*=========================================================================*/
void ShowVersion_NNsh(void)
{
    Char *buffer;
    
    buffer = MemPtrNew(BUFSIZE * 2);
    if (buffer == NULL)
    {
        // ̈mێs
        return;
    }
    MemSet (buffer, (BUFSIZE * 2), 0x00);
    StrCopy(buffer, SOFT_NAME);
    StrCat (buffer, "\n");
    StrCat (buffer, SOFT_VERSION);
    StrCat (buffer, SOFT_REVISION);
    StrCat (buffer, "\n(");
    StrCat (buffer, SOFT_DATE);
    StrCat (buffer, ")\n    ");
    StrCat (buffer, SOFT_INFO);
    FrmCustomAlert(ALTID_INFO, buffer, "", "");

    MEMFREE_PTR(buffer);
    return;
}

/*=========================================================================*/
/*   Function :  NNshWinSetFieldText                                       */
/*                                                tB[heLXg̍XV */
/*=========================================================================*/
void NNshWinSetFieldText(FormType *frm, UInt16 fldID, Char *msg, UInt32 size)
{
    MemHandle  txtH, oldTxtH;
    Char      *txtP;
    FieldType *fldP;

    // bZ[W\̈ɃRs[
    txtH = MemHandleNew(size + MARGIN);
    if (txtH == 0)
    {
        // ̈̊mۂɎs
        return;
    }
    txtP = (Char *) MemHandleLock(txtH);
    if (txtP == NULL)
    {
        // ̈̊mۂɎs
        MemHandleFree(txtH);
        return;
    }
    (void) MemSet(txtP,  size + MARGIN, 0x00);
    if (size != 0)
    {
        (void) StrNCopy(txtP, msg, size);
    }
    MemHandleUnlock(txtH);

    // tB[h̃IuWFNg|C^擾
    fldP = (FieldType *) FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    // tB[h̃eLXgnhւAÂ̂폜
    oldTxtH = FldGetTextHandle(fldP);
    FldSetTextHandle(fldP, NULL);
    FldSetTextHandle(fldP, txtH);
    if (oldTxtH != 0)
    {
        (void) MemHandleFree(oldTxtH);
    }

    // tH[̍ĕ`
    FrmDrawForm(frm);
    return;
}

/*=========================================================================*/
/*   Function :  NNshWinGetFieldText                                       */
/*                                                tB[heLXg̎擾 */
/*=========================================================================*/
void NNshWinGetFieldText(FormType *frm, UInt16 fldID, Char *area, UInt32 len)
{
    MemHandle  txtH;
    Char      *txtP;
    FieldType *fldP;

    // tB[hi[̈
    MemSet(area, len, 0x00);

    // tB[h̃IuWFNg|C^擾
    fldP = (FieldType *) FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    // tB[h̃eLXgnh擾
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        if (txtP != NULL)
        {
            StrNCopy(area, txtP, (len - 1));
            MemHandleUnlock(txtH);
        }
    }
    return;
}

/*=========================================================================*/
/*   Function : NNshWinSetPopItems                                         */
/*                                          |bvAbvgK̃xݒ */
/*=========================================================================*/
void NNshWinSetPopItems(FormType *frm, UInt16 popId, UInt16 lstId, UInt16 item)
{
    ListType    *lstP;
    ControlType *ctlP;

    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, popId));
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lstId));
                          
    LstSetTopItem  (lstP, item);
    LstSetSelection(lstP, item);
    CtlSetLabel    (ctlP, LstGetSelectionText(lstP, item));

    return;
}

/*=========================================================================*/
/*   Function : DataInputDialog                                            */
/*                                                NNsiʂ̓̓_CAO */
/*=========================================================================*/
Boolean InputDialog(Char *title, Char *area, UInt16 size)
{
    Boolean       ret = false;
    FormType     *prevFrm, *diagFrm;
    FieldType    *fldP;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // _CAOtH[ANeBuɂ
    diagFrm  = FrmInitForm(FRMID_INPUTDIALOG);
    if (diagFrm == NULL)
    {
        return (false);
    }
    FrmSetActiveForm(diagFrm);

    // ^CgRs[
    FrmCopyTitle(diagFrm, title);

    // w肳ꂽEBhEɔf
    NNshWinSetFieldText(diagFrm, FLDID_INPUTFIELD, area, size);
    FrmSetFocus(diagFrm, FrmGetObjectIndex(diagFrm, FLDID_INPUTFIELD));

    fldP = FrmGetObjectPtr(diagFrm,
                           FrmGetObjectIndex(diagFrm, FLDID_INPUTFIELD));

    // IĂ
    FldSetSelection(fldP, 0, FldGetTextLength(fldP));

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_EditAction);

    if (FrmDoDialog(diagFrm) == BTNID_DIALOG_OK)
    {
        // OK{^ꂽƂɂ́A擾
        NNshWinGetFieldText(diagFrm, FLDID_INPUTFIELD, area, size);
        ret = true;
    }
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(diagFrm);

    return (ret);
}

/*=========================================================================*/
/*   Function : SetMsg_BusyForm                                            */
/*                                                     BUSYeLXg̐ݒ  */
/*=========================================================================*/
void SetMsg_BusyForm(Char *msg)
{
    FormType *busyFrm;
    UInt16    length;

    // \镶񒷂̃`FbN
    length = StrLen(msg);
    length = (length > BUSYWIN_MAXLEN) ? BUSYWIN_MAXLEN : length;

    busyFrm = FrmGetActiveForm();
    NNshWinSetFieldText(busyFrm, FLDID_BUSY, msg, length);

    return;
}

/*=========================================================================*/
/*   Function : Show_BusyForm                                              */
/*                                                      BUSYtH[̕\ */
/*=========================================================================*/
void Show_BusyForm(Char *msg, NNshWorkingInfo *NNshGlobal)
{
    FormType  *busyFrm;
    UInt16    length;

    switch (FrmGetActiveFormID())
    {
      case FRMID_BUSY:
        // łBUSYEBhE\Ăꍇ
        return (SetMsg_BusyForm(msg));
        break;

      case 0:
        // EBhEJĂȂ
        NNshGlobal->prevBusyForm = NULL;
        break;

      default:
        // ݂̃EBhEL
        NNshGlobal->prevBusyForm = FrmGetActiveForm();
        break;
    }

    // tH[݂̌̏ԂL
    // MemSet(&(NNshGlobal->formState), sizeof(FormActiveStateType), 0x00);
    // FrmSaveActiveState(&(NNshGlobal->formState));
    // NNshGlobal->prevBusyForm = FrmGetActiveForm();

    // BUSY_CAOtH[𐶐AANeBuɂ
    busyFrm = FrmInitForm(FRMID_BUSY);
    FrmSetActiveForm(busyFrm);

    // \镶񒷂̃`FbN
    length = StrLen(msg);
    length = (length > BUSYWIN_MAXLEN) ? BUSYWIN_MAXLEN : length;

    // tB[hɕݒ
    NNshWinSetFieldText(busyFrm, FLDID_BUSY, msg, length);

    return;
}

/*=========================================================================*/
/*   Function : Hide_BusyForm                                              */
/*                                                      BUSYtH[̍폜 */
/*=========================================================================*/
void Hide_BusyForm(NNshWorkingInfo *NNshGlobal)
{
    FormType *frm;

    if (FrmGetActiveFormID() != FRMID_BUSY)
    {
        // Ȃ
        return;
    }

    // BUSYtH[폜
    frm = FrmGetActiveForm();
    if (NNshGlobal->prevBusyForm != NULL)
    {
        // Ȃł̂...
        FrmEraseForm (frm);
        FrmSetActiveForm(NNshGlobal->prevBusyForm);
    }
    FrmDeleteForm(frm);

    // FrmRestoreActiveState(&(NNshGlobal->formState));

    return;
}

/**----------------------------------------------------------------------**
 **   doLogin_HotSpot 
 **     (HotSpotɃOC)
 **                                            type : IISP
 **                                            msg  : OC{
 **----------------------------------------------------------------------**/
void doLogin_HotSpot(NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal)
{
    // ڑ́Ahttp://sourceforge.jp/ Ƃ  (x^ɋL...)
    MemSet(NNshParam->hostName, BUFSIZE, 0x00);
    StrCopy(NNshParam->hostName, "sourceforge.jp");

#ifdef DEBUG_LOCALHOST_ADDRESS
    // MfobOzXgɕύX...
    StrCopy(NNshParam->hostName, DEBUG_ADDRESS);
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS

    // |[gԍi[
    NNshParam->portNum = 80;

    // t@Ci[
    MemSet (NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
    StrCopy(NNshGlobal->reqAddress, "/");

    // bZ[W{fBȂ
    MemSet (NNshGlobal->workBuf, ((NNshParam->bufferSize) / 2), 0x00);
    StrCopy(NNshGlobal->workBuf, " ");

    // HTTP, GET\bhgp
    NNshGlobal->sendMethod = NNSILOGIN_GET_METHOD_HTTP;

    // bZ[W쐬
    NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG_SENDLOG
    // fobOpɑMf[^֏o͂
    SendToLocalMemopad("FIRST CONNECTION", NNshGlobal->sendBuf);
#endif

    // HTTPʐM{
    NNshHTTP_comm(NNshParam, NNshGlobal);
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        // ʐMsAG[
        FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", " ", " ");
#endif
        return;
    }

#ifdef DEBUG
    // fobOpɎMf[^֏o͂
    StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(FIRST REPLY)\n");
    SendToLocalMemopad("FIRST REPLY(RX)", NNshGlobal->recvBuf);
#endif

    // MbZ[WɃ_CNg̎w邩A`FbNs
    NNshGlobal->err = ~errNone - 9;
    if ((StrStr(NNshGlobal->recvBuf, "HTTP/1.0 302") != NULL)||
        (StrStr(NNshGlobal->recvBuf, "HTTP/1.1 302") != NULL))
    {
        // _CNg̃zXgƃTCg𒊏o
        NNsh_check302URL(NNshParam, NNshGlobal);
    }
    else
    {
#ifdef DEBUG
        // _CNgȂƂ𑗐M
        FrmCustomAlert(ALTID_INFO, "DO NOT REDIRECT...", " ", " ");
#endif
    }

    // _CNg̃AhX擾ł
    if (NNshGlobal->err == errNone)
    {
#ifdef DEBUG_LOCALHOST_ADDRESS
        // MfobOzXgɕύX...
        StrCopy(NNshParam->hostName, DEBUG_ADDRESS);
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS

        // bZ[W쐬
        NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG
        // fobOpɑMf[^֏o͂
        SendToLocalMemopad("SEND(REDIRECT)", NNshGlobal->sendBuf);
#endif

        // _CNgɁiMvgRɍ킹āj
        if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) ==
                                                        NNSHLOGIN_SSL_PROTOCOL)
        {
#ifdef DEBUG
            // HTTPSŒʐM邱Ƃ\
            FrmCustomAlert(ALTID_INFO, "HTTPS(SSL) CONNECTION...", " ", " ");
#endif

            // httpsʐMv
            NNshHTTPS_comm(NNshParam, NNshGlobal);
        }
        else
        {
#ifdef DEBUG
            // HTTPSŒʐM邱Ƃ\
            FrmCustomAlert(ALTID_INFO, "HTTP CONNECTION...", " ", " ");
#endif

            // httpʐMv
            NNshHTTP_comm(NNshParam, NNshGlobal);
        }
        if (NNshGlobal->err != errNone)
        {
#ifdef DEBUG
            // ʐMsAG[
            FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", " ", "(redirect)");
#endif
            return;
        }
#ifdef DEBUG
        // fobOpɎMf[^֏o͂
        StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(REDIRECT)\n");
        SendToLocalMemopad("REDIRECT(RX)", NNshGlobal->recvBuf);
#endif
    }

    // OCtH[̉͂ƑM{fB̍쐬
    Analysis_LoginForm(NNshParam, NNshGlobal);

#ifdef DEBUG_LOCALHOST_ADDRESS
    // MfobOzXgɕύX...
    StrCopy(NNshParam->hostName, DEBUG_ADDRESS);
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS

    // OCp̃bZ[W쐬
    NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG_SENDLOG
    // fobOpɑMf[^֏o͂
    SendToLocalMemopad("SEND(DO LOGIN)", NNshGlobal->sendBuf);
#endif

    // OCbZ[W(MvgRɍ킹)M
    if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) == 
                                                        NNSHLOGIN_SSL_PROTOCOL)
    {
        // httpsʐMv
        NNshHTTPS_comm(NNshParam, NNshGlobal);
    }
    else
    {
        // httpʐMv
        NNshHTTP_comm(NNshParam, NNshGlobal);
    }
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        // ʐMsAG[
        FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", " ", "(redirect)");
#endif
        return;
    }
#ifdef DEBUG
    // fobOpɎMf[^֏o͂
    StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(LOGIN DETAIL)\n");
    SendToLocalMemopad("LOGIN DETAIL(RX)", NNshGlobal->recvBuf);
#endif

    // OC"s"ǂmF
    if (StrStr(NNshGlobal->recvBuf, "s") != NULL)
    {
        // sƂ񂪂ꍇɂ́AOCɎsƔF
        NNshGlobal->err = ~errNone;
    }
    return;
}

/**----------------------------------------------------------------------**
 **    OCtH[̉͂ƑM{fB̉
 ** 
 **                NNshGlobal->recvBuf F M{fB
 **                NNshGlobal->workBuf F Mp{fB(ō쐬)
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void Analysis_LoginForm(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    NNshGlobal->err = errNone;

    // NNshGlobal->sendBuf [Nobt@Ƃėp
    MemSet(NNshGlobal->sendBuf, NNshParam->bufferSize, 0x00);

    // CookieE
    pickup_cookie(NNshParam, NNshGlobal);

    // POSTy[W擾
    pickup_formTag(NNshParam, NNshGlobal);

    // f[^͈̉ʒu肷
    NNshGlobal->tempPtr = NNshGlobal->recvBuf;

    // Mpobt@NA
    MemSet (NNshGlobal->workBuf, ((NNshParam->bufferSize) / 2), 0x00);

    // tH[f[^𑗐M邽߂̃^O𒊏o
    while (NNshGlobal->tempPtr < (NNshGlobal->recvBuf + NNshParam->bufferSize))
    {

        NNshGlobal->tempPtr2 = StrStr(NNshGlobal->tempPtr,"<INPUT");
        if (NNshGlobal->tempPtr2 == NULL)
        {
            NNshGlobal->tempPtr2 = StrStr(NNshGlobal->tempPtr,"<input");
        }
        if ((NNshGlobal->tempPtr2 == NULL)||
            (NNshGlobal->tempPtr2 >= (NNshGlobal->recvBuf + NNshParam->bufferSize)))
        {
            // INPUT^OołȂAI
            break;
        }

        // INPUT^O̓e͂
        pickup_nameTag (NNshParam, NNshGlobal);
        pickup_valueTag(NNshParam, NNshGlobal);

        // key  value i[
        set_name_and_value(NNshParam, NNshGlobal);

        // inputtH[ֈړ
        NNshGlobal->tempPtr = NNshGlobal->tempPtr2 + sizeof("<INPUT");
    }
    return;
}

/**----------------------------------------------------------------------**
 **    MbZ[W̃_CNg(OCy[W)͂
 ** 
 **                    NNshGlobal->recvBuf F M{fB
 **
 **
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNsh_check302URL(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    NNshGlobal->tempPtr = StrStr(NNshGlobal->recvBuf, "http");
    if (NNshGlobal->tempPtr == NULL)
    {
        // RedirectzXg̓ǂݏos
        NNshGlobal->err = ~errNone;
        return;
    }

#ifdef USE_REFERER
    // _CNgꂽAhXRefererɐݒ肷
    MemSet(NNshGlobal->referer, BUFSIZE, 0x00);
    for (NNshGlobal->loopCount = 0; 
         NNshGlobal->loopCount < (BUFSIZE - 1); 
         (NNshGlobal->loopCount)++)
    {
        if (NNshGlobal->tempPtr[(NNshGlobal->loopCount)] <= ' ')
        {
            // URL̖ɓB(ԂA{ \r Ŕ...)
            break;
        }
        NNshGlobal->referer[(NNshGlobal->loopCount)] =
                                  NNshGlobal->tempPtr[(NNshGlobal->loopCount)];
    }
#endif

    // vgR̃`FbN
    NNshGlobal->sendMethod = 0;
    if (NNshGlobal->tempPtr[4] == 's')
    {
        // https (SSL)
        NNshGlobal->sendMethod = NNSHLOGIN_SSL_PROTOCOL;
    }
    NNshGlobal->tempPtr = StrStr(NNshGlobal->tempPtr, "://");
    if (NNshGlobal->tempPtr == NULL)
    {
        // zXgoɎs
        NNshGlobal->err = ~errNone + 100;
        return;
    }
    NNshGlobal->tempPtr = NNshGlobal->tempPtr + 3;  // 3́AStrLen("://");

    // zXg̃Rs[
    MemSet(NNshParam->hostName, BUFSIZE, 0x00);
    for (NNshGlobal->loopCount = 0; 
         NNshGlobal->loopCount < (BUFSIZE - 1); 
         (NNshGlobal->loopCount)++)
    {
        if (*(NNshGlobal->tempPtr) == '/')
        {
            // zXg̏I[
            // (NNshGlobal->tempPtr)++;  // /͂߂...
            break;
        }
        if (*(NNshGlobal->tempPtr) == ':')
        {
            // |[gԍw肳Ă...
            NNshGlobal->sendMethod =
                       (NNshGlobal->sendMethod)|(NNSHLOGIN_CONNECT_PORT);
            (NNshGlobal->tempPtr)++;

            // |[gԍ̓
            NNshParam->portNum = 0;
            while ((*(NNshGlobal->tempPtr) >= '0')&&
                   (*(NNshGlobal->tempPtr) <= '9'))
            {
                NNshParam->portNum = NNshParam->portNum * 10 + 
                                         (*(NNshGlobal->tempPtr) - '0');
                (NNshGlobal->tempPtr)++;
            }
            //(NNshGlobal->tempPtr)++;  // /͂߂...
            break;
        }
        NNshParam->hostName[NNshGlobal->loopCount] = *(NNshGlobal->tempPtr);
        (NNshGlobal->tempPtr)++;
    }

    // ʐMt@C擾
    NNshGlobal->loopCount = 0; 
    if (*(NNshGlobal->tempPtr) != '/')
    {
        // ΃AhXȂ̂ŁA݂̗vpath𐶂悤ɂ
        NNshGlobal->loopCount = StrLen(NNshGlobal->reqAddress);
        while (NNshGlobal->loopCount != 0)
        {
            (NNshGlobal->loopCount)--;
            if (NNshGlobal->reqAddress[NNshGlobal->loopCount] == '/')
            {
                break;
            }
        }
        NNshGlobal->reqAddress[NNshGlobal->loopCount] = '/';
        (NNshGlobal->loopCount)++;
    }
    else
    {
        MemSet(NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
    }
    while (NNshGlobal->loopCount < (BUFSIZE - 1))
    {
        if (*(NNshGlobal->tempPtr) <= ' ')
        {
            break;
        }
        NNshGlobal->reqAddress[NNshGlobal->loopCount] = *(NNshGlobal->tempPtr);
        (NNshGlobal->tempPtr)++;
        (NNshGlobal->loopCount)++;
    }

    // AhXȂ / ɂ
    if (StrLen(NNshGlobal->reqAddress) == 0)
    {
        StrCopy(NNshGlobal->reqAddress, "/");
    }
#ifdef DEBUG
    // ͌ʂ̃Oo͂
    FrmCustomAlert(ALTID_INFO, NNshParam->hostName, " : ", NNshGlobal->reqAddress);
#endif

    // I
    NNshGlobal->err = errNone;
    return;
}

/**----------------------------------------------------------------------**
 **    HTTPSʐM(SSL){
 **                    NNshGlobal->workBuf F Mf[^
 **                    NNshGlobal->sendBuf F M{fB(HTTPwb_)
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNsh_MakeHTTPmsg(NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal)
{
#ifdef USE_RESOURCE
    MemHandle  strH;
#endif

    MemSet(NNshGlobal->sendBuf, NNshParam->bufferSize, 0x00);
    switch (NNshGlobal->sendMethod)
    {
      case NNSILOGIN_POST_METHOD_SSL:
        StrCopy(NNshGlobal->sendBuf, "POST ");
        NNshParam->portNum = 443;
        break;

      case NNSILOGIN_POST_METHOD_HTTP:
        StrCopy(NNshGlobal->sendBuf, "POST ");
        NNshParam->portNum = 80;
        break;

      case NNSILOGIN_GET_METHOD_SSL:
        StrCopy(NNshGlobal->sendBuf, "GET ");
        NNshParam->portNum = 443;
        break;

      case NNSILOGIN_GET_METHOD_HTTP:
        StrCopy(NNshGlobal->sendBuf, "GET ");
        NNshParam->portNum = 80;
        break;

      case NNSILOGIN_POST_METHOD_OTHER:
      case NNSILOGIN_POST_METHOD_OTHERSSL:
        StrCopy(NNshGlobal->sendBuf, "POST ");
        break;

      case NNSILOGIN_GET_METHOD_OTHER:
      case NNSILOGIN_GET_METHOD_OTHERSSL:
      default:
        StrCopy(NNshGlobal->sendBuf, "GET ");
        break;
    }
    StrCat(NNshGlobal->sendBuf, NNshGlobal->reqAddress);
    StrCat(NNshGlobal->sendBuf, " HTTP/1.0\r\nHost: ");
    StrCat(NNshGlobal->sendBuf, NNshParam->hostName);

    // refererݒ肳Ăꍇɂ͕t
#ifdef USE_REFERER
    if (StrLen(NNshGlobal->referer) != 0)
    {
        StrCat(NNshGlobal->sendBuf, "\r\nReferer: ");
        StrCat(NNshGlobal->sendBuf, NNshGlobal->referer);
    }
#endif

    // {fBȂꍇɂ́AContent-Length, Content-TypeȂ
    if (StrLen(NNshGlobal->workBuf) > 1)
    {
        StrCat(NNshGlobal->sendBuf, "\r\nContent-Length: ");
        StrIToA(&NNshGlobal->sendBuf[StrLen(NNshGlobal->sendBuf)], 
                                      StrLen(NNshGlobal->workBuf));
        StrCat(NNshGlobal->sendBuf, "\r\nContent-Type: application/x-www-form-urlencoded");
    }

    // Cookieǉ
    if (NNshGlobal->cookie[0] != '\0')
    {
        StrCat(NNshGlobal->sendBuf, "\r\n");
        StrCat(NNshGlobal->sendBuf, NNshGlobal->cookie);
    }

    // wb_̎c蕔t
    StrCat(NNshGlobal->sendBuf, "\r\nAccept: text/html, */*\r\nUser-Agent: mlDA/1.00 (PDA; PalmOS/NNsi family)\r\nAccept-Encoding: identity\r\nAccept-Language: ja, en\r\nConnection: close\r\nPragma: no-cache\r\n\r\n");

    // StrCat(NNshGlobal->sendBuf, "\r\n\r\n");   //  \[Xŕt
    StrCat(NNshGlobal->sendBuf, NNshGlobal->workBuf);

    return;
}

/**----------------------------------------------------------------------**
 **    HTTPSʐM(SSL){
 **                                NNshGlobal->sendBuf F Mf[^
 **                                NNshGlobal->recvBuf F Mf[^
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNshHTTPS_comm(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    // Mobt@̑|
    MemSet(NNshGlobal->recvBuf, NNshParam->bufferSize, 0x00);

    // SSL̃I[v
    NNshGlobal->err = 
          NNshSSL_open(NNSH_SSLMODE_DOSSL,    &(NNshGlobal->netRef), 
                       &(NNshGlobal->sslRef), &(NNshGlobal->sslTemplate),
                       &(NNshGlobal->sslContext));
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_open", " ", NNshParam->hostName);
#endif
        return;
    }

    // SSL̃RlNg
    NNshGlobal->err = 
          NNshSSL_connect(NNSH_SSLMODE_DOSSL,     NNshGlobal->sslRef, 
                          NNshGlobal->sslContext, &(NNshGlobal->socketRef),
                          NNshGlobal->netRef,     NNshParam->hostName,
                          NNshParam->portNum,     NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_connect", " ", NNshParam->hostName);
#endif
        goto HTTPS_CLOSE;
    }

    // v̑M
    NNshGlobal->err = 
        NNshSSL_write(NNSH_SSLMODE_DOSSL,       NNshGlobal->netRef, 
                      NNshGlobal->socketRef,    NNshGlobal->sslRef,
                      NNshGlobal->sslContext,   StrLen(NNshGlobal->sendBuf),
			NNshGlobal->sendBuf,      NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_write", " ", NNshParam->hostName);
#endif
        goto HTTPS_DISCONNECT;
    }

    // ǂݍ
    NNshGlobal->err = 
          NNshSSL_read(NNSH_SSLMODE_DOSSL,
                       NNshGlobal->netRef, NNshGlobal->socketRef, 
                       NNshGlobal->sslRef, NNshGlobal->sslContext, 
                       NNshParam->bufferSize, NNshGlobal->recvBuf,
		       &(NNshGlobal->ret), NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_read", " ", NNshParam->hostName);
#endif
        goto HTTPS_DISCONNECT;
    }

HTTPS_DISCONNECT:
    // ڑ؂
    NNshSSL_disconnect(NNSH_SSLMODE_DOSSL, NNshGlobal->sslRef,
                       NNshGlobal->sslContext,  NNshGlobal->socketRef,
                       NNshGlobal->netRef,      NNshParam->timeout);
HTTPS_CLOSE:
    // N[Y
    NNshSSL_close(NNSH_SSLMODE_DOSSL, NNshGlobal->netRef,
                  NNshGlobal->sslRef, NNshGlobal->sslTemplate,
                  NNshGlobal->sslContext);

    return;
}

/**----------------------------------------------------------------------**
 **    HTTPʐM{
 **                                NNshGlobal->sendBuf F Mf[^
 **                                NNshGlobal->recvBuf F Mf[^
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNshHTTP_comm(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    // Mobt@̑|
    MemSet(NNshGlobal->recvBuf, NNshParam->bufferSize, 0x00);

    // lbgCuOPEN
    NNshGlobal->err = NNshNet_open(&(NNshGlobal->netRef));
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "Net_open", " ", NNshParam->hostName);
#endif
        return;
    }
    // RlNg
    NNshGlobal->err = NNshNet_connect(&(NNshGlobal->socketRef), 
                                      NNshGlobal->netRef,
                                      NNshParam->hostName, 
                                      NNshParam->portNum,
                                      NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "Net_connect", " ", NNshParam->hostName);
#endif
        goto HTTP_CLOSE;
    }

    // 
    NNshGlobal->err = NNshNet_write(NNshGlobal->netRef, 
                                    NNshGlobal->socketRef,
                                    StrLen(NNshGlobal->sendBuf), 
                                    NNshGlobal->sendBuf, 
                                    NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "NNshNet_write",  "", "");
#endif
        goto HTTP_CLOSE;
    }

    // ǂݏo
    NNshGlobal->err = NNshNet_read(NNshGlobal->netRef,
                                   NNshGlobal->socketRef, 
                                   NNshParam->bufferSize, 
                                   NNshGlobal->recvBuf,
                                   &(NNshGlobal->ret), 
                                   NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
        // ǂݏos
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "NNshNet_read",  "", "");
#endif
        goto HTTP_DISCONNECT;
    }
HTTP_DISCONNECT:
    // \Pbgؒf
    NNshNet_disconnect(NNshGlobal->netRef, NNshGlobal->socketRef, 
                                                        NNshParam->timeout);
HTTP_CLOSE:
    NNshNet_close(NNshGlobal->netRef);

    return;
}

/**----------------------------------------------------------------------**
 **    NAME^Ooł邩`FbN
 **
 **                  NNshGlobal->tempBufɌoʂi[
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void pickup_nameTag(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char  *ptr;
    UInt16 loop;

    // f[^
    MemSet(NNshGlobal->tempBuf,  BUFSIZE, 0x00);
    loop = 0;
    ptr  = NNshGlobal->tempPtr2;

    // INPUT^O̓e͂
    while ((ptr < (NNshGlobal->recvBuf + NNshParam->bufferSize))&&(*ptr != '>'))
    { 
        // L[[hname
        if (((*(ptr + 0) == 'n')||(*(ptr + 0) == 'N'))&&
            ((*(ptr + 1) == 'a')||(*(ptr + 1) == 'A'))&&
            ((*(ptr + 2) == 'm')||(*(ptr + 2) == 'M'))&&
            ((*(ptr + 3) == 'e')||(*(ptr + 3) == 'E')))
        {
            // namef[^̐擪܂Ń|C^𑗂
            ptr = ptr + 5;
            if ((*ptr == '"')||(*ptr == '\'')||(*ptr == ' ')||(*ptr == '='))
            {
                ptr++;
            }
            // f[^tempBufɃRs[
            while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr != ' ')&&
                   (*ptr != '>')&&(loop < (BUFSIZE - 1)))
            {
                NNshGlobal->tempBuf[loop] = *ptr;
                loop++;
                ptr++;
            }
            return;
        }
        ptr++;
    }
    return;
}

/**----------------------------------------------------------------------**
 **    VALUE^Ooł邩`FbN
 **
 **                  NNshGlobal->tempBuf2Ɍoʂi[
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void pickup_valueTag(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char  *ptr;
    UInt16 loop;

    // f[^
    MemSet(NNshGlobal->tempBuf2,  BUFSIZE, 0x00);
    loop = 0;
    ptr  = NNshGlobal->tempPtr2;

    // INPUT^O̓e͂
    while ((ptr < (NNshGlobal->recvBuf + NNshParam->bufferSize))&&(*ptr != '>'))
    { 
        // L[[hvalueT
        if (((*(ptr + 0) == 'v')||(*(ptr + 0) == 'V'))&&
            ((*(ptr + 1) == 'a')||(*(ptr + 1) == 'A'))&&
            ((*(ptr + 2) == 'l')||(*(ptr + 2) == 'L'))&&
            ((*(ptr + 3) == 'u')||(*(ptr + 3) == 'U'))&&
            ((*(ptr + 4) == 'e')||(*(ptr + 4) == 'E')))
        {
            // value f[^̐擪܂Ń|C^𑗂
            ptr = ptr + 6;
            if ((*ptr == '"')||(*ptr == '\'')||(*ptr == ' ')||(*ptr == '='))
            {
                ptr++;
            }
            // f[^tempBuf2ɃRs[
            while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr != ' ')&&
                   (*ptr != '>')&&(loop < (BUFSIZE - 1)))
            {
                NNshGlobal->tempBuf2[loop] = *ptr;
                loop++;
                ptr++;
            }
            return;
        }
        ptr++;
    }
    return;
}

/**----------------------------------------------------------------------**
 **    name  valueworkbufɊi[
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void set_name_and_value(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char *value;

    // f[^l̏l tempBuf2
    value = NNshGlobal->tempBuf2;

    // [UH
    if (StrCaselessCompare(NNshGlobal->tempBuf, "username") == 0)
    {
        value = NNshParam->userName;
        goto ENTRY_DATA;
    }

    // [UH (M-zonȇΉ)
    if (StrCaselessCompare(NNshGlobal->tempBuf, "user") == 0)
    {
        value = NNshParam->userName;
        goto ENTRY_DATA;
    }

    // [UH (HotSpot̑Ή)
    if (StrCaselessCompare(NNshGlobal->tempBuf, "login_name") == 0)
    {
        value = NNshParam->userName;
        goto ENTRY_DATA;
    }

    // pX[hH
    if (StrCaselessCompare(NNshGlobal->tempBuf, "password") == 0)
    {
        value = NNshParam->password;
        goto ENTRY_DATA;
    }

ENTRY_DATA:
    if ((NNshGlobal->tempBuf[0] == '\0')||(*value == '\0'))
    {
        // name & value Ƃ̃f[^ĂȂ...I
        return;
    }

    // f[^擪ł͂Ȃ΁A "&" t
    if (StrLen(NNshGlobal->workBuf) != 0)
    {
        StrCat(NNshGlobal->workBuf, "&");
    }

    // name & value  i[
    StrCat(NNshGlobal->workBuf, NNshGlobal->tempBuf);
    StrCat(NNshGlobal->workBuf, "=");
    StrCat(NNshGlobal->workBuf, value);

    return;
}


/**----------------------------------------------------------------------**
 **    FORM^Ooł邩`FbN
 **
 **                  NNshGlobal->tempBufɌoʂi[
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void pickup_formTag(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char  *ptr;
    UInt16 loop;

    // FORM^O̐擪T
    NNshGlobal->tempPtr2 = StrStr(NNshGlobal->recvBuf, "<FORM");
    if (NNshGlobal->tempPtr2 == NULL)
    {
        NNshGlobal->tempPtr2 = StrStr(NNshGlobal->recvBuf, "<form");
    }
    if (NNshGlobal->tempPtr2 == NULL)
    {
        // FORM^O𔭌łȂAAA
        StrCopy(NNshGlobal->reqAddress, "/Authentication.php"); 
        return;
    }
#ifdef FORCE_LOGINPAGE_MOBILEPOINT
    // Imobilepoint̃OCy[WݒƂ
    StrCopy(NNshGlobal->reqAddress, "/Authentication.php"); 
    NNshGlobal->sendMethod = 
                           ((NNshGlobal->sendMethod)|(NNSHLOGIN_POST_METHOD));
    return;
#endif

    // f[^
    MemSet(NNshGlobal->tempBuf,  BUFSIZE, 0x00);

    loop = 0;
    ptr  = NNshGlobal->tempPtr2;

    // form^O̓e͂
    while ((ptr < (NNshGlobal->recvBuf + NNshParam->bufferSize))&&(*ptr != '>'))
    { 
        // L[[hname
        if (((*(ptr + 0) == 'a')||(*(ptr + 0) == 'A'))&&
            ((*(ptr + 1) == 'c')||(*(ptr + 1) == 'C'))&&
            ((*(ptr + 2) == 't')||(*(ptr + 2) == 'T'))&&
            ((*(ptr + 3) == 'i')||(*(ptr + 3) == 'I'))&&
            ((*(ptr + 4) == 'o')||(*(ptr + 4) == 'O'))&&
            ((*(ptr + 5) == 'n')||(*(ptr + 5) == 'N')))
        {
            // namef[^̐擪܂Ń|C^𑗂
            ptr = ptr + 6;
            while ((*ptr == '"')||(*ptr == '\'')||(*ptr <= ' ')||
                   (*ptr == '='))
            {
                ptr++;
            }

            // f[^tempBufɃRs[
            while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr > ' ')&&
                   (*ptr != '>')&&(loop < (BUFSIZE - 1)))
            {
                NNshGlobal->tempBuf[loop] = *ptr;
                loop++;
                ptr++;
            }
            break;
        }
        ptr++;
    }

    // \bhPOSTɌ肷(̂肩...KvGETΉ...)
    NNshGlobal->sendMethod = 
                           ((NNshGlobal->sendMethod)|(NNSHLOGIN_POST_METHOD));

    // POSTy[W肷
    if (*(NNshGlobal->tempBuf) == '/')
    {
        MemSet (NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
        StrCopy(NNshGlobal->reqAddress, NNshGlobal->tempBuf);
        return;
    }

    // y[W͑΃AhXȂ̂ŁA݂̗vpath𐶂悤ɂ
    NNshGlobal->loopCount = StrLen(NNshGlobal->reqAddress);
    while (NNshGlobal->loopCount != 0)
    {
        (NNshGlobal->loopCount)--;
        if (NNshGlobal->reqAddress[NNshGlobal->loopCount] == '/')
        {
            break;
        }
    }
    NNshGlobal->reqAddress[NNshGlobal->loopCount] = '/';
    (NNshGlobal->loopCount)++;
    NNshGlobal->reqAddress[NNshGlobal->loopCount] = '\0';
    StrCat(NNshGlobal->reqAddress, NNshGlobal->tempBuf);
    return;
}


/**************************************************************************/
/*   CookieE                                                         */
/*                                                                        */
/*                                                                        */
/**************************************************************************/
void pickup_cookie(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char *ptr;

    MemSet(NNshGlobal->cookie, (BUFSIZE + MARGIN), 0x00);
    ptr = StrStr(NNshGlobal->recvBuf, "Set-Cookie");
    if (ptr == NULL)
    {
        // cookie̎w肪ȂAI
        return;
    }

    // Cookief[^Rs[
    ptr = ptr + StrLen("Set-");
    MemMove(NNshGlobal->cookie, ptr, BUFSIZE);
    ptr = NNshGlobal->cookie;
    while ((*ptr != ';')&&(*ptr != '\0'))
    {
        ptr++;
    }
    *ptr = '\0';
    return;
}
