/*============================================================================*
 *  $Id: struct.h,v 1.7 2004/10/21 14:54:45 mrsa Exp $
 *
 *  FILE: 
 *     struct.h
 *
 *  Description: 
 *     structure definitions for Palm application.
 *
 *===========================================================================*/

/********** My Local structures **********/

// UnicodeToJis0208 e[uR[h
typedef struct
{
    UInt16 size;
    UInt16 table[256];
} UnicodeToJis0208Rec;

// Jis0208ToUnicode e[uR[h
typedef struct
{
    UInt16 code;
} Jis0208ToUnicodeRec;

// DB ̏擾p
typedef struct {
    Char    *nameP;
    UInt16  *attributesP;
    UInt16  *versionP;
    UInt32  *crDateP;
    UInt32  *modDateP;
    UInt32  *bckUpDateP;
    UInt32  *modNumP;
    LocalID *appInfoIDP;
    LocalID *sortInfoIDP;
    UInt32  *typeP;
    UInt32  *creatorP;
} NNshDBInfo;

// NNsĩXgACeID
typedef struct {
  UInt16  popId;
  UInt16  lstId;
} NNshListItem;

// o[W(VXePreferenceɋL^\)
typedef struct {
    UInt32  NNsiVersion;
    UInt32  prefSize;
    UInt16  prefType;
    UInt16  debugMode;
} NNshSoftwareVersionInfo;

typedef struct {
    UInt16 up;              // n[hL[
    UInt16 down;            // n[hL[
    UInt16 key1;            // n[hL[P
    UInt16 key2;            // n[hL[Q
    UInt16 key3;            // n[hL[R
    UInt16 key4;            // n[hL[S
} NNshHardkeyControl;

// VXe(NɃf[^x[Xǂݍޏ)
typedef struct {
    /** NNsiݒ **/
    UInt16  debugMessageON;            // fobObZ[W̕\
    UInt8   getMessageHeader;          // bZ[Wwb_擾
    UInt8   confirmationDisable;       // mF_CAOȗ
    UInt16  disconnect;                // Iɉؒf
    UInt16  protocol;                  // ʐMvgR
    UInt16  portNum;                   // ʐM|[gԍ
    Int32   timeout;                   // ʐM^CAEgl
    Char    hostName[BUFSIZE];         // zXg
    Char    userName[NOFISP][BUFSIZE]; // [U
    Char    password[NOFISP][BUFSIZE]; // pX[h
    UInt16  useHardKeyControl;         // n[hL[{
    UInt16  bufferSize;                // obt@TCY
    NNshHardkeyControl useKey;         // n[hL[̃L[ԍi[̈
    UInt32  reserved[DB_RESERVE_AREA]; // \̈
} NNshSavedPref;

//  ŜŎgpO[ö
typedef struct
{
    FormType     *currentForm;
    FormType     *previousForm;
    FormType     *prevBusyForm;
    ControlType  *selP;
    UInt16        btnId;
    UInt16        netRef;
    UInt16        err;
    UInt16        ret;
    UInt16        loopCount;
    NetSocketRef  socketRef;
    UInt16        sslRef;
    SslLib       *sslTemplate;
    SslContext   *sslContext;
    Char         *tempPtr2;
    Char         *tempPtr;
    Char         *sendBuf;
    Char         *recvBuf;
    Char         *workBuf;
    UInt16        isChecking;
    UInt16        isRedirect;
    UInt16        setPass;
    UInt16        sendMethod;
    UInt32        palmOSVersion;
    Char          tempBuf   [BUFSIZE];
    Char          tempBuf2  [BUFSIZE];
    Char          reqAddress[BUFSIZE * 2];
#ifdef USE_REFERER
    Char          referer   [BUFSIZE];
#endif
    Char          cookie    [BUFSIZE + MARGIN];
} NNshWorkingInfo;

