#include <QString>
#include <QDir>
#include <QFileInfo>
#include <QMessageBox>
#include "GikoNaviBrowserParser.h"
#include "GikoNaviIdxParser.h"
#include "bbsTableParser.h"
#include "datFileUtil.h"

/**
 *  RXgN^
 * 
 */
GikoNaviBrowserParser::GikoNaviBrowserParser()
 : mpBbsTableParser(0), mBbsTable(0), mLogPath(0)
{
    // ł͉Ȃ
}


/**
 *  fXgN^
 * 
 */
GikoNaviBrowserParser::~GikoNaviBrowserParser()
{
    // ł͉Ȃ
}

/**
 *   uEÛ̖
 * 
 */
QString GikoNaviBrowserParser::getBrowserName(void)
{
    QString name = "GikoNavi";
    return (name);
}

/**
 *   ǗpX̎w...
 * 
 */
void GikoNaviBrowserParser::setPath(QString &arPath)
{
    mLogPath = arPath;
    //QMessageBox::information(0, "LOG PATH", mLogPath, QMessageBox::Ok);
}

/**
 *   bbstable.html̎w...
 * 
 */
void GikoNaviBrowserParser::setBbsTable(bbsTableParser *apBbsTable, QString &arBbsTable)
{
    // BBS̓NX
    mpBbsTableParser = apBbsTable;

    // bbstable.html
    mBbsTable = arBbsTable;
}

/**
 *   ͂̏...
 * 
 */    
bool GikoNaviBrowserParser::prepare(void)
{
    clearAcquiredParser();

    bool ret = checkDirectory(mLogPath);
    return (ret);
}

/**
 *   ͂̏(fBNg@...)
 * 
 */    
bool GikoNaviBrowserParser::checkDirectory(QString &arPath)
{
    QDir targetDir(arPath);
    QFileInfoList fileList = targetDir.entryInfoList();
    for (QFileInfoList::const_iterator ite = fileList.constBegin(); ite != fileList.constEnd(); ite++)
    {
        QFileInfo fileInfo = (*ite);
        if (fileInfo.isDir() == true)
        {
            QString filePath = fileInfo.absoluteFilePath();
            if (filePath.endsWith(".") != true)
            {
                checkDirectory(filePath);
            }
        }

        // t@Cǂ`FbN
        if (fileInfo.isFile() == true)
        {
            // OǗf[^t@C...
            if ( fileInfo.fileName() == "Folder.idx")
            {
                QString filePath = fileInfo.absolutePath();
                int pos = filePath.lastIndexOf("/");
                QString nickName = filePath.mid(pos + 1);
                QString idxFile = fileInfo.absolutePath() + "/Folder.idx";
                parseIndexFile(nickName, idxFile);
            }
        }
    }
    return (true);
}

/**
 *  MRir̖ǈʒuǗt@C̓ǂݏo...
 * 
 * 
 */
void GikoNaviBrowserParser::parseIndexFile(QString &arNickName, QString &arFileName)
{
    //QMessageBox::information(0, "Info(index File)", arNickName + " | " + arFileName, QMessageBox::Ok);
    GikoNaviIdxParser *parser = new GikoNaviIdxParser(arNickName);
    parser->parseFile(arFileName, mDatFileList);
    mAcquiredParser.append(parser);
    return;
}

/**
 *  MRirǗĂdatt@C̐
 * 
 */
int GikoNaviBrowserParser::datFileCount(void)
{
    return (mDatFileList.size());
}

/**
 *   ǗOdatt@C`FbN
 * 
 */
int  GikoNaviBrowserParser::checkUnmanagedDatFile(void)
{
    return (0);
}

/**
 *   ǗOdatt@C擾
 * 
 */
QString GikoNaviBrowserParser::getUnmanagedDatFileName(int aIndex)
{
    return ("");
}

/**
 *   ǗOdatNick擾
 * 
 */
QString GikoNaviBrowserParser::getUnmanagedDatNickName(int aIndex)
{
    return ("");
}

/**
 *   datt@C(full path)𐶐
 * 
 */
QString GikoNaviBrowserParser::getFullPathDatFileName(QString &arNick, QString &arFileName)
{
    QString datName = mLogPath + "/2ch/" + arNick + arFileName;
    return (datName);
}

/*!
 *   datt@C(full path)𐶐
 * 
 */
QString GikoNaviBrowserParser::getReceiveDatFileName(QString &arNick, QString &arFileName)
{
    QDir path(mLogPath);
    path.mkpath(mLogPath + "/2ch/" + arNick);

    QString fileName = arFileName;
    int pos = arFileName.indexOf(".");
    fileName = arFileName.left(pos);

    QString datName = mLogPath + "/2ch/" + arNick + fileName + ".dat";
    return (datName);
}

/**
 *  datt@C擾
 * 
 */
QString GikoNaviBrowserParser::getDatFileName(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mDatFileList.size()))
    {
        return ("");
    }
    QString datFile = mDatFileList.at(aIndex);
    QStringList dataList = datFile.split("|");
    
    return (dataList.at(1));    
}

/**
 *  Nick擾
 * 
 */
QString GikoNaviBrowserParser::getBoardNick(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mDatFileList.size()))
    {
        return ("");
    }
    QString datFile = mDatFileList.at(aIndex);
    QStringList dataList = datFile.split("|");
    
    return (dataList.at(0));  
}

/**
 *  ǈʒu̎擾
 * 
 */
int  GikoNaviBrowserParser::getReadPoint(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mDatFileList.size()))
    {
        return (1);
    }
    QString datFile = mDatFileList.at(aIndex);
    QStringList dataList = datFile.split("|");
    int point = (dataList.at(2)).toInt();
    return (point);
}

/**
 *   subject.txt̃t@C(full path)擾
 * 
 */
QString GikoNaviBrowserParser::getSubjectTxtFilePath(QString &arNick)
{
    QString datName = mLogPath + "/2ch/" + arNick + "subject.txt";
    return (datName);
}

/**
 *  ŏIXVԂ̎擾
 * 
 */
qint64 GikoNaviBrowserParser::getLastUpdate(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mDatFileList.size()))
    {
        return (0);
    }
    QString datFile = mDatFileList.at(aIndex);
    QStringList dataList = datFile.split("|");
    int point = (dataList.at(3)).toInt();
    return (point);
}

/**
 *   datt@CM
 * 
 */
bool GikoNaviBrowserParser::receiveDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
//    QMessageBox::information(0, "Info(entry File)", arNick + " | " + arFile, QMessageBox::Ok);

    // t@Cړ
    datFileUtil util;
    util.moveDatFile(arSrc, isSame, arDst, false);

    // ǗXV
    return (updateInformations(arNick, arFile, arDst, arSrc, isSame, aReadPoint, aLastUpdate));
}

/**
 *   datt@CRs[
 * 
 */
bool GikoNaviBrowserParser::copyDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
//    QMessageBox::information(0, "Info(copy File)", arNick + " | " + arFile + " - ", QMessageBox::Ok);

    // t@CRs[
    datFileUtil util;
    util.copyDatFile(arSrc, isSame, arDst, false);

    // ǗXV
    return (updateInformations(arNick, arFile, arDst, arSrc, isSame, aReadPoint, aLastUpdate));
}

/**
 *   ǗXV
 * 
 */
bool GikoNaviBrowserParser::updateInformations(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
    // t@C擾
    datFileUtil datFileUtility;
    QString path = getReceiveDatFileName(arNick, arFile);
    QString target = "/" + arFile;
    path.replace(target, "");
    QString title = datFileUtility.pickupDatFileTitle(path, arFile);
    int    nofMsg = datFileUtility.checkResCount(path, arFile);

    QString boardNick = arNick;
    boardNick.replace("/", "");
    GikoNaviIdxParser *parser = 0;
    int index = -1;
    int limit = mAcquiredParser.size();

    for (int loop = 0; loop < limit; loop++)
    {
        GikoNaviIdxParser *checkParser = mAcquiredParser.at(loop);
        if (checkParser != 0)
        {
            QString myNick = checkParser->getMyNick();
            myNick.replace("/", "");
            if (myNick == boardNick)
            {
                index = checkParser->exists(arFile);
                parser = checkParser;
                if (index >= 0)
                {
                    // o^ς...XV
                    checkParser->updateReadPoint(index, aReadPoint, nofMsg, aLastUpdate);
                }
                break;
            }   
        }
    }

    if (index < 0)
    {
        if (parser == 0)
        {
            // Folder.idxǉ
            QString indexPath = getReceiveDatFileName(arNick, arFile);
            indexPath.replace(arFile, "Folder.idx");
            parser = new GikoNaviIdxParser(boardNick);
            parser->parseFile(indexPath, mDatFileList);
            mAcquiredParser.append(parser);
        }

        // ACeǉo^
        if (parser != 0)
        {
            parser->appendData(arFile, title, nofMsg, aReadPoint, aLastUpdate);
        }
    }
    return (true);
}

/**
 *   Ƃ܂s (Folder.idx o͂...)
 * 
 */
bool GikoNaviBrowserParser::finalize(void)
{
   int limit = mAcquiredParser.size();
   for (int loop = 0; loop < limit; loop++)
   {
        mAcquiredParser[loop]->outputFile();
   }
   return (true);
}

/**
 *   GikoNaviIdxParserNA
 * 
 */
void GikoNaviBrowserParser::clearAcquiredParser(void)
{
   int limit = mAcquiredParser.size();
   for (int loop = limit; loop > 0; loop--)
   {
        delete mAcquiredParser[loop];
   }    
   mAcquiredParser.clear();
   mDatFileList.clear();
   return;
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2007- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
