/**
 *   a2BCfavoriteBbsEditor
 * 
 *    []
 *      CɓҏWNX
 * 
 */
#include <QTextCodec>
#include <QString>
#include <QMessageBox>
#include <QTableView>
#include <QStandardItemModel>
#include <QDialog>
#include "screenControl.h"
#include "a2BCfavoriteBbsEditor.h"

/**
 *  RXgN^
 * 
 */
a2BCfavoriteBbsEditor::a2BCfavoriteBbsEditor(QObject *parent)
 : QObject(parent)
{
}

/**
 *  fXgN^
 * 
 */
a2BCfavoriteBbsEditor::~a2BCfavoriteBbsEditor()
{
    //
}


/**
 *  NX̏...
 * 
 * 
 */
void a2BCfavoriteBbsEditor::prepare(screenData *dbData, QTableView *tableViewWidget)
{
    mpDB                  = dbData;
    mpBbsTableTableWidget = tableViewWidget;
}

/**
 *  bbstable.htmlǂݍ
 * 
 */
bool a2BCfavoriteBbsEditor::readBbsTableInformations()
{
    // ꗗf[^̓ǂݍݏ
    QString fileName = mpDB->getBbsTableFileName();

    mBbsTableTrimmer.resetTrimmer();
    bool readyBbs = mBbsTableTrimmer.prepareTrimmer(fileName);
    if (readyBbs == false)
    {
        // ꗗ͎̉s...I
        return (false);
    }

    // fݒ肷
    mpBbsTableTableWidget->setModel(mBbsTableTrimmer.getTrimmerModel());

    QStringList tableHeader;
    tableHeader << tr("Board Name") << tr("Board Url") << tr("Sort Key");
    (mBbsTableTrimmer.getTrimmerModel())->setHorizontalHeaderLabels(tableHeader);

    QString message = tr("read :") + " " + fileName;
    emit updateMessage(message);

    return (true);
}

/**
 *  e[u̕ҏWJn...
 * 
 */
void a2BCfavoriteBbsEditor::startBbsTableEditor()
{
    // e[uEBWFbg̏ǂݏo...
    QStandardItemModel *itemModel = mBbsTableTrimmer.getTrimmerModel();
    int count = itemModel->rowCount();
    if (count == 0)
    {
        // 擾ς݂BBS𒊏o
        QString fileName = mpDB->getBbsTableFileName();
        mBbsTableTrimmer.readA2BLogBoards(fileName);
    }
    mpBbsTableTableWidget->resizeRowsToContents();    
    mpBbsTableTableWidget->resizeColumnsToContents();    
}

/**
 *  bbstable.htmlۑ
 * 
 */
void a2BCfavoriteBbsEditor::saveBbsTableInformations()
{

/****
    // T|[gĂ codec𒊏oĂ݂...
    QString msg = "";
    QList<QByteArray> codecLists;
    codecLists = QTextCodec::availableCodecs();
    for (int i = 0; i < codecLists.size(); ++i)
    {
        msg = msg + " " + codecLists.at(i);
    }
    QMessageBox::information(0, "codec list", msg);
****/

    if (QMessageBox::question(0, tr("Save bbstable.html"), tr("update favorite BBS, are you ready?"), ((QMessageBox::Ok)|(QMessageBox::Cancel))) != QMessageBox::Ok)
    {
        // ɐ܂ԂBBB
        return;
    }

    // e[uEBWFbg̏ǂݏoāAݒ肵ďށB
    QStandardItemModel *itemModel = mBbsTableTrimmer.getTrimmerModel();

    // e[ug}ɒ...
    int count = itemModel->rowCount();
    for (int loop = 0; loop < count; loop++)
    {
        QModelIndex name = itemModel->index(loop, 0);
        QModelIndex url  = itemModel->index(loop, 1);
        QString boardData = (url.data()).toString() + ">" + (name.data()).toString();
        QByteArray outputData = boardData.toLocal8Bit();
        mBbsTableTrimmer.appendTrimmer(outputData);
    }    

    // bbstable.html 
    mBbsTableTrimmer.outputTrimmer();
    emit savedBbsEditor();

    // ̏I񍐂s
    QString message;
    message.setNum(count);
    message = tr("bbstable.html is updated.") + "\n\t"+ tr("count :") + " " + message;
    emit updateMessage(message);

    QMessageBox::information(0, tr("Saved bbstable.html"), message);
}

/**
 *  폜
 * 
 */
void a2BCfavoriteBbsEditor::deleteBoardBbsInformation()
{
    // Is𒊏o
    QStandardItemModel  *itemModel      = mBbsTableTrimmer.getTrimmerModel();
    QItemSelectionModel *selectionModel = mpBbsTableTableWidget->selectionModel();
    int count     = itemModel->rowCount();
    int selCount  = 0;
    QString titles = "";
    QVector<int> indexList;
    for (int loop = 0; loop < count; loop++)
    {
        if (selectionModel->isRowSelected(loop,  QModelIndex()) == true)
        {
            QModelIndex modelIndex = itemModel->index(loop, 0);
            selCount++;
            titles = titles + " " + (itemModel->data(modelIndex)).toString();
            indexList.append(loop);
        }
    }
    if (selCount == 0)
    {
        // 폜Ώۍs݂Ȃ...̂܂܏I
        return;
    }

    QString message = "'" + titles + " '" + tr("will be removed, are you ok?") + "\n";
    int reply = QMessageBox::question(0, tr("Confirmation"), message, QMessageBox::Yes, QMessageBox::No, QMessageBox::NoButton);
    if (reply != QMessageBox::Yes)
    {
        return;
    }

    // 폜̎{
    for (int loop = indexList.count(); loop > 0; loop--)
    {
        itemModel->removeRows(indexList[loop - 1], 1, QModelIndex());
    }
    return;
}

/**
 *  ǉ
 * 
 */
void a2BCfavoriteBbsEditor::appendBoardBbsInformation()
{
    // ǉ_CAO
    QDialog            addDialog;
    Ui::addBoardDialog addBoardDialog;
    addBoardDialog.setupUi(&addDialog);
    
    // ǉ_CAO[__CAOƂĕ\
    addDialog.setModal(true);
    int retCode = addDialog.exec();
    if (retCode != QDialog::Accepted)
    {
        // OK{^ꂸɃLZꂽ...I
        return;
    }

    // ͂ꂽe(e[u)o^B
    QString boardName = (addBoardDialog.edtBoardName)->text();
    QString boardUrl  = (addBoardDialog.edtBoardUrl)->text();
    QString sortKey   = (addBoardDialog.edtSortKeyWord)->text();
    mBbsTableTrimmer.entryBbsData(boardName, boardUrl, sortKey);

    // ǉƂʕ\
    QMessageBox::information(0, tr("Board Appended"), tr("data appended.") + "\n\n- - - - -\n" + tr("Name") + " : " + boardName + "\n" + tr("Url ") + " : " + boardUrl);
    return;
}

/**
 *  𒊏o
 * 
 */
void a2BCfavoriteBbsEditor::pickupBoardBbsInformation()
{
    mBbsTableTrimmer.clearLogBoardData();

    QStringList tableHeader;
    tableHeader << tr("Board Name") << tr("Board Url") << tr("Sort Key");
    (mBbsTableTrimmer.getTrimmerModel())->setHorizontalHeaderLabels(tableHeader);

    QString fileName = mpDB->getBbsTableFileName();
    mBbsTableTrimmer.readA2BLogBoards(fileName);

    mpBbsTableTableWidget->resizeRowsToContents();    
    mpBbsTableTableWidget->resizeColumnsToContents();    
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
